/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.contextmanagement.ContextManagementTemplateService;
import org.opensearch.ml.common.contextmanager.ContextManagementTemplate;
import org.opensearch.ml.common.transport.contextmanagement.MLGetContextManagementTemplateRequest;
import org.opensearch.ml.common.transport.contextmanagement.MLGetContextManagementTemplateResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class GetContextManagementTemplateTransportAction
extends HandledTransportAction<MLGetContextManagementTemplateRequest, MLGetContextManagementTemplateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetContextManagementTemplateTransportAction.class);
    private final Client client;
    private final ContextManagementTemplateService contextManagementTemplateService;

    @Inject
    public GetContextManagementTemplateTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ContextManagementTemplateService contextManagementTemplateService) {
        super("cluster:admin/opensearch/ml/context_management/get", transportService, actionFilters, MLGetContextManagementTemplateRequest::new);
        this.client = client;
        this.contextManagementTemplateService = contextManagementTemplateService;
    }

    protected void doExecute(Task task, MLGetContextManagementTemplateRequest request, ActionListener<MLGetContextManagementTemplateResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            log.debug("Getting context management template: {}", (Object)request.getTemplateName());
            this.contextManagementTemplateService.getTemplate(request.getTemplateName(), (ActionListener<ContextManagementTemplate>)ActionListener.wrap(template -> {
                if (template != null) {
                    log.debug("Successfully retrieved context management template: {}", (Object)request.getTemplateName());
                    listener.onResponse((Object)new MLGetContextManagementTemplateResponse(template));
                } else {
                    log.warn("Context management template not found: {}", (Object)request.getTemplateName());
                    listener.onFailure((Exception)new RuntimeException("Context management template not found: " + request.getTemplateName()));
                }
            }, exception -> {
                log.error("Error getting context management template: {}", (Object)request.getTemplateName(), exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            log.error("Unexpected error getting context management template: {}", (Object)request.getTemplateName(), (Object)e);
            listener.onFailure(e);
        }
    }
}

