/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import java.io.IOException;
import java.security.PublicKey;
import org.cryptacular.CryptUtil;
import org.cryptacular.EncodingException;
import org.cryptacular.StreamException;
import org.cryptacular.bean.FactoryBean;
import org.cryptacular.io.Resource;
import org.cryptacular.util.KeyPairUtil;

public class ResourceBasedPublicKeyFactoryBean
implements FactoryBean<PublicKey> {
    private final Resource resource;

    public ResourceBasedPublicKeyFactoryBean(Resource resource) {
        this.resource = CryptUtil.assertNotNullArg(resource, "Resource cannot be null");
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public PublicKey newInstance() throws EncodingException, StreamException {
        try {
            return KeyPairUtil.readPublicKey(this.resource.getInputStream());
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }
}

