/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.regex.Pattern;
import org.cryptacular.CryptUtil;
import org.cryptacular.codec.Base64Decoder;
import org.cryptacular.util.ByteUtil;

public final class PemUtil {
    private static final Pattern PEM_SPLITTER = Pattern.compile("-----(?:BEGIN|END) [A-Z ]+-----");
    private static final Pattern LINE_SPLITTER = Pattern.compile("[\r\n]+");

    private PemUtil() {
    }

    public static boolean isPem(byte[] data) {
        CryptUtil.assertNotNullArgOr(data, v -> ((byte[])v).length < 64, "Data must be at least 64 bytes long");
        String start = new String(data, 0, 10, ByteUtil.ASCII_CHARSET).trim();
        if (!(start.startsWith("-----BEGIN") || start.startsWith("---- BEGIN") || start.startsWith("Proc-Type:"))) {
            for (int i = 0; i < 64; ++i) {
                if (PemUtil.isBase64Char(data[i])) continue;
                if (i > 61) {
                    if (data[i] == 61) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isBase64Char(byte b) {
        return b >= 47 && b <= 122 && (b <= 57 || b >= 65) && (b <= 90 || b >= 97) || b == 43;
    }

    public static byte[] decode(byte[] pem) {
        return PemUtil.decode(new String(CryptUtil.assertNotNullArg(pem, "PEM cannot be null"), ByteUtil.ASCII_CHARSET));
    }

    public static byte[] decode(String pem) {
        CryptUtil.assertNotNullArg(pem, "PEM cannot be null");
        Base64Decoder decoder = new Base64Decoder();
        CharBuffer buffer = CharBuffer.allocate(pem.length());
        ByteBuffer output = ByteBuffer.allocate(pem.length() * 3 / 4);
        for (String object : PEM_SPLITTER.split(pem)) {
            buffer.clear();
            for (String line : LINE_SPLITTER.split(object)) {
                if (line.startsWith("DEK-Info:") || line.startsWith("Proc-Type:")) continue;
                buffer.append(line);
            }
            buffer.flip();
            decoder.decode(buffer, output);
            decoder.finalize(output);
        }
        output.flip();
        return ByteUtil.toArray(output);
    }
}

