/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.criterion;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class BindingCriterion
implements Criterion {
    @Nonnull
    private final List<String> bindings;

    public BindingCriterion(@Nonnull List<String> bindingURIs) {
        this.bindings = CollectionSupport.copyToList(StringSupport.normalizeStringCollection(bindingURIs));
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public List<String> getBindings() {
        return this.bindings;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BindingCriterion [bindings=");
        builder.append(this.bindings);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.bindings.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof BindingCriterion) {
            BindingCriterion other = (BindingCriterion)obj;
            return this.bindings.equals(other.bindings);
        }
        return false;
    }
}

