/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsListener;
import com.intellij.internal.statistic.eventLog.EventLogConfigOptionsService;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogSystemCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUpdateError;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogMetadataUpdateStage;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.validator.IGroupValidators;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.CustomRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.UtilRuleProducer;
import com.intellij.internal.statistic.eventLog.validator.storage.CompositeValidationRulesStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesPersistedStorage;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import com.jetbrains.fus.reporting.DictionaryUpdate;
import com.jetbrains.fus.reporting.FileHandle;
import com.jetbrains.fus.reporting.FileStorage;
import com.jetbrains.fus.reporting.FileStorageMode;
import com.jetbrains.fus.reporting.FusClientConfig;
import com.jetbrains.fus.reporting.FusHttpClient;
import com.jetbrains.fus.reporting.FusJsonSerializer;
import com.jetbrains.fus.reporting.FusLoggerFactory;
import com.jetbrains.fus.reporting.LoadError;
import com.jetbrains.fus.reporting.LoadErrorType;
import com.jetbrains.fus.reporting.MessageBus;
import com.jetbrains.fus.reporting.MessageHandler;
import com.jetbrains.fus.reporting.MetadataStorage;
import com.jetbrains.fus.reporting.MetadataStorageKt;
import com.jetbrains.fus.reporting.RegionCode;
import com.jetbrains.fus.reporting.RemoteConfig;
import com.jetbrains.fus.reporting.RemoteConfigKt;
import com.jetbrains.fus.reporting.defaults.DefaultMetadataStorage;
import com.jetbrains.fus.reporting.defaults.DefaultRemoteConfig;
import com.jetbrains.fus.reporting.defaults.MetadataUpdateDelay;
import com.jetbrains.fus.reporting.defaults.NoOpLoggerFactory;
import com.jetbrains.fus.reporting.jvm.InMemoryJvmFileStorage;
import com.jetbrains.fus.reporting.jvm.JvmFileStorage;
import com.jetbrains.fus.reporting.jvm.JvmHttpClient;
import com.jetbrains.fus.reporting.jvm.ProxyInfo;
import com.jetbrains.fus.reporting.jvm.ProxyProvider;
import com.jetbrains.fus.reporting.model.serialization.SerializationException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0006\u001b\u001c\u001d\u001e\u001f B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\b\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00052\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012J\u001a\u0010\u0013\u001a\u00020\u0010*\u00020\u00142\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u001a\u0010\u0017\u001a\u00020\u0010*\u00020\u00142\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider;", "", "<init>", "()V", "CUSTOM_FUS_SCHEMA_DIR_PROPERTY", "", "FUS_METADATA_DIR", "getMetadataDir", "Ljava/nio/file/Path;", "recorderId", "getMetadataConfigRoot", "loadErrorToEventLogMetadataUpdateError", "Lcom/intellij/internal/statistic/eventLog/connection/metadata/EventLogMetadataUpdateError;", "loadError", "Lcom/jetbrains/fus/reporting/LoadError;", "updateOptions", "", "options", "", "listenToOptionsChanges", "Lkotlinx/coroutines/CoroutineScope;", "messageBus", "Lcom/jetbrains/fus/reporting/MessageBus;", "listenToMetadataEvents", "createBlindFusComponents", "Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider$FusComponents;", "createFusComponents", "FusComponents", "BlindMetadataStorage", "BlindRemoteConfig", "BundledJvmFileStorage", "FusJacksonSerializer", "CustomPrettyPrinter", "intellij.platform.statistics"})
@ApiStatus.Internal
public final class FusComponentProvider {
    @NotNull
    public static final FusComponentProvider INSTANCE = new FusComponentProvider();
    @NotNull
    public static final String CUSTOM_FUS_SCHEMA_DIR_PROPERTY = "intellij.fus.custom.schema.dir";
    @NotNull
    public static final String FUS_METADATA_DIR = "event-log-metadata";

    private FusComponentProvider() {
    }

    private final Path getMetadataDir(String recorderId) throws IOException {
        Path path = this.getMetadataConfigRoot().resolve(StringUtil.toLowerCase((String)recorderId)).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        return path;
    }

    private final Path getMetadataConfigRoot() {
        String customFusPath = System.getProperty(CUSTOM_FUS_SCHEMA_DIR_PROPERTY);
        if (!StringUtil.isEmpty((String)customFusPath)) {
            Path path = Path.of(customFusPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            return path;
        }
        Path path = PathManager.getConfigDir().resolve(FUS_METADATA_DIR);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    private final EventLogMetadataUpdateError loadErrorToEventLogMetadataUpdateError(LoadError loadError) {
        return switch (WhenMappings.$EnumSwitchMapping$0[loadError.getErrorType().ordinal()]) {
            case 1 -> new EventLogMetadataUpdateError(loadError){
                final /* synthetic */ LoadError $loadError;
                {
                    this.$loadError = $loadError;
                }

                public String getErrorType() {
                    return "ERROR_ON_LOAD";
                }

                public int getErrorCode() {
                    return this.$loadError.getStatusCode();
                }

                public EventLogMetadataUpdateStage getUpdateStage() {
                    return EventLogMetadataUpdateStage.LOADING;
                }
            };
            case 2 -> new EventLogMetadataUpdateError(loadError){
                final /* synthetic */ LoadError $loadError;
                {
                    this.$loadError = $loadError;
                }

                public String getErrorType() {
                    return "INVALID_JSON";
                }

                public int getErrorCode() {
                    return this.$loadError.getStatusCode();
                }

                public EventLogMetadataUpdateStage getUpdateStage() {
                    return EventLogMetadataUpdateStage.PARSING;
                }
            };
            case 3 -> new EventLogMetadataUpdateError(loadError){
                final /* synthetic */ LoadError $loadError;
                {
                    this.$loadError = $loadError;
                }

                public String getErrorType() {
                    return "UNKNOWN_IO_ERROR";
                }

                public int getErrorCode() {
                    return this.$loadError.getStatusCode();
                }

                public EventLogMetadataUpdateStage getUpdateStage() {
                    return EventLogMetadataUpdateStage.LOADING;
                }
            };
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void updateOptions(@NotNull String recorderId, @NotNull Map<String, String> options) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        EventLogMetadataSettingsPersistence persisted = EventLogMetadataSettingsPersistence.getInstance();
        Map<String, String> map = persisted.updateOptions(recorderId, options);
        Intrinsics.checkNotNullExpressionValue(map, (String)"updateOptions(...)");
        Map<String, String> changedOptions = map;
        if (!changedOptions.isEmpty()) {
            com.intellij.util.messages.MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic<EventLogConfigOptionsListener> topic = EventLogConfigOptionsService.TOPIC;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
            ((EventLogConfigOptionsListener)messageBus.syncPublisher(topic)).optionsChanged(recorderId, changedOptions);
        }
    }

    public final void listenToOptionsChanges(@NotNull CoroutineScope $this$listenToOptionsChanges, @NotNull String recorderId, @NotNull MessageBus messageBus) {
        Intrinsics.checkNotNullParameter((Object)$this$listenToOptionsChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        new MessageHandler(messageBus, $this$listenToOptionsChanges, RemoteConfigKt.getREMOTE_CONFIG_OPTIONS_UPDATED(), null, (Function2)new Function2<Map<String, ? extends String>, Continuation<? super Unit>, Object>(recorderId, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ String $recorderId;
            {
                this.$recorderId = $recorderId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                Map map = (Map)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void options;
                        ResultKt.throwOnFailure((Object)$result);
                        FusComponentProvider.INSTANCE.updateOptions(this.$recorderId, (Map<String, String>)options);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Map<String, String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
    }

    public final void listenToMetadataEvents(@NotNull CoroutineScope $this$listenToMetadataEvents, @NotNull String recorderId, @NotNull MessageBus messageBus) {
        Intrinsics.checkNotNullParameter((Object)$this$listenToMetadataEvents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        EventLogSystemCollector systemCollector = StatisticsEventLogProviderUtil.getEventLogProvider(recorderId).getEventLogSystemLogger$intellij_platform_statistics();
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getMETADATA_LOADED_TOPIC(), null, (Function2)new Function2<String, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                String string = (String)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void version;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logMetadataLoaded((String)version);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getMETADATA_LOAD_FAILED_TOPIC(), null, (Function2)new Function2<LoadError, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                LoadError loadError = (LoadError)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void loadError2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logMetadataLoadFailed(FusComponentProvider.access$loadErrorToEventLogMetadataUpdateError(FusComponentProvider.INSTANCE, (LoadError)loadError2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(LoadError p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getMETADATA_UPDATED_TOPIC(), null, (Function2)new Function2<String, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                String string = (String)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void version;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logMetadataUpdated((String)version);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(String p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getMETADATA_UPDATE_FAILED_TOPIC(), null, (Function2)new Function2<LoadError, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                LoadError loadError = (LoadError)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void loadError2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logMetadataUpdateFailed(FusComponentProvider.access$loadErrorToEventLogMetadataUpdateError(FusComponentProvider.INSTANCE, (LoadError)loadError2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(LoadError p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getDICTIONARY_LIST_LOAD_FAILED_TOPIC(), null, (Function2)new Function2<LoadError, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                LoadError loadError = (LoadError)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void loadError2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logDictionaryListLoadFailed(FusComponentProvider.access$loadErrorToEventLogMetadataUpdateError(FusComponentProvider.INSTANCE, (LoadError)loadError2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(LoadError p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getDICTIONARY_LIST_UPDATE_FAILED_TOPIC(), null, (Function2)new Function2<LoadError, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                LoadError loadError = (LoadError)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void loadError2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logDictionaryListUpdateFailed(FusComponentProvider.access$loadErrorToEventLogMetadataUpdateError(FusComponentProvider.INSTANCE, (LoadError)loadError2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(LoadError p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getDICTIONARY_LOADED_TOPIC(), null, (Function2)new Function2<DictionaryUpdate, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DictionaryUpdate dictionaryUpdate = (DictionaryUpdate)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void update;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logDictionaryLoaded(update.getTimestamp());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DictionaryUpdate p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getDICTIONARY_LOAD_FAILED_TOPIC(), null, (Function2)new Function2<LoadError, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                LoadError loadError = (LoadError)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void loadError2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logDictionaryLoadFailed(FusComponentProvider.access$loadErrorToEventLogMetadataUpdateError(FusComponentProvider.INSTANCE, (LoadError)loadError2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(LoadError p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getDICTIONARY_UPDATED_TOPIC(), null, (Function2)new Function2<DictionaryUpdate, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DictionaryUpdate dictionaryUpdate = (DictionaryUpdate)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void update;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logDictionaryUpdated(update.getTimestamp());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(DictionaryUpdate p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
        new MessageHandler(messageBus, $this$listenToMetadataEvents, MetadataStorageKt.getDICTIONARY_UPDATE_FAILED_TOPIC(), null, (Function2)new Function2<LoadError, Continuation<? super Unit>, Object>(systemCollector, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ EventLogSystemCollector $systemCollector;
            {
                this.$systemCollector = $systemCollector;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                LoadError loadError = (LoadError)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void loadError2;
                        ResultKt.throwOnFailure((Object)$result);
                        this.$systemCollector.logDictionaryUpdateFailed(FusComponentProvider.access$loadErrorToEventLogMetadataUpdateError(FusComponentProvider.INSTANCE, (LoadError)loadError2));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(LoadError p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final FusComponents createBlindFusComponents(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        return new FusComponents((MetadataStorage<EventLogBuild>)((MetadataStorage)new CompositeValidationRulesStorage((MetadataStorage<EventLogBuild>)((MetadataStorage)new BlindMetadataStorage()), new ValidationTestRulesPersistedStorage(recorderId))), new MessageBus(), new BlindRemoteConfig());
    }

    @JvmStatic
    @NotNull
    public static final FusComponents createFusComponents(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        EventLogInternalApplicationInfo applicationInfo = new EventLogInternalApplicationInfo(StatisticsUploadAssistant.isUseTestStatisticsConfig(), StatisticsUploadAssistant.isUseTestStatisticsSendEndpoint());
        MessageBus messageBus = new MessageBus();
        String string = applicationInfo.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        String string2 = applicationInfo.getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProductCode(...)");
        RegionCode regionCode = Intrinsics.areEqual((Object)applicationInfo.getRegionalCode(), (Object)"china") ? RegionCode.CN : RegionCode.ALL;
        String string3 = applicationInfo.getProductVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProductVersion(...)");
        FusClientConfig config = new FusClientConfig(string, string2, recorderId, regionCode, string3, applicationInfo.getBaselineVersion(), null, applicationInfo.isTestConfig(), Boolean.parseBoolean(System.getProperty("fus.internal.reduce.initial.delay")));
        FusJacksonSerializer jsonSerializer = new FusJacksonSerializer();
        ProxyProvider proxyProvider = arg_0 -> FusComponentProvider.createFusComponents$lambda$0(applicationInfo, arg_0);
        String string4 = applicationInfo.getConnectionSettings().provideUserAgent();
        JvmHttpClient httpClient = new JvmHttpClient(() -> FusComponentProvider.createFusComponents$lambda$1(applicationInfo), proxyProvider, string4, () -> FusComponentProvider.createFusComponents$lambda$2(applicationInfo), null, 16, null);
        DefaultRemoteConfig remoteConfig = new DefaultRemoteConfig(config, (FusJsonSerializer)jsonSerializer, (FusHttpClient)httpClient);
        FileStorage fileStorage = ApplicationManager.getApplication().isUnitTestMode() ? (FileStorage)new InMemoryJvmFileStorage() : (FileStorage)new JvmFileStorage(INSTANCE.getMetadataDir(recorderId));
        DefaultMetadataStorage metadataStorage = new DefaultMetadataStorage(config, messageBus, (FusLoggerFactory)new NoOpLoggerFactory(), (RemoteConfig)remoteConfig, (FusHttpClient)httpClient, (FusJsonSerializer)jsonSerializer, fileStorage, (FileStorage)new BundledJvmFileStorage(recorderId), MetadataUpdateDelay.LONG, FusComponentProvider::createFusComponents$lambda$3, FeatureUsageData.Companion.getPlatformDataKeys(), (UtilRuleProducer)new CustomRuleProducer(recorderId), null, 4096, null);
        return new FusComponents((MetadataStorage<EventLogBuild>)(ApplicationManager.getApplication().isInternal() ? (MetadataStorage)new CompositeValidationRulesStorage((MetadataStorage<EventLogBuild>)((MetadataStorage)metadataStorage), new ValidationTestRulesPersistedStorage(recorderId)) : (MetadataStorage)metadataStorage), messageBus, (RemoteConfig)remoteConfig);
    }

    private static final ProxyInfo createFusComponents$lambda$0(EventLogInternalApplicationInfo $applicationInfo, String configurationUrl) {
        Intrinsics.checkNotNullParameter((Object)configurationUrl, (String)"configurationUrl");
        return new ProxyInfo($applicationInfo.getConnectionSettings().provideProxy(configurationUrl).getProxy(), null, 2, null);
    }

    private static final SSLContext createFusComponents$lambda$1(EventLogInternalApplicationInfo $applicationInfo) {
        return $applicationInfo.getConnectionSettings().provideSSLContext();
    }

    private static final Map createFusComponents$lambda$2(EventLogInternalApplicationInfo $applicationInfo) {
        return $applicationInfo.getConnectionSettings().provideExtraHeaders();
    }

    private static final EventLogBuild createFusComponents$lambda$3(String version) {
        return EventLogBuild.fromString((String)version);
    }

    public static final /* synthetic */ EventLogMetadataUpdateError access$loadErrorToEventLogMetadataUpdateError(FusComponentProvider $this, LoadError loadError) {
        return $this.loadErrorToEventLogMetadataUpdateError(loadError);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider$BlindMetadataStorage;", "Lcom/jetbrains/fus/reporting/MetadataStorage;", "Lcom/intellij/internal/statistic/eventLog/EventLogBuild;", "<init>", "()V", "getIdsRulesRevisions", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRule;", "getSystemDataRulesRevisions", "isUnreachable", "", "getGroupValidators", "Lcom/intellij/internal/statistic/eventLog/validator/IGroupValidators;", "groupId", "", "getSkipAnonymizationIds", "", "reload", "", "update", "Lkotlinx/coroutines/Job;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClientDataRulesRevisions", "getFieldsToAnonymize", "eventId", "intellij.platform.statistics"})
    private static final class BlindMetadataStorage
    implements MetadataStorage<EventLogBuild> {
        @NotNull
        public RecorderDataValidationRule getIdsRulesRevisions() {
            throw new UnsupportedOperationException("Not supported");
        }

        @NotNull
        public RecorderDataValidationRule getSystemDataRulesRevisions() {
            throw new UnsupportedOperationException("Not supported");
        }

        public boolean isUnreachable() {
            return false;
        }

        @NotNull
        public IGroupValidators<EventLogBuild> getGroupValidators(@NotNull String groupId) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            return (IGroupValidators)new IGroupValidators<EventLogBuild>(){
                private final IEventGroupRules eventGroupRules;
                private final IEventGroupsFilterRules<EventLogBuild> versionFilter;

                public IEventGroupRules getEventGroupRules() {
                    return this.eventGroupRules;
                }

                public IEventGroupsFilterRules<EventLogBuild> getVersionFilter() {
                    return this.versionFilter;
                }
            };
        }

        @NotNull
        public Set<String> getSkipAnonymizationIds() {
            return SetsKt.emptySet();
        }

        public void reload() {
        }

        public boolean update() {
            return false;
        }

        @Nullable
        public Object update(@NotNull CoroutineScope scope, @NotNull Continuation<? super Job> $completion) {
            throw new UnsupportedOperationException("Not supported");
        }

        @NotNull
        public RecorderDataValidationRule getClientDataRulesRevisions() {
            throw new UnsupportedOperationException("Not supported");
        }

        @NotNull
        public Set<String> getFieldsToAnonymize(@NotNull String groupId, @NotNull String eventId) {
            Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider$BlindRemoteConfig;", "Lcom/jetbrains/fus/reporting/RemoteConfig;", "<init>", "()V", "getSendUrl", "", "provideOptions", "", "getMetadataUrl", "getDictionaryUrl", "intellij.platform.statistics"})
    private static final class BlindRemoteConfig
    implements RemoteConfig {
        @NotNull
        public String getSendUrl() {
            return "";
        }

        @NotNull
        public Map<String, String> provideOptions() {
            return MapsKt.emptyMap();
        }

        @NotNull
        public String getMetadataUrl() {
            return "";
        }

        @NotNull
        public String getDictionaryUrl() {
            return "";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider$BundledJvmFileStorage;", "Lcom/jetbrains/fus/reporting/FileStorage;", "recorderId", "", "<init>", "(Ljava/lang/String;)V", "bundledBasePath", "getBundledBasePath", "()Ljava/lang/String;", "bundledResourcePath", "path", "exists", "", "openFileHandle", "Lcom/jetbrains/fus/reporting/FileHandle;", "mode", "Lcom/jetbrains/fus/reporting/FileStorageMode;", "read", "", "write", "", "content", "intellij.platform.statistics"})
    public static final class BundledJvmFileStorage
    implements FileStorage {
        @NotNull
        private final String recorderId;

        public BundledJvmFileStorage(@NotNull String recorderId) {
            Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
            this.recorderId = recorderId;
        }

        private final String getBundledBasePath() {
            return "resources/event-log-metadata/" + this.recorderId + "/";
        }

        private final String bundledResourcePath(String path) {
            String string;
            if (StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null)) {
                String string2 = this.getBundledBasePath();
                String string3 = path.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                string = string2 + string3;
            } else {
                string = this.getBundledBasePath() + "/" + path;
            }
            return string;
        }

        public boolean exists(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.getClass().getClassLoader().getResource(this.bundledResourcePath(path)) != null;
        }

        @NotNull
        public FileHandle openFileHandle(@NotNull String path, @NotNull FileStorageMode mode) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            return new FileHandle(){

                public boolean exists() {
                    return false;
                }

                public long length() {
                    return 0L;
                }

                public byte read(int index) {
                    return 0;
                }

                public byte[] read(int index, byte[] dstBuffer) {
                    Intrinsics.checkNotNullParameter((Object)dstBuffer, (String)"dstBuffer");
                    return new byte[0];
                }

                public byte[] readAll() {
                    return new byte[0];
                }

                public void write(byte[] bytes) {
                    Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                }

                public void close() {
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public byte[] read(@NotNull String path) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.bundledResourcePath(path));
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    byte[] byArray2 = it.readAllBytes();
                    byArray = byArray2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                byArray = null;
            }
            return byArray;
        }

        public void write(@NotNull String path, @NotNull byte[] content) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0001H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider$CustomPrettyPrinter;", "Lcom/fasterxml/jackson/core/util/DefaultPrettyPrinter;", "<init>", "()V", "base", "(Lcom/fasterxml/jackson/core/util/DefaultPrettyPrinter;)V", "writeObjectFieldValueSeparator", "", "g", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeEndArray", "nrOfValues", "", "writeEndObject", "nrOfEntries", "createInstance", "intellij.platform.statistics"})
    private static final class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        public CustomPrettyPrinter() {
            this._objectIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
            this._arrayIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
        }

        public CustomPrettyPrinter(@Nullable DefaultPrettyPrinter base) {
            super(base);
            this._objectIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
            this._arrayIndenter = (DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n");
        }

        public void writeObjectFieldValueSeparator(@NotNull JsonGenerator g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.writeRaw(": ");
        }

        public void writeEndArray(@NotNull JsonGenerator g, int nrOfValues) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!this._arrayIndenter.isInline()) {
                this._nesting += -1;
            }
            if (nrOfValues > 0) {
                this._arrayIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw(']');
        }

        public void writeEndObject(@NotNull JsonGenerator g, int nrOfEntries) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (!this._objectIndenter.isInline()) {
                this._nesting += -1;
            }
            if (nrOfEntries > 0) {
                this._objectIndenter.writeIndentation(g, this._nesting);
            }
            g.writeRaw('}');
        }

        @NotNull
        public DefaultPrettyPrinter createInstance() {
            return new CustomPrettyPrinter(this);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider$FusComponents;", "", "metadataStorage", "Lcom/jetbrains/fus/reporting/MetadataStorage;", "Lcom/intellij/internal/statistic/eventLog/EventLogBuild;", "messageBus", "Lcom/jetbrains/fus/reporting/MessageBus;", "remoteConfig", "Lcom/jetbrains/fus/reporting/RemoteConfig;", "<init>", "(Lcom/jetbrains/fus/reporting/MetadataStorage;Lcom/jetbrains/fus/reporting/MessageBus;Lcom/jetbrains/fus/reporting/RemoteConfig;)V", "getMetadataStorage", "()Lcom/jetbrains/fus/reporting/MetadataStorage;", "getMessageBus", "()Lcom/jetbrains/fus/reporting/MessageBus;", "getRemoteConfig", "()Lcom/jetbrains/fus/reporting/RemoteConfig;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.statistics"})
    public static final class FusComponents {
        @NotNull
        private final MetadataStorage<EventLogBuild> metadataStorage;
        @NotNull
        private final MessageBus messageBus;
        @NotNull
        private final RemoteConfig remoteConfig;

        public FusComponents(@NotNull MetadataStorage<EventLogBuild> metadataStorage, @NotNull MessageBus messageBus, @NotNull RemoteConfig remoteConfig) {
            Intrinsics.checkNotNullParameter(metadataStorage, (String)"metadataStorage");
            Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
            Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
            this.metadataStorage = metadataStorage;
            this.messageBus = messageBus;
            this.remoteConfig = remoteConfig;
        }

        @NotNull
        public final MetadataStorage<EventLogBuild> getMetadataStorage() {
            return this.metadataStorage;
        }

        @NotNull
        public final MessageBus getMessageBus() {
            return this.messageBus;
        }

        @NotNull
        public final RemoteConfig getRemoteConfig() {
            return this.remoteConfig;
        }

        @NotNull
        public final MetadataStorage<EventLogBuild> component1() {
            return this.metadataStorage;
        }

        @NotNull
        public final MessageBus component2() {
            return this.messageBus;
        }

        @NotNull
        public final RemoteConfig component3() {
            return this.remoteConfig;
        }

        @NotNull
        public final FusComponents copy(@NotNull MetadataStorage<EventLogBuild> metadataStorage, @NotNull MessageBus messageBus, @NotNull RemoteConfig remoteConfig) {
            Intrinsics.checkNotNullParameter(metadataStorage, (String)"metadataStorage");
            Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
            Intrinsics.checkNotNullParameter((Object)remoteConfig, (String)"remoteConfig");
            return new FusComponents(metadataStorage, messageBus, remoteConfig);
        }

        public static /* synthetic */ FusComponents copy$default(FusComponents fusComponents, MetadataStorage metadataStorage, MessageBus messageBus, RemoteConfig remoteConfig, int n, Object object) {
            if ((n & 1) != 0) {
                metadataStorage = fusComponents.metadataStorage;
            }
            if ((n & 2) != 0) {
                messageBus = fusComponents.messageBus;
            }
            if ((n & 4) != 0) {
                remoteConfig = fusComponents.remoteConfig;
            }
            return fusComponents.copy(metadataStorage, messageBus, remoteConfig);
        }

        @NotNull
        public String toString() {
            return "FusComponents(metadataStorage=" + this.metadataStorage + ", messageBus=" + this.messageBus + ", remoteConfig=" + this.remoteConfig + ")";
        }

        public int hashCode() {
            int result = this.metadataStorage.hashCode();
            result = result * 31 + this.messageBus.hashCode();
            result = result * 31 + this.remoteConfig.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FusComponents)) {
                return false;
            }
            FusComponents fusComponents = (FusComponents)other;
            if (!Intrinsics.areEqual(this.metadataStorage, fusComponents.metadataStorage)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.messageBus, (Object)fusComponents.messageBus)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.remoteConfig, (Object)fusComponents.remoteConfig);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J)\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\t\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/storage/FusComponentProvider$FusJacksonSerializer;", "Lcom/jetbrains/fus/reporting/FusJsonSerializer;", "<init>", "()V", "SERIALIZATION_MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "getSERIALIZATION_MAPPER", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "SERIALIZATION_MAPPER$delegate", "Lkotlin/Lazy;", "DESERIALIZATION_MAPPER", "getDESERIALIZATION_MAPPER", "DESERIALIZATION_MAPPER$delegate", "toJson", "", "data", "", "fromJson", "T", "json", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "intellij.platform.statistics"})
    public static final class FusJacksonSerializer
    implements FusJsonSerializer {
        @NotNull
        private final Lazy SERIALIZATION_MAPPER$delegate = LazyKt.lazy(FusJacksonSerializer::SERIALIZATION_MAPPER_delegate$lambda$0);
        @NotNull
        private final Lazy DESERIALIZATION_MAPPER$delegate = LazyKt.lazy(FusJacksonSerializer::DESERIALIZATION_MAPPER_delegate$lambda$0);

        private final JsonMapper getSERIALIZATION_MAPPER() {
            Lazy lazy = this.SERIALIZATION_MAPPER$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (JsonMapper)object;
        }

        private final JsonMapper getDESERIALIZATION_MAPPER() {
            Lazy lazy = this.DESERIALIZATION_MAPPER$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (JsonMapper)object;
        }

        @NotNull
        public String toJson(@NotNull Object data) {
            String string;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            try {
                string = this.getSERIALIZATION_MAPPER().writerWithDefaultPrettyPrinter().writeValueAsString(data);
                Intrinsics.checkNotNull((Object)string);
            }
            catch (Exception e) {
                throw new SerializationException((Throwable)e);
            }
            return string;
        }

        public <T> T fromJson(@NotNull String json, @NotNull Class<T> clazz) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            try {
                object = this.getDESERIALIZATION_MAPPER().readValue(json, clazz);
            }
            catch (Exception e) {
                throw new SerializationException((Throwable)e);
            }
            return (T)object;
        }

        private static final JsonMapper SERIALIZATION_MAPPER_delegate$lambda$0() {
            MapperFeature[] mapperFeatureArray = new MapperFeature[]{MapperFeature.REQUIRE_SETTERS_FOR_GETTERS};
            return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(mapperFeatureArray)).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false)).serializationInclusion(JsonInclude.Include.NON_NULL)).defaultPrettyPrinter((PrettyPrinter)new CustomPrettyPrinter())).build();
        }

        private static final JsonMapper DESERIALIZATION_MAPPER_delegate$lambda$0() {
            DeserializationFeature[] deserializationFeatureArray = new DeserializationFeature[]{DeserializationFeature.USE_LONG_FOR_INTS};
            JsonMapper.Builder builder = (JsonMapper.Builder)JsonMapper.builder().enable(deserializationFeatureArray);
            deserializationFeatureArray = new JsonParser.Feature[]{JsonParser.Feature.STRICT_DUPLICATE_DETECTION};
            return (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)builder.enable((JsonParser.Feature[])deserializationFeatureArray)).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LoadErrorType.values().length];
            try {
                nArray[LoadErrorType.LOADING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadErrorType.PARSING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LoadErrorType.UNKNOWN_IO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

