BEGIN {
  status = 1

  if (!("MATCH_PATTERN" in ENVIRON)) {
    fail()
  }

  mode = "exact"
  pattern = ENVIRON["MATCH_PATTERN"]

  if (match(pattern, /^\/.*\/$/)) {
    mode = "regex"
    pattern = substr(pattern, 2, length(pattern) - 2)
  }
}

mode == "regex" && match($0, pattern) {
  pass()
}

mode == "exact" && index($0, pattern) {
  pass()
}

END {
  exit status
}

function fail() {
  exit
}

function pass() {
  status = 0
  exit
}
