/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Random;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.action.MapboardAction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.server.model.ServerGame;

public class NewEmptyMapAction
extends MapboardAction {
    public static final String id = "newEmptyMapAction";

    public NewEmptyMapAction(FreeColClient freeColClient) {
        super(freeColClient, id);
    }

    @Override
    protected boolean shouldBeEnabled() {
        return this.freeColClient.isMapEditor();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Dimension size = this.getGUI().showMapSizeDialog();
        if (size == null) {
            return;
        }
        FreeColClient fcc = this.getFreeColClient();
        ServerGame game = new ServerGame(fcc.getMapEditorController().getDefaultSpecification(), new Random());
        fcc.getFreeColServer().setGame(game);
        fcc.setGame(game);
        Map map = fcc.getFreeColServer().generateEmptyMap(size.width, size.height);
        Tile tile = map.getTile(size.width / 2, size.height / 2);
        this.getGUI().removeInGameComponents();
        this.getGUI().startMapEditorGUI();
        this.getGUI().refresh();
        this.getGUI().setFocus(tile);
        this.getGUI().refresh();
    }
}

