/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.nodehistory;

import java.util.LinkedList;
import java.util.ListIterator;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.view.swing.features.nodehistory.BackAction;
import org.freeplane.view.swing.features.nodehistory.ForwardAction;
import org.freeplane.view.swing.features.nodehistory.NodeHolder;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class NodeHistory
implements IExtension {
    private BackAction backAction;
    private final Controller controller;
    private NodeHolder currentNodeHolder;
    private ForwardAction forwardAction;
    private ListIterator<NodeHolder> nodeIterator;
    private final LinkedList<NodeHolder> nodes;

    public static void install(Controller controller) {
        controller.addExtension(NodeHistory.class, new NodeHistory(controller));
    }

    public static void install(ModeController modeController) {
        Controller controller = modeController.getController();
        NodeHistory history = controller.getExtension(NodeHistory.class);
        modeController.getMapController().addNodeSelectionListener(history.getMapSelectionListener());
        LinkController.getController(modeController).addNodeSelectionListener(history.getLinkSelectionListener());
        history.backAction = new BackAction(controller, history);
        modeController.addAction(history.backAction);
        history.forwardAction = new ForwardAction(controller, history);
        modeController.addAction(history.forwardAction);
    }

    private NodeHistory(Controller controller) {
        this.controller = controller;
        this.nodes = new LinkedList();
        this.nodeIterator = this.nodes.listIterator();
    }

    boolean canGoBack() {
        return this.nodeIterator.previousIndex() > 0;
    }

    boolean canGoForward() {
        return this.nodeIterator.hasNext();
    }

    private INodeSelectionListener getLinkSelectionListener() {
        return new INodeSelectionListener(){

            @Override
            public void onDeselect(NodeModel node) {
                NodeHistory.this.onNodeSelect(node);
                NodeHistory.this.currentNodeHolder.setReachedByLink(true);
            }

            @Override
            public void onSelect(NodeModel node) {
                NodeHistory.this.onNodeSelect(node);
                NodeHistory.this.currentNodeHolder.setReachedByLink(true);
            }
        };
    }

    private INodeSelectionListener getMapSelectionListener() {
        return new INodeSelectionListener(){

            @Override
            public void onDeselect(NodeModel node) {
            }

            @Override
            public void onSelect(NodeModel node) {
                NodeHistory.this.onNodeSelect(node);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private void go(boolean back) {
        MapView newView;
        boolean fChangeModule;
        NodeHolder lastNodeHolder = this.currentNodeHolder;
        if (back) {
            if (!this.canGoBack()) {
                this.backAction.setEnabled(false);
                return;
            }
            this.nodeIterator.previous();
            this.nodeIterator.previous();
            this.currentNodeHolder = this.nodeIterator.next();
        } else {
            if (!this.canGoForward()) {
                this.forwardAction.setEnabled(false);
                return;
            }
            this.currentNodeHolder = this.nodeIterator.next();
        }
        if (lastNodeHolder.equals(this.currentNodeHolder)) {
            this.go(back);
            return;
        }
        NodeModel toBeSelected = this.currentNodeHolder.getNode();
        if (this.removed(toBeSelected)) {
            this.currentNodeHolder = lastNodeHolder;
            this.go(back);
            return;
        }
        boolean changeModule = false;
        MapView newModule = null;
        if (lastNodeHolder.getHoldMapView() != this.currentNodeHolder.getHoldMapView()) {
            changeModule = true;
            newModule = this.currentNodeHolder.getMapView();
            if (newModule == null) {
                this.nodeIterator.remove();
                this.go(back);
                return;
            }
        }
        if (fChangeModule = changeModule) {
            newView = newModule;
            Controller controller = newView.getModeController().getController();
            IMapViewManager mapViewManager = controller.getMapViewManager();
            boolean res = mapViewManager.changeToMapView(newView);
            if (!res) {
                LogUtils.warn("Can't change to map mapView " + newView);
                return;
            }
        } else {
            newView = this.currentNodeHolder.getHoldMapView();
        }
        if (!toBeSelected.isRoot()) {
            newView.getModeController().getMapController().unfold(toBeSelected.getParentNode(), newView.getFilter());
        }
        newView.getModeController().getMapController().select(toBeSelected);
    }

    private boolean removed(NodeModel toBeSelected) {
        if (toBeSelected == null) {
            return true;
        }
        if (toBeSelected.isRoot()) {
            return false;
        }
        return this.removed(toBeSelected.getParentNode());
    }

    private void go(boolean back, boolean fast) {
        NodeHolder lastCurrentNodeHolder;
        do {
            lastCurrentNodeHolder = this.currentNodeHolder;
            this.go(back);
        } while (fast && lastCurrentNodeHolder != this.currentNodeHolder && !this.currentNodeHolder.isReachedByLink());
    }

    public void goBack(boolean fast) {
        this.go(true, fast);
    }

    public void goForward(boolean fast) {
        this.go(false, fast);
    }

    private void onNodeSelect(NodeModel pNode) {
        NodeView nodeView = ((MapView)this.controller.getMapViewManager().getMapViewComponent()).getNodeView(pNode);
        if (nodeView == null || this.currentNodeHolder != null && this.currentNodeHolder.isIdentical(nodeView)) {
            return;
        }
        while (this.canGoForward()) {
            this.nodeIterator.next();
            this.nodeIterator.remove();
        }
        if (this.nodes.size() > 100) {
            this.nodes.removeFirst();
            this.nodeIterator = this.nodes.listIterator(this.nodes.size());
        }
        this.currentNodeHolder = new NodeHolder(nodeView);
        this.nodeIterator.add(this.currentNodeHolder);
    }
}

