/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import tim.prune.data.AudioClip;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.load.AudioFileFilter;
import tim.prune.load.ByteScooper;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.JpegFileFilter;
import tim.prune.load.JpegLoader;

public abstract class MediaHelper {
    private static GenericFileFilter _jpegFilter = null;
    private static GenericFileFilter _audioFilter = null;

    public static MediaObject createMediaObjectFromUrl(URL uRL) {
        if (uRL == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = uRL.openStream();){
                byArray = ByteScooper.scoop(inputStream);
                return MediaHelper.createMediaObject(byArray, uRL.getFile(), uRL.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            System.err.println("Got ioe from url: " + iOException.getMessage());
            return null;
        }
    }

    public static MediaObject createMediaObjectRelative(File file, String string, File file2) {
        Object object;
        if (string == null || string.length() < 5) {
            return null;
        }
        byte[] byArray = null;
        if (file != null && file.exists() && file.canRead()) {
            try {
                object = null;
                Object var5_7 = null;
                try (ZipFile zipFile = new ZipFile(file);){
                    ZipEntry zipEntry = zipFile.getEntry(string);
                    if (zipEntry != null && zipEntry.getSize() > 0L) {
                        byArray = ByteScooper.scoop(zipFile.getInputStream(zipEntry));
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (IOException iOException) {
                System.err.println("Got ioe from zip file: " + iOException.getMessage());
            }
        }
        if (byArray != null) {
            object = new File(string).getName();
            return MediaHelper.createMediaObject(byArray, (String)object, null);
        }
        object = new File(string);
        if (file2 != null && !((File)object).isAbsolute()) {
            object = new File(file2.getParent(), string);
        }
        return MediaHelper.createMediaObject((File)object);
    }

    private static MediaObject createMediaObject(byte[] byArray, String string, String string2) {
        MediaHelper.initFilters();
        if (_jpegFilter.acceptFilename(string)) {
            return new Photo(byArray, string, string2);
        }
        if (_audioFilter.acceptFilename(string)) {
            return new AudioClip(byArray, string, string2);
        }
        return null;
    }

    private static MediaObject createMediaObject(File file) {
        if (file == null) {
            return null;
        }
        if (!(file.exists() && file.canRead() && file.isFile())) {
            return null;
        }
        MediaHelper.initFilters();
        if (_jpegFilter.acceptFilename(file.getName())) {
            return JpegLoader.createPhoto(file);
        }
        if (_audioFilter.acceptFilename(file.getName())) {
            return new AudioClip(file);
        }
        return null;
    }

    private static void initFilters() {
        if (_jpegFilter == null) {
            _jpegFilter = new JpegFileFilter();
            _audioFilter = new AudioFileFilter();
        }
    }
}

