/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.file.Directory;
import org.gradle.buildinit.plugins.internal.BuildContentGenerationContext;
import org.gradle.buildinit.plugins.internal.VersionCatalogDependencyRegistry;
import org.gradle.internal.UncheckedException;
import org.gradle.util.internal.GFileUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class VersionCatalogGenerator {
    private final Directory target;

    private VersionCatalogGenerator(Directory target) {
        this.target = target;
    }

    public static VersionCatalogGenerator create(Directory target) {
        return new VersionCatalogGenerator(target);
    }

    public void generate(BuildContentGenerationContext buildContentGenerationContext, boolean withComments) {
        Path gradleDirectory = this.target.getAsFile().toPath().resolve("gradle");
        GFileUtils.mkdirs((File)gradleDirectory.toFile());
        try (PrintWriter writer = new PrintWriter(new FileWriter(gradleDirectory.resolve("libs.versions.toml").toFile()));){
            if (withComments) {
                writer.println("# This file was generated by the Gradle 'init' task.");
                writer.println("# https://docs.gradle.org/current/userguide/version_catalogs.html#sec::toml-dependencies-format");
            }
            boolean needsSeparatorLine = withComments;
            for (Section<?> section : VersionCatalogGenerator.getSections(buildContentGenerationContext)) {
                needsSeparatorLine = section.write(writer, needsSeparatorLine);
            }
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    private static List<Section<?>> getSections(BuildContentGenerationContext buildContentGenerationContext) {
        VersionCatalogDependencyRegistry versionCatalogDependencyRegistry = buildContentGenerationContext.getVersionCatalogDependencyRegistry();
        return Arrays.asList(new Section<VersionCatalogDependencyRegistry.VersionEntry>("[versions]", versionCatalogDependencyRegistry.getVersions(), v -> String.format("%s = \"%s\"", v.alias, v.version)), new Section<VersionCatalogDependencyRegistry.LibraryEntry>("[libraries]", versionCatalogDependencyRegistry.getLibraries(), l -> String.format("%s = { module = \"%s\", version.ref = \"%s\" }", l.alias, l.module, l.versionRef)), new Section<VersionCatalogDependencyRegistry.PluginEntry>("[plugins]", versionCatalogDependencyRegistry.getPlugins(), p -> String.format("%s = { id = \"%s\", version = \"%s\" }", p.alias, p.pluginId, p.version)));
    }

    private static class Section<T> {
        private final String header;
        private final Collection<T> items;
        private final Function<T, String> formatter;

        public Section(String header, Collection<T> items, Function<T, String> formatter) {
            this.header = header;
            this.items = items;
            this.formatter = formatter;
        }

        boolean write(PrintWriter writer, boolean needsSeparatorLine) {
            if (this.items.isEmpty()) {
                return false;
            }
            if (needsSeparatorLine) {
                writer.println();
            }
            writer.println(this.header);
            for (T item : this.items) {
                writer.println(this.formatter.apply(item));
            }
            return true;
        }
    }
}

