/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.1-develop.

Abstract: This is an autogenerated Java file in order to allow an easy
 use of the 3MF Library

Interface version: 2.5.0

*/

package lib3mf;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.lang.ref.Cleaner;


import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

public class Resource extends Base {

	public Resource(Lib3MFWrapper wrapper, Pointer handle) {
		super(wrapper, handle);
	}

	/**
	 * Retrieves the unique id of this resource within a package. This function will be removed in a later release in favor of GetUniqueResourceID
	 *
	 * @return Retrieves the unique id of this resource within a package.
	 * @throws Lib3MFException
	 */
	public int getResourceID() throws Lib3MFException {
		Pointer bufferUniqueResourceID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_resource_getresourceid.invokeInt(new java.lang.Object[]{mHandle, bufferUniqueResourceID}));
		return bufferUniqueResourceID.getInt(0);
	}

	/**
	 * Retrieves the unique id of this resource within a package.
	 *
	 * @return Retrieves the unique id of this resource within a package.
	 * @throws Lib3MFException
	 */
	public int getUniqueResourceID() throws Lib3MFException {
		Pointer bufferUniqueResourceID = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_resource_getuniqueresourceid.invokeInt(new java.lang.Object[]{mHandle, bufferUniqueResourceID}));
		return bufferUniqueResourceID.getInt(0);
	}

	/**
	 * Returns the PackagePart within which this resource resides
	 *
	 * @return the PackagePart within which this resource resides.
	 * @throws Lib3MFException
	 */
	public PackagePart packagePart() throws Lib3MFException {
		Pointer bufferPackagePart = new Memory(8);
		mWrapper.checkError(this, mWrapper.lib3mf_resource_packagepart.invokeInt(new java.lang.Object[]{mHandle, bufferPackagePart}));
		Pointer valuePackagePart = bufferPackagePart.getPointer(0);
		PackagePart packagePart = null;
		if (valuePackagePart == Pointer.NULL) {
		  throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "PackagePart was a null pointer");
		}
		packagePart = mWrapper.PolymorphicFactory(valuePackagePart, PackagePart.class);
		return packagePart;
	}

	/**
	 * Sets the new PackagePart within which this resource resides
	 *
	 * @param packagePart the new PackagePart within which this resource resides.
	 * @throws Lib3MFException
	 */
	public void setPackagePart(PackagePart packagePart) throws Lib3MFException {
		Pointer packagePartHandle = null;
		if (packagePart != null) {
			packagePartHandle = packagePart.getHandle();
		} else {
			throw new Lib3MFException(Lib3MFException.LIB3MF_ERROR_INVALIDPARAM, "PackagePart is a null value.");
		}
		mWrapper.checkError(this, mWrapper.lib3mf_resource_setpackagepart.invokeInt(new java.lang.Object[]{mHandle, packagePartHandle}));
	}

	/**
	 * Retrieves the id of this resource within a model.
	 *
	 * @return Retrieves the id of this resource within a model.
	 * @throws Lib3MFException
	 */
	public int getModelResourceID() throws Lib3MFException {
		Pointer bufferModelResourceId = new Memory(4);
		mWrapper.checkError(this, mWrapper.lib3mf_resource_getmodelresourceid.invokeInt(new java.lang.Object[]{mHandle, bufferModelResourceId}));
		return bufferModelResourceId.getInt(0);
	}


}

