/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.time.Period;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;

class IntervalymAccessor
extends Accessor {
    static final int MAXLENGTH = 5;
    private static int INTYMYEAROFFSET = Integer.MIN_VALUE;
    private static int INTYMMONTHOFFSET = 60;

    IntervalymAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind) throws SQLException {
        this(stmt, max_len, form, external_type, isOutBind, false);
    }

    IntervalymAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.INTERVALYM, stmt, 5, isStoredInBindData);
        this.init(stmt, 182, 182, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    IntervalymAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.INTERVALYM, stmt, 5, false);
        this.init(stmt, 182, 182, form, false);
        this.initForDescribe(182, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return this.getINTERVALYM(currentRow).toString();
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        return this.getINTERVALYM(currentRow);
    }

    @Override
    Period getPeriod(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        byte[] bytes = this.getBytesInternal(currentRow);
        return oracle.sql.INTERVALYM.toPeriod(bytes);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getINTERVALYM(currentRow);
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        return this.getINTERVALYM(currentRow);
    }

    @Override
    INTERVALYM getINTERVALYM(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        return new INTERVALYM(this.getBytesInternal(currentRow));
    }
}

