/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.io.IOException;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class MLMemorySpec
implements ToXContentObject {
    public static final String MEMORY_TYPE_FIELD = "type";
    public static final String WINDOW_SIZE_FIELD = "window_size";
    public static final String SESSION_ID_FIELD = "session_id";
    public static final String MEMORY_CONTAINER_ID_FIELD = "memory_container_id";
    private String type;
    private String sessionId;
    private Integer windowSize;
    private String memoryContainerId;

    public MLMemorySpec(String type, String sessionId, Integer windowSize, String memoryContainerId) {
        if (type == null) {
            throw new IllegalArgumentException("agent name is null");
        }
        this.type = type;
        this.sessionId = sessionId;
        this.windowSize = windowSize;
        this.memoryContainerId = memoryContainerId;
    }

    public MLMemorySpec(StreamInput input) throws IOException {
        this.type = input.readString();
        this.sessionId = input.readOptionalString();
        this.windowSize = input.readOptionalInt();
        this.memoryContainerId = input.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeOptionalString(this.sessionId);
        out.writeOptionalInt(this.windowSize);
        out.writeOptionalString(this.memoryContainerId);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MEMORY_TYPE_FIELD, this.type);
        if (this.windowSize != null) {
            builder.field(WINDOW_SIZE_FIELD, this.windowSize);
        }
        if (this.sessionId != null) {
            builder.field(SESSION_ID_FIELD, this.sessionId);
        }
        if (this.memoryContainerId != null) {
            builder.field(MEMORY_CONTAINER_ID_FIELD, this.memoryContainerId);
        }
        builder.endObject();
        return builder;
    }

    public static MLMemorySpec parse(XContentParser parser) throws IOException {
        String type = null;
        String sessionId = null;
        Integer windowSize = null;
        String memoryContainerId = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block12;
                }
                case "session_id": {
                    sessionId = parser.text();
                    continue block12;
                }
                case "window_size": {
                    windowSize = parser.intValue();
                    continue block12;
                }
                case "memory_container_id": {
                    memoryContainerId = parser.text();
                    continue block12;
                }
            }
            parser.skipChildren();
        }
        return MLMemorySpec.builder().type(type).sessionId(sessionId).windowSize(windowSize).memoryContainerId(memoryContainerId).build();
    }

    public static MLMemorySpec fromStream(StreamInput in) throws IOException {
        MLMemorySpec toolSpec = new MLMemorySpec(in);
        return toolSpec;
    }

    @Generated
    public static MLMemorySpecBuilder builder() {
        return new MLMemorySpecBuilder();
    }

    @Generated
    public MLMemorySpecBuilder toBuilder() {
        return new MLMemorySpecBuilder().type(this.type).sessionId(this.sessionId).windowSize(this.windowSize).memoryContainerId(this.memoryContainerId);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLMemorySpec)) {
            return false;
        }
        MLMemorySpec other = (MLMemorySpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$windowSize = this.getWindowSize();
        Integer other$windowSize = other.getWindowSize();
        if (this$windowSize == null ? other$windowSize != null : !((Object)this$windowSize).equals(other$windowSize)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$memoryContainerId = this.getMemoryContainerId();
        String other$memoryContainerId = other.getMemoryContainerId();
        return !(this$memoryContainerId == null ? other$memoryContainerId != null : !this$memoryContainerId.equals(other$memoryContainerId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLMemorySpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $windowSize = this.getWindowSize();
        result = result * 59 + ($windowSize == null ? 43 : ((Object)$windowSize).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $memoryContainerId = this.getMemoryContainerId();
        result = result * 59 + ($memoryContainerId == null ? 43 : $memoryContainerId.hashCode());
        return result;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getSessionId() {
        return this.sessionId;
    }

    @Generated
    public Integer getWindowSize() {
        return this.windowSize;
    }

    @Generated
    public String getMemoryContainerId() {
        return this.memoryContainerId;
    }

    @Generated
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Generated
    public static class MLMemorySpecBuilder {
        @Generated
        private String type;
        @Generated
        private String sessionId;
        @Generated
        private Integer windowSize;
        @Generated
        private String memoryContainerId;

        @Generated
        MLMemorySpecBuilder() {
        }

        @Generated
        public MLMemorySpecBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MLMemorySpecBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Generated
        public MLMemorySpecBuilder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        @Generated
        public MLMemorySpecBuilder memoryContainerId(String memoryContainerId) {
            this.memoryContainerId = memoryContainerId;
            return this;
        }

        @Generated
        public MLMemorySpec build() {
            return new MLMemorySpec(this.type, this.sessionId, this.windowSize, this.memoryContainerId);
        }

        @Generated
        public String toString() {
            return "MLMemorySpec.MLMemorySpecBuilder(type=" + this.type + ", sessionId=" + this.sessionId + ", windowSize=" + this.windowSize + ", memoryContainerId=" + this.memoryContainerId + ")";
        }
    }
}

