/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

public enum TimeUnitConfig {
    MICROSECONDS("us", 1, -1L, true),
    MILLISECONDS("ms", 1, 1L, true),
    CENTISECONDS("cs", 1, 10L, true),
    DECISECONDS("ds", 1, 100L, true),
    SECONDS("s", 1000, 1L, true),
    MINUTES("m", 60000, 60L, true),
    HOURS("h", 3600000, 3600L, true),
    DAYS("d", 86400000, 1L, false),
    MONTHS("M", 0, 1L, false);

    private final String unit;
    private final int multiplierMillis;
    private final long divisionFactor;
    private final boolean supportsAlignment;

    private TimeUnitConfig(String unit, int multiplierMillis, long divisionFactor, boolean supportsAlignment) {
        this.unit = unit;
        this.multiplierMillis = multiplierMillis;
        this.divisionFactor = divisionFactor;
        this.supportsAlignment = supportsAlignment;
    }

    public String getUnit() {
        return this.unit;
    }

    public int getMultiplierMillis() {
        return this.multiplierMillis;
    }

    public long getDivisionFactor() {
        return this.divisionFactor;
    }

    public boolean supportsAlignment() {
        return this.supportsAlignment;
    }

    public long toMilliseconds(int intervalValue) {
        if (this == MICROSECONDS) {
            return (long)intervalValue / 1000L;
        }
        return (long)intervalValue * (long)this.multiplierMillis;
    }

    public long toSeconds(int intervalValue) {
        return this.toMilliseconds(intervalValue) / 1000L;
    }
}

