/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.quest.vault;

import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.VaultRat;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MeleeWeapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.watabou.utils.Point;
import com.watabou.utils.Random;

public class VaultSimpleEnemyTreasureRoom
extends StandardRoom {
    @Override
    public float[] sizeCatProbs() {
        return new float[]{0.0f, 1.0f, 0.0f};
    }

    @Override
    public void paint(Level level) {
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 1);
        int ratPos = 0;
        int treasurePos = 0;
        switch (Random.Int(4)) {
            case 0: {
                Painter.fill(level, this.left + 2, this.top + 2, 6, 6, 4);
                Painter.fill(level, this.left + 3, this.top + 3, 4, 4, 14);
                Painter.fill(level, this.left + 4, this.top + 7, 2, 1, 14);
                Painter.fill(level, this.left + 7, this.top + 4, 1, 2, 14);
                ratPos = level.pointToCell(new Point(this.left + 4, this.top + 4));
                treasurePos = level.pointToCell(new Point(this.left + 3, this.top + 3));
                break;
            }
            case 1: {
                Painter.fill(level, this.left + 3, this.top + 2, 6, 6, 4);
                Painter.fill(level, this.left + 4, this.top + 3, 4, 4, 14);
                Painter.fill(level, this.left + 5, this.top + 7, 2, 1, 14);
                Painter.fill(level, this.left + 3, this.top + 4, 1, 2, 14);
                ratPos = level.pointToCell(new Point(this.right - 4, this.top + 4));
                treasurePos = level.pointToCell(new Point(this.right - 3, this.top + 3));
                break;
            }
            case 2: {
                Painter.fill(level, this.left + 3, this.top + 3, 6, 6, 4);
                Painter.fill(level, this.left + 4, this.top + 4, 4, 4, 14);
                Painter.fill(level, this.left + 5, this.top + 3, 2, 1, 14);
                Painter.fill(level, this.left + 3, this.top + 5, 1, 2, 14);
                ratPos = level.pointToCell(new Point(this.right - 4, this.bottom - 4));
                treasurePos = level.pointToCell(new Point(this.right - 3, this.bottom - 3));
                break;
            }
            case 3: {
                Painter.fill(level, this.left + 2, this.top + 3, 6, 6, 4);
                Painter.fill(level, this.left + 3, this.top + 4, 4, 4, 14);
                Painter.fill(level, this.left + 4, this.top + 3, 2, 1, 14);
                Painter.fill(level, this.left + 7, this.top + 5, 1, 2, 14);
                ratPos = level.pointToCell(new Point(this.left + 4, this.bottom - 4));
                treasurePos = level.pointToCell(new Point(this.left + 3, this.bottom - 3));
            }
        }
        MeleeWeapon treasure = Generator.randomWeapon(true);
        level.drop((Item)treasure, (int)treasurePos).type = Heap.Type.CHEST;
        if (treasure.cursed) {
            treasure.cursed = false;
            if (treasure.hasCurseEnchant()) {
                treasure.enchant(null);
            }
        }
        treasure.cursedKnown = true;
        treasure.levelKnown = true;
        for (Room.Door door : this.connected.values()) {
            door.set(Room.Door.Type.REGULAR);
        }
        VaultRat rat = new VaultRat();
        rat.pos = ratPos;
        level.mobs.add(rat);
    }

    @Override
    public boolean canMerge(Level l, Room other, Point p, int mergeTerrain) {
        return false;
    }
}

