-- This file is generated from citeproc-bibtex-data.json by scripts/update_bibtex_data.py

return {
  description = "BibTeX CSL mapping",
  types = {
    abstract = {
      csl = nil,
      source = "biblatex-cv.dbx",
    },
    ancienttext = {
      csl = "classic",
      source = "sbl.dbx",
    },
    archival = {
      csl = "collection",
      notes = "New in CSL v1.0.2.",
      source = "jurabib.bst",
    },
    archive = {
      csl = "collection",
      source = "gbt7714-numerical.bst",
    },
    article = {
      csl = "article-journal",
      notes = "May also be `article-magazine` or `article-newspaper` depending upon the field `entrysubtype`.",
      source = "bibtex",
    },
    ["article-journal"] = {
      csl = "article-journal",
      source = "csl",
    },
    ["article-magazine"] = {
      csl = "article-magazine",
      source = "csl",
    },
    ["article-newspaper"] = {
      csl = "article-newspaper",
      source = "csl",
    },
    artifactdataset = {
      csl = "dataset",
      source = "ACM-Reference-Format.bst",
    },
    artifactsoftware = {
      csl = "software",
      source = "ACM-Reference-Format.bst",
    },
    artwork = {
      csl = "graphic",
      source = "biblatex",
    },
    atlas = {
      csl = nil,
      source = "ametsoc2014.bst",
    },
    audio = {
      csl = "song",
      notes = "CSL's `song` can be used for any audio recording (not only music).",
      source = "biblatex",
    },
    bachelor = {
      csl = "thesis",
      source = "dlfltxbbibtex.bst",
    },
    bibnote = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
    },
    bill = {
      csl = "bill",
      source = "csl",
    },
    book = {
      csl = "book",
      source = "bibtex",
    },
    bookinarticle = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinbook = {
      csl = "chapter",
      source = "biblatex",
    },
    bookincollection = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookininarticle = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookininbook = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinincollection = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookininproceedings = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookininreference = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinjournal = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinmathesis = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinphdthesis = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinproceedings = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinreference = {
      csl = nil,
      source = "bookinother.dbx",
    },
    bookinthesis = {
      csl = nil,
      source = "bookinother.dbx",
    },
    booklet = {
      csl = "pamphlet",
      source = "bibtex",
    },
    broadcast = {
      csl = "broadcast",
      source = "csl",
    },
    brochure = {
      csl = "pamphlet",
      source = "thesnumb.bst",
    },
    catalog = {
      csl = nil,
      source = "arthistory-bonn.dbx",
    },
    cconference = {
      csl = "paper-conference",
      source = "seuthesis.bst",
    },
    chapter = {
      csl = "chapter",
      source = "csl",
    },
    classic = {
      csl = "classic",
      source = "csl",
    },
    classictext = {
      csl = "classic",
      source = "sbl.dbx",
    },
    codefragment = {
      csl = "software",
      source = "software.dbx",
    },
    collection = {
      csl = "book",
      source = "biblatex",
    },
    comment = {
      csl = nil,
      notes = "Special entry type for Scribe compatibility",
      source = "bibtex",
    },
    commentary = {
      csl = "book",
      notes = "Not supported.",
      source = "biblatex",
    },
    commented = {
      csl = nil,
      source = "jurabib.bst",
    },
    committee = {
      csl = nil,
      source = "biblatex-cv.dbx",
    },
    conference = {
      alias = "inproceedings",
      csl = "paper-conference",
      source = "bibtex",
    },
    conferencepaper = {
      csl = "paper-conference",
      source = "sbl.dbx",
    },
    constitution = {
      csl = "legislation",
      source = "apa.dbx",
    },
    ctan = {
      csl = "software",
      source = "tugboat.bst",
    },
    customa = {
      csl = nil,
      source = "biblatex",
    },
    customb = {
      csl = nil,
      source = "biblatex",
    },
    customc = {
      csl = nil,
      source = "biblatex",
    },
    customd = {
      csl = nil,
      source = "biblatex",
    },
    custome = {
      csl = nil,
      source = "biblatex",
    },
    customf = {
      csl = nil,
      source = "biblatex",
    },
    data = {
      csl = nil,
      source = "apa6.dbx",
    },
    database = {
      csl = "dataset",
      source = "gbt7714-numerical.bst",
    },
    dataset = {
      csl = "dataset",
      source = "biblatex",
    },
    degree = {
      csl = nil,
      source = "biblatex-cv.dbx",
    },
    dictionary = {
      csl = "book",
      source = "vancouver.bst",
    },
    docthesis = {
      csl = "thesis",
      source = "gost2003.bst",
    },
    document = {
      csl = "document",
      source = "csl",
    },
    electronic = {
      alias = "online",
      csl = "webpage",
      source = "biblatex",
    },
    entry = {
      csl = "entry",
      source = "csl",
    },
    ["entry-dictionary"] = {
      csl = "entry-dictionary",
      source = "csl",
    },
    ["entry-encyclopedia"] = {
      csl = "entry-encyclopedia",
      source = "csl",
    },
    eulegislation = {
      csl = "legislation",
      source = "bath.bst",
    },
    event = {
      csl = "event",
      source = "csl",
    },
    exhibcatalog = {
      csl = nil,
      source = "arthistory-bonn.dbx",
    },
    figure = {
      csl = "figure",
      source = "csl",
    },
    footnote = {
      csl = nil,
      source = "apsrev4-2.bst",
    },
    funding = {
      csl = nil,
      source = "biblatex-cv.dbx",
    },
    game = {
      csl = "software",
      source = "ACM-Reference-Format.bst",
    },
    gitcommit = {
      csl = nil,
      source = "gitlog.dbx",
    },
    govpub = {
      csl = "regulation",
      source = "thesnumb.bst",
    },
    graphic = {
      csl = "graphic",
      source = "csl",
    },
    habthesis = {
      csl = "thesis",
      source = "bestpapers-export.bst",
    },
    heading = {
      csl = nil,
      source = "bookdb.bst",
    },
    hearing = {
      csl = "hearing",
      source = "csl",
    },
    hidden = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    image = {
      csl = "graphic",
      source = "biblatex",
    },
    inarticle = {
      csl = nil,
      source = "bookinother.dbx",
    },
    inaudio = {
      csl = nil,
      source = "oxalph.dbx",
    },
    inbook = {
      csl = "chapter",
      source = "bibtex",
    },
    incatalog = {
      csl = nil,
      source = "arthistory-bonn.dbx",
    },
    incollection = {
      csl = "chapter",
      source = "bibtex",
    },
    incommentary = {
      csl = nil,
      source = "sbl.dbx",
    },
    inexhibcatalog = {
      csl = nil,
      source = "arthistory-bonn.dbx",
    },
    ininarticle = {
      csl = nil,
      source = "bookinother.dbx",
    },
    ininbook = {
      csl = nil,
      source = "bookinother.dbx",
    },
    inincollection = {
      csl = nil,
      source = "bookinother.dbx",
    },
    ininproceedings = {
      csl = nil,
      source = "bookinother.dbx",
    },
    ininreference = {
      csl = nil,
      source = "bookinother.dbx",
    },
    inlexicon = {
      csl = nil,
      source = "sbl.dbx",
    },
    inloosecollection = {
      csl = "chapter",
      source = "resphilosophica.bst",
    },
    inmathesis = {
      csl = nil,
      source = "bookinother.dbx",
    },
    inmovie = {
      csl = nil,
      source = "oxalph.dbx",
    },
    inmusic = {
      csl = nil,
      source = "oxalph.dbx",
    },
    inphdthesis = {
      csl = nil,
      source = "bookinother.dbx",
    },
    inpress = {
      csl = "article",
      notes = "Use for preprints, working papers, and similar works posted on a platform where some level of persistence or stewardship is expected (e.g. arXiv or other preprint repositories, working paper series).",
      source = "bjnano.bst",
    },
    inproceedings = {
      csl = "paper-conference",
      source = "bibtex",
    },
    inreference = {
      csl = "entry",
      notes = "May also be `entry`, `entry-dictionary` or `entry-encyclopedia`.",
      source = "biblatex",
    },
    inserialcollection = {
      csl = nil,
      source = "asmejour.bst",
    },
    internet = {
      csl = "webpage",
      source = "IEEEtran.bst",
    },
    interview = {
      csl = "interview",
      source = "csl",
    },
    inthesis = {
      csl = nil,
      source = "bookinother.dbx",
    },
    invideo = {
      csl = nil,
      source = "oxalph.dbx",
    },
    journalpart = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    journals = {
      csl = "periodical",
      source = "bestpapers-export.bst",
    },
    jurisdiction = {
      csl = "legal_case",
      notes = '"Court decisions, court recordings, and similar things."',
      source = "biblatex",
    },
    jurthesis = {
      csl = "thesis",
      source = "jurabib.bst",
    },
    legadminmaterial = {
      csl = "regulation",
      source = "apa.dbx",
    },
    legal = {
      csl = "treaty",
      notes = '"Legal documents such as treaties."',
      source = "biblatex",
    },
    legal_case = {
      csl = "legal_case",
      source = "csl",
    },
    legislation = {
      csl = "legislation",
      notes = '"Laws, bills, legislative proposals, and similar things." May also be `bill`',
      source = "biblatex",
    },
    legmaterial = {
      csl = "legislation",
      source = "apa.dbx",
    },
    letter = {
      csl = "personal_communication",
      source = "biblatex",
    },
    letters = {
      csl = "personal_communication",
      source = "apa6.dbx",
    },
    lexicon = {
      csl = "book",
      source = "jurabib.bst",
    },
    majorthesis = {
      csl = "thesis",
      source = "achicago.bst",
    },
    manual = {
      csl = "report",
      notes = "CSL's `report` is also used for manuals and similar technical documentation (e.g. a software, instrument, or test manual).",
      source = "bibtex",
    },
    manuscript = {
      csl = "manuscript",
      source = "manuscripts-shared.dbx",
    },
    map = {
      csl = "map",
      source = "vancouver.bst",
    },
    mastersthesis = {
      alias = "thesis",
      csl = "thesis",
      source = "bibtex",
    },
    masterthesis = {
      csl = "thesis",
      source = "asaetr.bst",
    },
    minorthesis = {
      csl = "thesis",
      source = "achicago.bst",
    },
    misc = {
      csl = "document",
      notes = "New in CSL v1.0.2.",
      source = "bibtex",
    },
    mlasource = {
      csl = nil,
      source = "mla.dbx",
    },
    monograph = {
      csl = "book",
      source = "gbt7714-numerical.bst",
    },
    monography = {
      csl = "book",
      source = "abntex2-alf.bst",
    },
    motion_picture = {
      csl = "motion_picture",
      source = "csl",
    },
    movie = {
      csl = "motion_picture",
      source = "biblatex",
    },
    music = {
      csl = "song",
      source = "biblatex",
    },
    musical_score = {
      csl = "musical_score",
      source = "csl",
    },
    mvbook = {
      csl = "book",
      source = "biblatex",
    },
    mvcollection = {
      csl = "book",
      source = "biblatex",
    },
    mvcommentary = {
      csl = nil,
      source = "sbl.dbx",
    },
    mvlexicon = {
      csl = nil,
      source = "sbl.dbx",
    },
    mvproceedings = {
      csl = "book",
      source = "biblatex",
    },
    mvreference = {
      csl = "book",
      source = "biblatex",
    },
    nameonly = {
      csl = nil,
      source = "apa.dbx",
    },
    news = {
      csl = "article-newspaper",
      source = "seuthesix.bst",
    },
    newsarticle = {
      csl = "article-newspaper",
      source = "apa6.dbx",
    },
    newspaper = {
      csl = "article-newspaper",
      source = "gbt7714-numerical.bst",
    },
    online = {
      csl = "webpage",
      source = "biblatex",
    },
    other = {
      csl = nil,
      source = "bjnano.bst",
    },
    pamphlet = {
      csl = "pamphlet",
      source = "csl",
    },
    ["paper-conference"] = {
      csl = "paper-conference",
      source = "csl",
    },
    patent = {
      csl = "patent",
      source = "biblatex",
    },
    performance = {
      csl = "performance",
      notes = "New in CSL v1.0.2.",
      source = "biblatex",
    },
    periodical = {
      csl = "periodical",
      notes = "New in CSL v1.0.2.",
      source = "biblatex",
    },
    personal_communication = {
      csl = "personal_communication",
      source = "csl",
    },
    phdthesis = {
      alias = "thesis",
      csl = "thesis",
      source = "bibtex",
    },
    post = {
      csl = "post",
      source = "csl",
    },
    ["post-weblog"] = {
      csl = "post-weblog",
      source = "csl",
    },
    preamble = {
      csl = nil,
      notes = "Special entry type for inserting commands or text in the bbl",
      source = "bibtex",
    },
    preprint = {
      csl = "article",
      notes = "Use for preprints, working papers, and similar works posted on a platform where some level of persistence or stewardship is expected (e.g. arXiv or other preprint repositories, working paper series).",
      source = "gbt7714-numerical.bst",
    },
    presentation = {
      csl = "speech",
      notes = "A speech or other presentation (e.g. a paper, talk, poster, or symposium at a conference).",
      source = "apsrev4-2.bst",
    },
    proceedings = {
      csl = "book",
      source = "bibtex",
    },
    program = {
      csl = "software",
      source = "ChemCommun.bst",
    },
    reference = {
      csl = "book",
      source = "biblatex",
    },
    regulation = {
      csl = "regulation",
      source = "csl",
    },
    report = {
      csl = "report",
      source = "biblatex",
    },
    repository = {
      csl = nil,
      source = "quantum.bst",
    },
    review = {
      csl = "review",
      notes = '"A more specific variant of the `@article` type"',
      source = "biblatex",
    },
    ["review-book"] = {
      csl = "review-book",
      source = "csl",
    },
    school = {
      csl = nil,
      source = "biblatex-cv.dbx",
    },
    seminarpaper = {
      csl = nil,
      source = "sbl.dbx",
    },
    set = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
    },
    setup = {
      csl = nil,
      source = "bestpapers-export.bst",
    },
    software = {
      csl = "software",
      notes = "New in CSL v1.0.2.",
      source = "biblatex",
    },
    softwaremodule = {
      csl = "software",
      source = "software.dbx",
    },
    softwareversion = {
      csl = nil,
      source = "software.dbx",
    },
    song = {
      csl = "song",
      source = "csl",
    },
    speech = {
      csl = "speech",
      source = "csl",
    },
    standard = {
      csl = "standard",
      notes = "New in CSL v1.0.2.",
      source = "biblatex",
    },
    string = {
      csl = nil,
      notes = "Special entry type for defining abbreviations",
      source = "bibtex",
    },
    student = {
      csl = nil,
      source = "biblatex-cv.dbx",
    },
    suppbook = {
      csl = "chapter",
      notes = 'lossy mapping; "Supplemental material in a `@book`. This type is closely related to the @inbook entry type. While `@inbook` is primarily intended for a part of a book with its own title (e. g., a single essay in a collection of essays by the same author), this type is provided for elements such as prefaces, introductions, forewords, afterwords, etc. which often have a generic title only. Style guides may require such items to be formatted differently from other `@inbook` items."',
      source = "biblatex",
    },
    suppcollection = {
      csl = "chapter",
      notes = "lossy mapping; see `suppbook`",
      source = "biblatex",
    },
    suppperiodical = {
      csl = "article",
      notes = "see `article`",
      source = "biblatex",
    },
    talk = {
      csl = "speech",
      source = "archaeologie.dbx",
    },
    teaching = {
      csl = nil,
      source = "biblatex-cv.dbx",
    },
    techreport = {
      alias = "report",
      csl = "report",
      source = "bibtex",
    },
    techstandard = {
      csl = "standard",
      notes = "New in CSL v1.0.2.",
      source = "udesoftec.bst",
    },
    thesis = {
      csl = "thesis",
      source = "biblatex",
    },
    treaty = {
      csl = "treaty",
      source = "csl",
    },
    uklegislation = {
      csl = "legislation",
      source = "bath.bst",
    },
    unpublished = {
      csl = "manuscript",
      notes = "For unpublished works not made widely available or only hosted on personal websites, use manuscript",
      source = "bibtex",
    },
    video = {
      csl = "motion_picture",
      source = "biblatex",
    },
    webpage = {
      csl = "webpage",
      source = "IEEEtran.bst",
    },
    website = {
      csl = "webpage",
      source = "quantum.bst",
    },
    www = {
      alias = "online",
      csl = "webpage",
      source = "biblatex",
    },
    xdata = {
      csl = nil,
      notes = 'special item type: "`@xdata` entries hold data which may be inherited by other entries using the xdata field. Entries of this type only serve as data containers; they may not be cited or added to the bibliography."',
      source = "biblatex",
    },
  },
  fields = {
    abstract = {
      csl = "abstract",
      source = "biblatex",
      type = "literal",
    },
    abstractloc = {
      csl = nil,
      source = "apa6.dbx",
      type = "literal",
    },
    abstracturl = {
      csl = nil,
      source = "apa6.dbx",
      type = "verbatim",
    },
    accessed = {
      csl = "accessed",
      source = "csl",
    },
    account = {
      csl = nil,
      source = "address-html.bst",
    },
    acronym = {
      csl = nil,
      source = "export.bst",
      type = "literal",
    },
    actor = {
      csl = "performer",
      source = "fiwi.dbx",
      type = "name",
    },
    add = {
      csl = nil,
      source = "figbib.bst",
    },
    add1 = {
      csl = nil,
      source = "figbib1.bst",
    },
    addendum = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    address = {
      alias = "location",
      csl = "publisher-place",
      source = "bibtex",
      type = "literal",
    },
    adsurl = {
      csl = nil,
      source = "mnras.bst",
    },
    advisor = {
      csl = nil,
      source = "ACM-Reference-Format.bst",
      type = "name",
    },
    afterword = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "name",
    },
    alternatetitle = {
      csl = nil,
      source = "fiwi.dbx",
      type = "literal",
    },
    alternatetitlescript = {
      csl = nil,
      source = "fiwi.dbx",
      type = "literal",
    },
    amendment = {
      csl = nil,
      source = "apa.dbx",
      type = "literal",
    },
    amount = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "integer",
    },
    annotate = {
      csl = "note",
      source = "apacite.bst",
    },
    annotation = {
      csl = "note",
      notes = "Descriptive text or notes about an item (e.g. in an annotated bibliography)",
      source = "biblatex",
      type = "literal",
    },
    annotator = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    annote = {
      alias = "annotation",
      csl = "note",
      source = "biblatex",
      type = "literal",
    },
    annotelanguage = {
      csl = nil,
      source = "bababbr3-fl.bst",
    },
    anonstring = {
      csl = nil,
      source = "aefkw.dbx",
      type = "name",
    },
    appentry = {
      csl = nil,
      source = "apa.dbx",
      type = "literal",
    },
    applicant = {
      csl = nil,
      source = "seuthesix.bst",
    },
    arachne = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "verbatim",
    },
    archive = {
      csl = "archive",
      source = "apsrev4-2.bst",
    },
    ["archive-place"] = {
      csl = "archive-place",
      source = "csl",
    },
    archive_collection = {
      csl = "archive_collection",
      source = "csl",
    },
    archive_location = {
      csl = "archive_location",
      source = "csl",
    },
    archiveprefix = {
      alias = "eprinttype",
      csl = "archive",
      source = "biblatex",
      type = "literal",
    },
    archname = {
      csl = "archive",
      source = "jurabib.bst",
    },
    arthist = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "integer",
    },
    arthistdate = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "date",
    },
    article = {
      csl = nil,
      notes = "Should be prepended to the section field (e.g., article I section 3)",
      source = "apa.dbx",
      type = "literal",
    },
    articleno = {
      csl = nil,
      source = "ACM-Reference-Format.bst",
      type = "literal",
    },
    arxiv = {
      csl = nil,
      source = "aomalpha.bst",
    },
    assignee = {
      csl = nil,
      source = "vancouver.bst",
    },
    author = {
      csl = "author",
      source = "bibtex",
      type = "name",
    },
    authoraddon = {
      csl = nil,
      source = "oxalph.dbx",
      type = "name",
    },
    authorcountry = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    authorfa = {
      csl = nil,
      source = "asa-fa.bst",
    },
    authority = {
      csl = "authority",
      source = "csl",
    },
    authortype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    ["available-date"] = {
      csl = "available-date",
      source = "csl",
    },
    bibsource = {
      csl = nil,
      source = "export.bst",
    },
    biburl = {
      csl = nil,
      source = "export.bst",
    },
    binding = {
      csl = nil,
      source = "bookdb.bst",
    },
    birthday = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    birthyear = {
      csl = nil,
      source = "address-html.bst",
    },
    blogsubtitle = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    blogtitle = {
      csl = "title",
      source = "windycity.dbx",
      type = "literal",
    },
    blogtitleaddon = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    book = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "range",
    },
    bookaddress = {
      csl = "publisher-place",
      source = "apsrev4-2.bst",
    },
    bookafterword = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "name",
    },
    bookannotator = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "name",
    },
    bookauthor = {
      csl = "container-author",
      source = "biblatex",
      type = "name",
    },
    bookauthortype = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    bookbooksubtitle = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    bookbooktitle = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    bookbooktitleaddon = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    bookbooktitlekey = {
      csl = nil,
      source = "windycity.dbx",
      type = "key",
    },
    bookbookvolume = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    bookcommentator = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "name",
    },
    bookcredits = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    bookeditor = {
      csl = "editor",
      source = "bookinother.dbx",
      type = "name",
    },
    bookforeword = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "name",
    },
    bookineditor = {
      csl = nil,
      source = "bookinother.dbx",
      type = "name",
    },
    bookintroduction = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "name",
    },
    booklanguage = {
      csl = nil,
      source = "gost2003.bst",
    },
    bookoriglanguage = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "key",
    },
    bookpages = {
      csl = nil,
      source = "ACM-Reference-Format.bst",
    },
    bookpagination = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    books = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    booksubtitle = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    booktitle = {
      csl = "container-title",
      source = "bibtex",
      type = "literal",
    },
    booktitleaddon = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    booktitlekey = {
      csl = nil,
      source = "windycity.dbx",
      type = "key",
    },
    booktitlenote = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    booktranslator = {
      csl = "translator",
      source = "biblatex-gost.dbx",
      type = "name",
    },
    bookvolume = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    bookyear = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    by = {
      csl = nil,
      source = "iran-unsrt.bst",
    },
    ["call-number"] = {
      csl = "call-number",
      source = "csl",
    },
    caption = {
      csl = nil,
      source = "figbib.bst",
    },
    caption1 = {
      csl = nil,
      source = "figbib1.bst",
    },
    cartographer = {
      csl = nil,
      source = "vancouver.bst",
    },
    casenumber = {
      csl = nil,
      source = "bath.bst",
    },
    catalog = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    category = {
      csl = nil,
      source = "bookdb.bst",
    },
    cellular = {
      csl = nil,
      source = "address-html.bst",
    },
    chair = {
      csl = "chair",
      source = "apacite.bst",
    },
    chapter = {
      csl = "chapter-number",
      source = "bibtex",
      type = "literal",
    },
    ["chapter-number"] = {
      csl = "chapter-number",
      source = "csl",
    },
    citation = {
      csl = nil,
      source = "apa.dbx",
      type = "literal",
    },
    citations = {
      csl = nil,
      source = "publist.dbx",
      type = "literal",
    },
    citedate = {
      csl = nil,
      source = "seuthesis.bst",
    },
    city = {
      csl = nil,
      source = "ACM-Reference-Format.bst",
    },
    classes = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "entrykey",
    },
    claves = {
      csl = nil,
      source = "claves.dbx",
      type = "literal",
    },
    claves_definition = {
      csl = nil,
      source = "claves.dbx",
      type = "literal",
    },
    code = {
      csl = nil,
      source = "quantum.bst",
    },
    coden = {
      csl = nil,
      source = "is-abbrv.bst",
    },
    collaboration = {
      csl = nil,
      source = "apsrev4-2.bst",
      type = "literal",
    },
    collator = {
      csl = nil,
      source = "bookdb.bst",
    },
    collection = {
      csl = nil,
      source = "bath.dbx",
      type = "literal",
    },
    ["collection-editor"] = {
      csl = "collection-editor",
      source = "csl",
    },
    ["collection-number"] = {
      csl = "collection-number",
      source = "csl",
    },
    ["collection-title"] = {
      csl = "collection-title",
      source = "csl",
    },
    columns = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    comment = {
      csl = nil,
      source = "abstract.bst",
    },
    commentator = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    commit = {
      csl = nil,
      source = "quantum.bst",
    },
    commithash = {
      csl = nil,
      source = "gitlog.dbx",
      type = "literal",
    },
    committee = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "name",
    },
    compiler = {
      csl = "compiler",
      source = "gost2003.bst",
    },
    composer = {
      csl = "composer",
      source = "csl",
    },
    concentration = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    condition = {
      csl = nil,
      source = "bookdb.bst",
    },
    ["conference-location"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    ["conference-number"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    ["conference-year"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    ["container-author"] = {
      csl = "container-author",
      source = "csl",
    },
    ["container-title"] = {
      csl = "container-title",
      source = "csl",
    },
    ["container-title-short"] = {
      csl = "container-title-short",
      source = "csl",
    },
    contents = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    contributor = {
      csl = "contributor",
      source = "csl",
    },
    contributora = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    contributorb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    copublisher = {
      csl = nil,
      source = "gzt.dbx",
      type = "literal",
    },
    copy = {
      csl = nil,
      source = "bookdb.bst",
    },
    country = {
      csl = "jurisdiction",
      source = "adrbirthday.bst",
    },
    credits = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    crossref = {
      csl = nil,
      notes = "Inherits data from a parent entry.",
      source = "biblatex",
      type = "entrykey",
    },
    curator = {
      csl = "curator",
      source = "csl",
    },
    currency = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    custom = {
      csl = "custom",
      source = "csl",
    },
    dataset = {
      csl = nil,
      source = "apalike-ejor.bst",
    },
    date = {
      csl = "issued",
      source = "biblatex",
      type = "date",
    },
    ["date+an"] = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    datea = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    dateaddon = {
      csl = nil,
      source = "iso-alphabetic.dbx",
      type = "literal",
    },
    dateb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    datetype = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    dating = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    day = {
      csl = nil,
      source = "apacite.bst",
    },
    dayfiled = {
      csl = nil,
      source = "IEEEtran.bst",
    },
    decision = {
      alias = "usera",
      csl = nil,
      source = "biblatex-juradiss.dbx",
      type = "literal",
    },
    decisionname = {
      alias = "userf",
      csl = nil,
      source = "biblatex-juradiss.dbx",
      type = "literal",
    },
    definition = {
      csl = nil,
      source = "glsplain.bst",
    },
    degree = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    degreelist = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "entrykey",
    },
    department = {
      csl = nil,
      source = "ametsoc2014.bst",
      type = "literal",
    },
    description = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    designator = {
      csl = nil,
      source = "thesnumb.bst",
    },
    dimensions = {
      csl = "dimensions",
      source = "abntex2-alf.bst",
    },
    director = {
      csl = "director",
      source = "apa6.dbx",
      type = "name",
    },
    dissyear = {
      csl = nil,
      source = "jurabib.bst",
    },
    distinctURL = {
      csl = nil,
      source = "acmdatamodel.dbx",
      type = "literal",
    },
    division = {
      csl = "division",
      source = "csl",
    },
    doi = {
      csl = "DOI",
      source = "biblatex",
      type = "verbatim",
    },
    dticnumber = {
      csl = nil,
      source = "thesnumb.bst",
    },
    dummy = {
      csl = nil,
      source = "expcites.bst",
    },
    duration = {
      csl = nil,
      source = "fiwi.dbx",
      type = "literal",
    },
    durationtype = {
      csl = nil,
      source = "fiwi.dbx",
      type = "literal",
    },
    edition = {
      csl = "edition",
      source = "bibtex",
      type = "literal",
    },
    editioncredits = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    editor = {
      csl = "editor",
      source = "bibtex",
      type = "name",
    },
    editora = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    editoraaddon = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    editoraddon = {
      csl = nil,
      source = "oxalph.dbx",
      type = "name",
    },
    editoratype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    editorb = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    editorbtype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    editorc = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    editorctype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    ["editorial-director"] = {
      csl = "editorial-director",
      source = "csl",
    },
    editortype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    eid = {
      csl = "number",
      source = "biblatex",
      type = "literal",
    },
    email = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    endbookyear = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    endnumber = {
      csl = nil,
      source = "seuthesis.bst",
    },
    endvolume = {
      csl = nil,
      source = "seuthesis.bst",
    },
    endyear = {
      csl = nil,
      source = "seuthesis.bst",
    },
    englishabstract = {
      csl = nil,
      source = "gzt.dbx",
      type = "literal",
    },
    englishtitle = {
      csl = nil,
      source = "apacite.bst",
    },
    entryset = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "entrykey",
    },
    entrysubtype = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    epilog = {
      csl = nil,
      source = "iopart-num.bst",
    },
    eprint = {
      csl = nil,
      notes = 'Mapped to `PMID` if `eprinttype` is "PubMed".',
      source = "biblatex",
      type = "verbatim",
    },
    eprintclass = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    eprintdate = {
      csl = nil,
      source = "sbl.dbx",
      type = "date",
    },
    eprintday = {
      csl = nil,
      source = "sbl.dbx",
      type = "datepart",
    },
    eprintmonth = {
      csl = nil,
      source = "sbl.dbx",
      type = "datepart",
    },
    eprints = {
      csl = nil,
      source = "databib.bst",
    },
    eprinttype = {
      csl = "archive",
      source = "biblatex",
      type = "literal",
    },
    eprintyear = {
      csl = nil,
      source = "sbl.dbx",
      type = "datepart",
    },
    erratumeid = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    erratumgermanpages = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    erratumnumpages = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    erratumpages = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    erratumvolume = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    erratumyear = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    event = {
      csl = "event-title",
      source = "csl",
    },
    ["event-date"] = {
      csl = "event-date",
      source = "csl",
    },
    ["event-place"] = {
      csl = "event-place",
      source = "csl",
    },
    ["event-title"] = {
      csl = "event-title",
      source = "csl",
    },
    eventdate = {
      csl = "event-date",
      source = "biblatex",
      type = "date",
    },
    eventdatelanguage = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "verbatim",
    },
    eventnumber = {
      csl = nil,
      source = "aefkw.dbx",
      type = "integer",
    },
    eventsubtitle = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "literal",
    },
    eventtitle = {
      csl = "event-title",
      notes = "Supercedes `event` in CSL v1.0.2.",
      source = "biblatex",
      type = "literal",
    },
    eventtitleaddon = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    eventtype = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    eventyear = {
      csl = nil,
      source = "bath.bst",
    },
    execdirector = {
      csl = "director",
      source = "apa.dbx",
      type = "name",
    },
    execproducer = {
      csl = "executive-producer",
      source = "apa.dbx",
      type = "name",
    },
    execute = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "code",
    },
    ["executive-producer"] = {
      csl = "executive-producer",
      source = "csl",
    },
    exhibfirstdate = {
      csl = "event-date",
      source = "arthistory-bonn.dbx",
      type = "date",
    },
    exhibfirstlocation = {
      csl = "event-place",
      source = "arthistory-bonn.dbx",
      type = "literal",
    },
    exhibfirstmuseum = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "literal",
    },
    exhibseconddate = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "date",
    },
    exhibsecondlocation = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "literal",
    },
    exhibsecondmuseum = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "literal",
    },
    exhibthirddate = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "date",
    },
    exhibthirdlocation = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "literal",
    },
    exhibthirdmuseum = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "literal",
    },
    faddress = {
      csl = nil,
      source = "achicago.bst",
    },
    fakeset = {
      csl = nil,
      source = "biblatex.bst",
    },
    fax = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    festschrift = {
      csl = nil,
      source = "aefkw.dbx",
      type = "name",
    },
    festschriftaddon = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    file = {
      csl = nil,
      source = "biblatex",
      type = "verbatim",
    },
    firstkey = {
      csl = nil,
      source = "apacite.bst",
    },
    fjournal = {
      csl = nil,
      source = "ijmart.bst",
    },
    flanguage = {
      csl = nil,
      source = "achicago.bst",
    },
    font = {
      csl = nil,
      source = "nederlands.bst",
    },
    foreword = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    founder = {
      csl = nil,
      source = "jurabib.bst",
    },
    fpublisher = {
      csl = nil,
      source = "achicago.bst",
    },
    frenchabstract = {
      csl = nil,
      source = "gzt.dbx",
      type = "literal",
    },
    ftitle = {
      csl = nil,
      source = "achicago.bst",
    },
    fulleventdate = {
      csl = nil,
      source = "aefkw.dbx",
      type = "date",
    },
    funder = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    furtherresp = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    fyear = {
      csl = nil,
      source = "achicago.bst",
    },
    gender = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    genre = {
      csl = "genre",
      source = "csl",
    },
    germanpages = {
      csl = nil,
      source = "ChemCommun.bst",
    },
    gpa = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    group = {
      csl = nil,
      source = "glsplain.bst",
    },
    guest = {
      csl = "guest",
      source = "csl",
    },
    hal_id = {
      csl = nil,
      source = "software.dbx",
      type = "verbatim",
    },
    hal_version = {
      csl = "version",
      source = "software.dbx",
      type = "verbatim",
    },
    handle = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    heading = {
      csl = nil,
      source = "glsplain.bst",
      type = "literal",
    },
    hereafter = {
      csl = nil,
      source = "opcit.bst",
    },
    holder = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    honors = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    host = {
      csl = "host",
      source = "csl",
    },
    howcited = {
      csl = nil,
      source = "jox.bst",
    },
    howpublished = {
      csl = nil,
      notes = "Check if a URL is contained.",
      source = "bibtex",
      type = "literal",
    },
    hyphenation = {
      alias = "langid",
      csl = "language",
      source = "biblatex",
      type = "literal",
    },
    ids = {
      csl = nil,
      source = "biblatex",
      type = "entrykey",
    },
    illustrated = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    illustrations = {
      csl = nil,
      source = "bookdb.bst",
    },
    illustrator = {
      csl = "illustrator",
      source = "achicago.bst",
    },
    impactfactor = {
      csl = nil,
      source = "publist.dbx",
      type = "literal",
    },
    impression = {
      csl = nil,
      source = "iran-unsrt.bst",
    },
    inafterword = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "name",
    },
    inannotator = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "name",
    },
    incommentator = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "name",
    },
    indexsorttitle = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    indextitle = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    ineditor = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "name",
    },
    inforeword = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "name",
    },
    inintroduction = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "name",
    },
    institution = {
      csl = "publisher",
      source = "bibtex",
      type = "literal",
    },
    internalsortbook = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    internalsortissue = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    internalsortpart = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    internalsortvolume = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    interviewee = {
      csl = nil,
      source = "gzt.dbx",
      type = "name",
    },
    interviewer = {
      csl = "interviewer",
      source = "csl",
    },
    intranslator = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "name",
    },
    introducedin = {
      csl = nil,
      source = "software.dbx",
      type = "literal",
    },
    introduction = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    intype = {
      csl = nil,
      source = "IEEEtran.bst",
    },
    inventor = {
      csl = "author",
      source = "vancouver.bst",
    },
    ipc = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    isan = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    isbn = {
      csl = "ISBN",
      source = "biblatex",
      type = "literal",
    },
    ismn = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    ["iso-abbreviation"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    ["iso-author-punctuation"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    ["iso-date-place"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    isrn = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    issn = {
      csl = "ISSN",
      source = "biblatex",
      type = "literal",
    },
    issue = {
      csl = "issue",
      source = "biblatex",
      type = "literal",
    },
    issued = {
      csl = "issued",
      source = "csl",
    },
    issues = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    issuesubtitle = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    issuetitle = {
      csl = "volume-title",
      source = "biblatex",
      type = "literal",
    },
    issuetitleaddon = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    iswc = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    jfmnumber = {
      csl = nil,
      source = "aomalpha.bst",
    },
    jointauthor = {
      csl = nil,
      source = "oxalph.dbx",
      type = "name",
    },
    jointauthortype = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    journal = {
      alias = "journaltitle",
      csl = "container-title",
      source = "bibtex",
      type = "literal",
    },
    journalabbreviation = {
      csl = "container-title-short",
      source = "csl",
    },
    journalsubtitle = {
      csl = nil,
      notes = "It should be concatenated to the `container-title`.",
      source = "biblatex",
      type = "literal",
    },
    journaltie = {
      csl = nil,
      source = "tugboat.bst",
    },
    journaltitle = {
      csl = "container-title",
      source = "biblatex",
      type = "literal",
    },
    journaltitleaddon = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    journalyear = {
      alias = "usere",
      csl = nil,
      source = "biblatex-juradiss.dbx",
      type = "literal",
    },
    jstor = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "verbatim",
    },
    juraauthor = {
      csl = nil,
      source = "jox.bst",
    },
    juratitle = {
      csl = nil,
      source = "jox.bst",
    },
    jurisdiction = {
      csl = "jurisdiction",
      source = "csl",
    },
    key = {
      alias = "sortkey",
      csl = nil,
      notes = "Not supported.",
      source = "bibtex",
      type = "literal",
    },
    keyword = {
      csl = "keyword",
      source = "csl",
    },
    keywords = {
      csl = nil,
      source = "biblatex",
      type = "keyword",
    },
    label = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    lang = {
      csl = nil,
      source = "hustthesis.bst",
    },
    langid = {
      csl = "language",
      notes = "The language id of the bibliography entry. The identifier must be a language name known to the babel/polyglossia packages. It should be converted to ISO 639-1 language code in CSL.",
      source = "biblatex",
      type = "literal",
    },
    langidopts = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    language = {
      csl = "language",
      notes = "The `language` field in `biblatex` has no special internal meaning thus it is used only when langid is missing.",
      source = "biblatex",
      type = "key",
    },
    lastaccessed = {
      csl = "accessed",
      source = "ACM-Reference-Format.bst",
      type = "literal",
    },
    lastchecked = {
      csl = "accessed",
      source = "apacite.bst",
    },
    layer = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    lccn = {
      csl = nil,
      source = "is-abbrv.bst",
    },
    library = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    librarylocation = {
      csl = "archive-place",
      source = "fiwi.dbx",
      type = "literal",
    },
    license = {
      csl = "license",
      source = "software.dbx",
      type = "literal",
    },
    lista = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    listb = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    listc = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    listd = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    liste = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    listf = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    littype = {
      csl = nil,
      source = "seuthesix.bst",
    },
    location = {
      csl = "publisher-place",
      source = "biblatex",
      type = "literal",
    },
    locationa = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    locationb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    madadurltest = {
      csl = nil,
      source = "alpha-persian.bst",
    },
    main = {
      csl = nil,
      source = "figbib.bst",
    },
    main1 = {
      csl = nil,
      source = "figbib1.bst",
    },
    mainauthor = {
      csl = nil,
      source = "bookinother.dbx",
      type = "name",
    },
    maineditor = {
      csl = nil,
      source = "morenames.dbx",
      type = "name",
    },
    mainsubtitle = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    maintainer = {
      csl = nil,
      source = "cnltx.dbx",
      type = "name",
    },
    maintitle = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    maintitleaddon = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    maintitlenote = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    maintranslator = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    major = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    majorcode = {
      csl = nil,
      source = "gost2003.bst",
    },
    marginnote = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    mark = {
      csl = nil,
      source = "gbt7714-numerical.bst",
    },
    ["max.best.papers"] = {
      csl = nil,
      source = "bestpapers-export.bst",
    },
    mcitetail = {
      csl = nil,
      source = "apsrmpM.bst",
    },
    media = {
      csl = "medium",
      source = "gost2003.bst",
      type = "key",
    },
    medium = {
      csl = "medium",
      source = "gbt7714-numerical.bst",
    },
    meeting = {
      csl = nil,
      source = "amsra.bst",
    },
    minor = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    misctitle = {
      csl = nil,
      source = "aasjournal.bst",
    },
    miscyear = {
      csl = nil,
      source = "seuthesis.bst",
    },
    mobile = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    modifydate = {
      csl = nil,
      source = "seuthesis.bst",
    },
    month = {
      csl = nil,
      notes = "Used only when `date` is empty.",
      source = "bibtex",
      type = "literal",
    },
    monthfiled = {
      csl = nil,
      source = "IEEEtran.bst",
    },
    monthtie = {
      csl = nil,
      source = "tugboat.bst",
    },
    mrnumber = {
      csl = nil,
      source = "amsplain.bst",
    },
    multieventdate = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    multivenue = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    name = {
      csl = nil,
      source = "adrbirthday.bst",
      type = "name",
    },
    namea = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    nameaddon = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    nameatype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    nameb = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    namebtype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    namec = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    namectype = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    narrator = {
      csl = "narrator",
      source = "apa.dbx",
      type = "name",
    },
    nationality = {
      csl = nil,
      source = "IEEEtran.bst",
    },
    nbirthday = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    neutralcite = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    newpage = {
      csl = nil,
      source = "tugboat.bst",
    },
    newsdate = {
      csl = nil,
      source = "aefkw.dbx",
      type = "date",
    },
    newspaper = {
      csl = "container-title",
      source = "seuthesix.bst",
      type = "literal",
    },
    nickname = {
      csl = nil,
      source = "address-html.bst",
    },
    nihms = {
      csl = nil,
      source = "apacite.bst",
    },
    noed = {
      csl = nil,
      source = "jox.bst",
    },
    nojournalcomma = {
      csl = nil,
      source = "tugboat.bst",
    },
    nolink = {
      csl = nil,
      source = "quantum.bst",
    },
    normal = {
      csl = nil,
      source = "bookdb.bst",
    },
    normalauthor = {
      csl = nil,
      source = "seuthesis.bst",
    },
    normaleditor = {
      csl = nil,
      source = "seuthesis.bst",
    },
    note = {
      csl = "note",
      source = "bibtex",
      type = "literal",
    },
    nowarning = {
      csl = nil,
      source = "tugboat.bst",
    },
    number = {
      csl = nil,
      notes = "This field is used as `issue` in `article` type or `collection-number` with `collection-title` in `book` type. It is also `number` in `@patent` or `@report`.",
      source = "bibtex",
      type = "literal",
    },
    ["number-of-pages"] = {
      csl = "number-of-pages",
      source = "csl",
    },
    ["number-of-volumes"] = {
      csl = "number-of-volumes",
      source = "csl",
    },
    numbera = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    numberb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    numcites = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "integer",
    },
    numlectures = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "integer",
    },
    numpages = {
      csl = "number-of-pages",
      source = "ACM-Reference-Format.bst",
      type = "literal",
    },
    numstudents = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "integer",
    },
    oaddress = {
      csl = "original-publisher-place",
      source = "achicago.bst",
    },
    officialpages = {
      alias = "userd",
      csl = nil,
      source = "biblatex-juradiss.dbx",
      type = "literal",
    },
    officialvolume = {
      alias = "userc",
      csl = nil,
      source = "biblatex-juradiss.dbx",
      type = "literal",
    },
    openaccess = {
      csl = nil,
      source = "publist.dbx",
      type = "literal",
    },
    options = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "option",
    },
    opublisher = {
      csl = "original-publisher",
      source = "achicago.bst",
    },
    ["org-short"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    organization = {
      csl = nil,
      notes = "The `organizer` that sponsors a conference or a `publisher` that publishes a `@manual` or `@online`.",
      source = "bibtex",
      type = "literal",
    },
    organizer = {
      csl = "organizer",
      source = "csl",
    },
    origdate = {
      csl = "original-date",
      source = "biblatex",
      type = "date",
    },
    ["origdate+an"] = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    origdatetype = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    origin = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    ["original-author"] = {
      csl = "original-author",
      source = "csl",
    },
    ["original-date"] = {
      csl = "original-date",
      source = "csl",
    },
    ["original-publisher"] = {
      csl = "original-publisher",
      source = "csl",
    },
    ["original-publisher-place"] = {
      csl = "original-publisher-place",
      source = "csl",
    },
    ["original-title"] = {
      csl = "original-title",
      source = "csl",
    },
    originaladdress = {
      csl = "original-publisher-place",
      source = "apacite.bst",
    },
    originalbooktitle = {
      csl = nil,
      source = "apacite.bst",
    },
    originaledition = {
      csl = nil,
      source = "apacite.bst",
    },
    originaleditor = {
      csl = nil,
      source = "apacite.bst",
    },
    originaljournal = {
      csl = nil,
      source = "apacite.bst",
    },
    originalnumber = {
      csl = nil,
      source = "apacite.bst",
    },
    originalpages = {
      csl = nil,
      source = "apacite.bst",
    },
    originalpublisher = {
      csl = "original-publisher",
      source = "apacite.bst",
    },
    originalvolume = {
      csl = nil,
      source = "apacite.bst",
    },
    originalyear = {
      csl = "original-date",
      source = "apacite.bst",
    },
    origlanguage = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    origlocation = {
      csl = "original-publisher-place",
      source = "biblatex",
      type = "literal",
    },
    origpublisher = {
      csl = "original-publisher",
      source = "biblatex",
      type = "literal",
    },
    origrealdate = {
      csl = nil,
      source = "aefkw.dbx",
      type = "date",
    },
    origtitle = {
      csl = "original-title",
      source = "biblatex",
      type = "literal",
    },
    owner = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "name",
    },
    oyear = {
      csl = nil,
      source = "achicago.bst",
    },
    page = {
      csl = "page",
      source = "csl",
    },
    pagename = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    pages = {
      csl = "page",
      source = "bibtex",
      type = "range",
    },
    pagesnodashify = {
      csl = nil,
      source = "tugboat.bst",
    },
    pagetotal = {
      csl = "number-of-pages",
      source = "biblatex",
      type = "literal",
    },
    pagination = {
      csl = nil,
      source = "biblatex",
      type = "key",
    },
    paper = {
      csl = nil,
      source = "IEEEtran.bst",
    },
    pardate = {
      csl = nil,
      source = "oxalph.dbx",
      type = "date",
    },
    parpages = {
      csl = nil,
      source = "oxalph.dbx",
      type = "range",
    },
    parreporter = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    parseries = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    part = {
      csl = "part",
      source = "biblatex",
      type = "literal",
    },
    ["part-title"] = {
      csl = "part-title",
      source = "csl",
    },
    parts = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    parttitle = {
      csl = nil,
      source = "fiwi.dbx",
      type = "literal",
    },
    parvolume = {
      csl = nil,
      source = "oxalph.dbx",
      type = "integer",
    },
    patentid = {
      csl = nil,
      source = "seuthesis.bst",
    },
    pdf = {
      alias = "file",
      csl = nil,
      source = "biblatex",
      type = "verbatim",
    },
    peerreview = {
      csl = nil,
      source = "publist.dbx",
      type = "literal",
    },
    performer = {
      csl = "performer",
      source = "csl",
    },
    phone = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    pid = {
      csl = nil,
      source = "seuthesix.bst",
    },
    pii = {
      csl = nil,
      source = "amsra.bst",
    },
    pmc = {
      csl = nil,
      source = "hep-bibliography.dbx",
      type = "literal",
    },
    pmcid = {
      csl = "PMCID",
      source = "apacite.bst",
      type = "literal",
    },
    pmid = {
      csl = "PMID",
      source = "hep-bibliography.dbx",
      type = "literal",
    },
    prebibitem = {
      csl = nil,
      source = "tugboat.bst",
    },
    preface = {
      csl = nil,
      source = "bookdb.bst",
      type = "name",
    },
    preprint = {
      csl = nil,
      source = "amsra.bst",
    },
    presentationtype = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "literal",
    },
    presenter = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "name",
    },
    presort = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    price = {
      csl = nil,
      source = "is-abbrv.bst",
    },
    primaryclass = {
      alias = "eprintclass",
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    printing = {
      csl = nil,
      source = "dk-abbrv.bst",
    },
    ["printing-number"] = {
      csl = "printing-number",
      source = "csl",
    },
    prioritycountry = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    prioritydate = {
      csl = nil,
      source = "gost2003.bst",
      type = "date",
    },
    prioritynumber = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    private = {
      csl = nil,
      source = "abstract.bst",
    },
    producer = {
      csl = "producer",
      source = "apa6.dbx",
      type = "name",
    },
    production = {
      csl = nil,
      source = "fiwi.dbx",
      type = "literal",
    },
    protocollessurl = {
      csl = nil,
      source = "hep-bibliography.dbx",
      type = "uri",
    },
    pseudonym = {
      csl = nil,
      source = "jox.bst",
    },
    publication = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    publicationdate = {
      csl = nil,
      source = "gost2003.bst",
      type = "date",
    },
    publicprice = {
      csl = nil,
      source = "gzt.dbx",
      type = "literal",
    },
    publisher = {
      csl = "publisher",
      source = "bibtex",
      type = "literal",
    },
    ["publisher-place"] = {
      csl = "publisher-place",
      source = "csl",
    },
    publishera = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    publisherb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    pubmed = {
      csl = "PMID",
      source = "urlbst",
    },
    pubstate = {
      csl = "status",
      notes = "The publication state of the work, e. g., ‘in press’.",
      source = "biblatex",
      type = "key",
    },
    rawauthor = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    realauthor = {
      csl = nil,
      source = "realauthor.dbx",
      type = "name",
    },
    realdate = {
      csl = nil,
      source = "aefkw.dbx",
      type = "date",
    },
    realeditor = {
      csl = nil,
      source = "realauthor.dbx",
      type = "name",
    },
    recipient = {
      csl = "recipient",
      source = "csl",
    },
    references = {
      csl = "references",
      source = "csl",
    },
    related = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "entrykey",
    },
    relatedoptions = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "option",
    },
    relatedstring = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    relatedtype = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    reportnumber = {
      csl = nil,
      source = "hep-bibliography.dbx",
      type = "literal",
    },
    repository = {
      csl = nil,
      source = "software.dbx",
      type = "uri",
    },
    ["reprinted-from"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    ["reprinted-text"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    reprinttitle = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    requestdate = {
      csl = nil,
      source = "gost2003.bst",
    },
    requestnumber = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    responsible = {
      csl = nil,
      source = "rusnat.bst",
    },
    revdauthor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    revdeditor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    revdshorttitle = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    revdsubtitle = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    revdtitle = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    revdtitleaddon = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    review = {
      csl = nil,
      source = "amsra.bst",
    },
    ["reviewed-author"] = {
      csl = "reviewed-author",
      source = "csl",
    },
    ["reviewed-genre"] = {
      csl = "reviewed-genre",
      source = "csl",
    },
    ["reviewed-title"] = {
      csl = "reviewed-title",
      source = "csl",
    },
    reviewer = {
      csl = nil,
      source = "gzt.dbx",
      type = "name",
    },
    reviewerinstitution = {
      csl = nil,
      source = "gzt.dbx",
      type = "literal",
    },
    revision = {
      csl = nil,
      source = "IEEEtran.bst",
    },
    role = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "key",
    },
    scale = {
      csl = "scale",
      source = "csl",
    },
    school = {
      alias = "institution",
      csl = "publisher",
      source = "bibtex",
      type = "literal",
    },
    science = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    score = {
      csl = nil,
      source = "bestpapers-export.bst",
    },
    scribe = {
      csl = nil,
      source = "oxalph.dbx",
      type = "name",
    },
    script = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    ["script-writer"] = {
      csl = "script-writer",
      source = "csl",
    },
    scriptwriter = {
      csl = nil,
      source = "fiwi.dbx",
      type = "name",
    },
    section = {
      csl = "section",
      source = "abntex2-alf.bst",
      type = "literal",
    },
    semesters = {
      csl = nil,
      source = "biblatex-cv.dbx",
      type = "entrykey",
    },
    series = {
      csl = "collection-title",
      source = "bibtex",
      type = "literal",
    },
    ["series-creator"] = {
      csl = "series-creator",
      source = "csl",
    },
    seriesaddon = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    seriesedition = {
      csl = nil,
      source = "achicago.bst",
    },
    serieseditor = {
      csl = nil,
      source = "oxalph.dbx",
      type = "name",
    },
    seriesseries = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    setlabel = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    shelfmark = {
      csl = nil,
      source = "bath.dbx",
      type = "literal",
    },
    short = {
      csl = nil,
      source = "glsplain.bst",
    },
    shortarchive = {
      csl = nil,
      source = "jurabib.bst",
    },
    shortauthor = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    shortblog = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    shortbookauthor = {
      csl = nil,
      source = "windycity.dbx",
      type = "name",
    },
    shortbooktitle = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    shortcollection = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    shorteditor = {
      csl = nil,
      source = "biblatex",
      type = "name",
    },
    shortform = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    shorthand = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    shorthandintro = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    shortissuetitle = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    shortjournal = {
      csl = "container-title-short",
      source = "biblatex",
      type = "literal",
    },
    shortlabeltitle = {
      csl = nil,
      source = "oxalph.dbx",
      type = "literal",
    },
    shortlibrary = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    shortmaintitle = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    shortorganization = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    shortserie = {
      csl = nil,
      source = "lncs.dbx",
      type = "literal",
    },
    shortseries = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    shortsubarchive = {
      csl = nil,
      source = "jurabib.bst",
    },
    shortsubseries = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    shortsubsubseries = {
      csl = nil,
      source = "subseries.dbx",
      type = "literal",
    },
    shorttitle = {
      csl = "title-short",
      source = "biblatex",
      type = "literal",
    },
    shorttranslator = {
      csl = nil,
      source = "windycity.dbx",
      type = "name",
    },
    shorturl = {
      csl = nil,
      source = "quantum.bst",
    },
    sig1 = {
      csl = nil,
      source = "jurabib.bst",
    },
    sig2 = {
      csl = nil,
      source = "jurabib.bst",
    },
    sig3 = {
      csl = nil,
      source = "jurabib.bst",
    },
    sig4 = {
      csl = nil,
      source = "jurabib.bst",
    },
    sign = {
      alias = "userb",
      csl = nil,
      source = "biblatex-juradiss.dbx",
      type = "literal",
    },
    size = {
      csl = nil,
      source = "bookdb.bst",
    },
    slaccitation = {
      csl = nil,
      source = "apsrev4-2.bst",
    },
    smfprice = {
      csl = nil,
      source = "gzt.dbx",
      type = "literal",
    },
    ["sort-short"] = {
      csl = nil,
      source = "glsplain.bst",
    },
    ["sort-word"] = {
      csl = nil,
      source = "glsplain.bst",
    },
    sortas = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    sortkey = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    sortname = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "name",
    },
    sortshelfmark = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    sortshorthand = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    sorttitle = {
      csl = nil,
      notes = "Not supported.",
      source = "biblatex",
      type = "literal",
    },
    sortvolume = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    sortyear = {
      csl = nil,
      source = "biblatex",
      type = "integer",
    },
    source = {
      csl = "source",
      source = "figbib.bst",
      type = "literal",
    },
    source1 = {
      csl = nil,
      source = "figbib1.bst",
    },
    specdata = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    speciality = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    specialitycode = {
      csl = nil,
      source = "gost2003.bst",
      type = "literal",
    },
    ssedition = {
      csl = nil,
      source = "jox.bst",
    },
    standard = {
      csl = nil,
      source = "udesoftec.bst",
    },
    startnumber = {
      csl = nil,
      source = "seuthesis.bst",
    },
    startvolume = {
      csl = nil,
      source = "seuthesis.bst",
    },
    startyear = {
      csl = nil,
      source = "seuthesis.bst",
    },
    state = {
      csl = nil,
      source = "address-html.bst",
    },
    status = {
      csl = "status",
      source = "amsra.bst",
      type = "key",
    },
    stdcode = {
      csl = "number",
      source = "seuthesix.bst",
    },
    stitle = {
      csl = nil,
      source = "jox.bst",
    },
    street = {
      csl = nil,
      source = "adrbirthday.bst",
    },
    subarchive = {
      csl = nil,
      source = "jurabib.bst",
    },
    submitted = {
      csl = "submitted",
      source = "csl",
    },
    subnumber = {
      csl = nil,
      source = "aefkw.dbx",
      type = "integer",
    },
    subseries = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    subsubnumber = {
      csl = nil,
      source = "subseries.dbx",
      type = "literal",
    },
    subsubseries = {
      csl = nil,
      source = "subseries.dbx",
      type = "literal",
    },
    subtitle = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    summarytitle = {
      csl = nil,
      source = "aefkw.dbx",
      type = "literal",
    },
    supervisor = {
      csl = nil,
      source = "iso-alphabetic.dbx",
      type = "name",
    },
    supplement = {
      csl = "supplement",
      source = "csl",
    },
    supplemental = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    supplementala = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    supplementalb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    support = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    swhid = {
      csl = nil,
      source = "software.dbx",
      type = "verbatim",
    },
    swhidcore = {
      csl = nil,
      source = "software.dbx",
      type = "verbatim",
    },
    symposium = {
      csl = nil,
      source = "apacite.bst",
    },
    systemreq = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    texdoc = {
      csl = nil,
      source = "my_biblatex_data_model.dbx",
      type = "literal",
    },
    text = {
      csl = nil,
      source = "apacite.bst",
    },
    thesisdate = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "date",
    },
    thesistype = {
      csl = nil,
      source = "arthistory-bonn.dbx",
      type = "verbatim",
    },
    thumbnail = {
      csl = nil,
      source = "gzt.dbx",
      type = "verbatim",
    },
    timestamp = {
      csl = nil,
      source = "export.bst",
    },
    title = {
      csl = "title",
      source = "bibtex",
      type = "literal",
    },
    ["title-short"] = {
      csl = "title-short",
      source = "csl",
    },
    titlea = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    titleaddon = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    titleb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    titleisdescription = {
      csl = nil,
      source = "apa6.dbx",
      type = "literal",
    },
    titlekey = {
      csl = nil,
      source = "windycity.dbx",
      type = "key",
    },
    titlenote = {
      csl = nil,
      source = "aomalpha.bst",
      type = "literal",
    },
    titletype = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    totalpages = {
      csl = nil,
      source = "aomalpha.bst",
    },
    transissue = {
      csl = nil,
      source = "iopart-num.bst",
    },
    transjournal = {
      csl = nil,
      source = "iopart-num.bst",
    },
    translateyear = {
      csl = nil,
      source = "iran-unsrt.bst",
    },
    translation = {
      csl = nil,
      source = "apsrev4-2.bst",
    },
    translator = {
      csl = "translator",
      source = "biblatex",
      type = "name",
    },
    translatora = {
      csl = nil,
      source = "windycity.dbx",
      type = "name",
    },
    translatoratype = {
      csl = nil,
      source = "windycity.dbx",
      type = "key",
    },
    translatorb = {
      csl = nil,
      source = "windycity.dbx",
      type = "name",
    },
    translatorbtype = {
      csl = nil,
      source = "windycity.dbx",
      type = "key",
    },
    translatortype = {
      csl = nil,
      source = "windycity.dbx",
      type = "key",
    },
    transnumber = {
      csl = nil,
      source = "iopart-num.bst",
    },
    transpages = {
      csl = nil,
      source = "iopart-num.bst",
    },
    transsection = {
      csl = nil,
      source = "iopart-num.bst",
    },
    transvolume = {
      csl = nil,
      source = "iopart-num.bst",
    },
    transyear = {
      csl = nil,
      source = "iopart-num.bst",
    },
    type = {
      csl = "genre",
      source = "bibtex",
      type = "key",
    },
    typeaddon = {
      csl = nil,
      source = "windycity.dbx",
      type = "literal",
    },
    typeoflit = {
      csl = nil,
      source = "seuthesis.bst",
    },
    umfnumber = {
      csl = nil,
      source = "thesnumb.bst",
    },
    update = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "date",
    },
    updated = {
      csl = nil,
      source = "vancouver.bst",
    },
    url = {
      csl = "URL",
      source = "biblatex",
      type = "uri",
    },
    urlaccessdate = {
      csl = "accessed",
      source = "abntex2-alf.bst",
    },
    urldate = {
      csl = "accessed",
      source = "biblatex",
      type = "date",
    },
    urldescription = {
      csl = nil,
      source = "apa6.dbx",
      type = "literal",
    },
    urlnewline = {
      csl = nil,
      source = "tugboat.bst",
    },
    urls = {
      csl = nil,
      source = "acmdatamodel.dbx",
      type = "uri",
    },
    urltype = {
      csl = nil,
      source = "asmeconf.bst",
    },
    urlyear = {
      csl = "accessed",
      source = "bath.bst",
    },
    urn = {
      csl = nil,
      source = "export.bst",
      type = "verbatim",
    },
    usera = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    userb = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    userc = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    userd = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    usere = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    userf = {
      csl = nil,
      source = "biblatex",
      type = "literal",
    },
    usualtitle = {
      csl = nil,
      source = "manuscripts-shared.dbx",
      type = "literal",
    },
    value = {
      csl = nil,
      source = "bookdb.bst",
    },
    venue = {
      csl = "event-place",
      source = "biblatex",
      type = "literal",
    },
    verba = {
      csl = nil,
      source = "biblatex",
      type = "verbatim",
    },
    verbb = {
      csl = nil,
      source = "biblatex",
      type = "verbatim",
    },
    verbc = {
      csl = nil,
      source = "biblatex",
      type = "verbatim",
    },
    version = {
      csl = "version",
      source = "biblatex",
      type = "literal",
    },
    versiona = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    versionb = {
      csl = nil,
      source = "mla.dbx",
      type = "literal",
    },
    versiontype = {
      csl = nil,
      source = "asmeconf.bst",
    },
    volformat = {
      csl = nil,
      source = "jox.bst",
    },
    volsorder = {
      csl = nil,
      source = "biblatex-gost.dbx",
      type = "literal",
    },
    volume = {
      csl = "volume",
      source = "bibtex",
      type = "integer",
    },
    ["volume-title"] = {
      csl = "volume-title",
      source = "csl",
    },
    ["volume-title-short"] = {
      csl = "volume-title-short",
      source = "csl",
    },
    volumes = {
      csl = "number-of-volumes",
      source = "biblatex",
      type = "integer",
    },
    volumetitle = {
      csl = "volume-title",
      source = "iopart-num.bst",
    },
    with = {
      csl = nil,
      source = "apa.dbx",
      type = "name",
    },
    withauthor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withauthortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    withbookauthor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withbookauthortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    withbookeditor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withbookeditortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    withbooktranslator = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withbooktranslatortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    witheditor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    witheditortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    withmainauthor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withmainauthortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    withmaineditor = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withmaineditortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    withmaintranslator = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withmaintranslatortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    withtranslator = {
      csl = nil,
      source = "sbl.dbx",
      type = "name",
    },
    withtranslatortype = {
      csl = nil,
      source = "sbl.dbx",
      type = "literal",
    },
    word = {
      csl = nil,
      source = "vancouver.bst",
    },
    writer = {
      csl = nil,
      source = "apa6.dbx",
      type = "name",
    },
    xdata = {
      csl = nil,
      notes = "inherits fields from other items.",
      source = "biblatex",
      type = "entrykey",
    },
    xid = {
      csl = nil,
      source = "amsra.bst",
    },
    xref = {
      csl = nil,
      notes = "Establishes a parent-child relationship in biblatex, but without inheriting data => no need to parse this.",
      source = "biblatex",
      type = "entrykey",
    },
    year = {
      csl = "issued",
      notes = "Used only when `date` is empty.",
      source = "bibtex",
      type = "date",
    },
    ["year-presented"] = {
      csl = nil,
      source = "abntex2-alf.bst",
    },
    yearcomp = {
      csl = nil,
      source = "achicago.bst",
    },
    yearfiled = {
      csl = nil,
      source = "IEEEtran.bst",
    },
    zblnumber = {
      csl = nil,
      source = "aomalpha.bst",
    },
    zenon = {
      csl = nil,
      source = "archaeologie.dbx",
      type = "verbatim",
    },
    zip = {
      csl = nil,
      source = "adrbirthday.bst",
    },
  },
  macros = {
    acmcs = {
      source = "bibtex",
      value = "ACM Computing Surveys",
    },
    acta = {
      source = "bibtex",
      value = "Acta Informatica",
    },
    apr = {
      source = "bibtex",
      value = "April",
    },
    aug = {
      source = "bibtex",
      value = "August",
    },
    cacm = {
      source = "bibtex",
      value = "Communications of the ACM",
    },
    dec = {
      source = "bibtex",
      value = "December",
    },
    feb = {
      source = "bibtex",
      value = "February",
    },
    ibmjrd = {
      source = "bibtex",
      value = "IBM Journal of Research and Development",
    },
    ibmsj = {
      source = "bibtex",
      value = "IBM Systems Journal",
    },
    ieeese = {
      source = "bibtex",
      value = "IEEE Transactions on Software Engineering",
    },
    ieeetc = {
      source = "bibtex",
      value = "IEEE Transactions on Computers",
    },
    ieeetcad = {
      source = "bibtex",
      value = "IEEE Transactions on Computer-Aided Design of Integrated Circuits",
    },
    ipl = {
      source = "bibtex",
      value = "Information Processing Letters",
    },
    jacm = {
      source = "bibtex",
      value = "Journal of the ACM",
    },
    jan = {
      source = "bibtex",
      value = "January",
    },
    jcss = {
      source = "bibtex",
      value = "Journal of Computer and System Sciences",
    },
    jul = {
      source = "bibtex",
      value = "July",
    },
    jun = {
      source = "bibtex",
      value = "June",
    },
    mar = {
      source = "bibtex",
      value = "March",
    },
    may = {
      source = "bibtex",
      value = "May",
    },
    nov = {
      source = "bibtex",
      value = "November",
    },
    oct = {
      source = "bibtex",
      value = "October",
    },
    scp = {
      source = "bibtex",
      value = "Science of Computer Programming",
    },
    sep = {
      source = "bibtex",
      value = "September",
    },
    sicomp = {
      source = "bibtex",
      value = "SIAM Journal on Computing",
    },
    tcs = {
      source = "bibtex",
      value = "Theoretical Computer Science",
    },
    tocs = {
      source = "bibtex",
      value = "ACM Transactions on Computer Systems",
    },
    tods = {
      source = "bibtex",
      value = "ACM Transactions on Database Systems",
    },
    tog = {
      source = "bibtex",
      value = "ACM Transactions on Graphics",
    },
    toms = {
      source = "bibtex",
      value = "ACM Transactions on Mathematical Software",
    },
    toois = {
      source = "bibtex",
      value = "ACM Transactions on Office Information Systems",
    },
    toplas = {
      source = "bibtex",
      value = "ACM Transactions on Programming Languages and Systems",
    },
  },
  language_code_map = {
    UKenglish = "en-GB",
    USenglish = "en-US",
    acadian = "fr-CA",
    afrikaans = "af-ZA",
    albanian = "sq-AL",
    american = "en-US",
    amharic = "am-ET",
    arabic = "ar",
    armenian = "hy-AM",
    australian = "en-AU",
    austrian = "de-AT",
    bahasa = "id-ID",
    bahasai = "id-ID",
    bahasam = "id-ID",
    basque = "eu-ES",
    bengali = "bn-BD",
    bgreek = "el-GR",
    brazil = "pt-BR",
    brazilian = "pt-BR",
    breton = "br-FR",
    british = "en-GB",
    bulgarian = "bg-BG",
    canadian = "en-CA",
    canadien = "fr-CA",
    catalan = "ca-AD",
    chinese = "zh",
    croatian = "hr-HR",
    czech = "cs-CZ",
    danish = "da-DK",
    divehi = "dv-MV",
    dutch = "nl-NL",
    english = "en-US",
    esperanto = "eo",
    estonian = "et-EE",
    ethiopia = "am-ET",
    farsi = "fa-IR",
    finnish = "fi-FI",
    francais = "fr-FR",
    french = "fr-FR",
    frenchle = "fr-FR",
    galician = "gl-ES",
    german = "de-DE",
    germanb = "de-DE",
    greek = "el-GR",
    hebrew = "he-IL",
    hindi = "hi-IN",
    ibygreek = "el-CY",
    icelandic = "is-IS",
    indon = "id-ID",
    indonesia = "id-ID",
    interlingua = "ia-FR",
    irish = "ga-IE",
    italian = "it-IT",
    japanese = "ja-JP",
    kannada = "kn-IN",
    lao = "lo-LA",
    latin = "la",
    latvian = "lv-LV",
    lithuanian = "lt-LT",
    magyar = "hu-HU",
    malay = "id-ID",
    malayalam = "ml-IN",
    marathi = "mr-IN",
    meyalu = "id-ID",
    mongolian = "mn",
    naustrian = "de-AT",
    newzealand = "en-NZ",
    ngerman = "de-DE",
    nko = "ha-NG",
    norsk = "nb-NO",
    norwegian = "nn-NO",
    nswissgerman = "de-CH",
    nynorsk = "nn-NO",
    occitan = "oc-FR",
    polish = "pl-PL",
    polutonikogreek = "el-GR",
    portuges = "pt-PT",
    portuguese = "pt-PT",
    romanian = "ro-RO",
    romansh = "rm-CH",
    russian = "ru-RU",
    samin = "se-NO",
    sanskrit = "sa-IN",
    scottish = "gd-GB",
    serbian = "sr",
    slovak = "sk-SK",
    slovene = "sl-SI",
    slovenian = "sl-SI",
    spanish = "es-ES",
    swedish = "sv-SE",
    swiss = "de-CH",
    swissgerman = "de-CH",
    tamil = "ta-IN",
    telugu = "te-IN",
    thai = "th-TH",
    thaicjk = "th-TH",
    tibetan = "bo-CN",
    turkish = "tr-TR",
    turkmen = "tk-TM",
    ukrainian = "uk-UA",
    urdu = "ur-IN",
    vietnamese = "vi-VN",
    welsh = "cy-GB",
  },
  months = {
    apr = "4",
    april = "4",
    aug = "8",
    august = "8",
    dec = "12",
    december = "12",
    feb = "2",
    february = "2",
    jan = "1",
    january = "1",
    jul = "7",
    july = "7",
    jun = "6",
    june = "6",
    mar = "3",
    march = "3",
    may = "5",
    nov = "11",
    november = "11",
    oct = "10",
    october = "10",
    sep = "9",
    september = "9",
  },
  primary_fields = {
    annotation = "note",
    ["archive-place"] = "archive-place",
    author = "author",
    bookauthor = "container-author",
    chapter = "chapter-number",
    date = "issued",
    director = "director",
    editor = "editor",
    eid = "number",
    eprinttype = "archive",
    eventdate = "event-date",
    eventtitle = "event-title",
    ["executive-producer"] = "executive-producer",
    journaltitle = "container-title",
    jurisdiction = "jurisdiction",
    langid = "language",
    location = "publisher-place",
    medium = "medium",
    number = "number",
    origdate = "original-date",
    origlocation = "original-publisher-place",
    origpublisher = "original-publisher",
    origtitle = "original-title",
    pages = "page",
    pagetotal = "number-of-pages",
    performer = "performer",
    pmid = "PMID",
    publisher = "publisher",
    pubstate = "status",
    series = "collection-title",
    shortjournal = "container-title-short",
    shorttitle = "title-short",
    title = "title",
    translator = "translator",
    type = "genre",
    urldate = "accessed",
    venue = "event-place",
    version = "version",
    ["volume-title"] = "volume-title",
    volumes = "number-of-volumes",
  },
}
