//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `FileInfo.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IcePatch2_FileInfo_h__
#define __IcePatch2_FileInfo_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>
#include <IcePatch2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEPATCH2_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEPATCH2_API /**/
#   elif defined(ICEPATCH2_API_EXPORTS)
#       define ICEPATCH2_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEPATCH2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IcePatch2
{

/**
 * Basic information about a single file.
 * \headerfile IcePatch2/IcePatch2.h
 */
struct FileInfo
{
    /**
     * The pathname.
     */
    ::std::string path;
    /**
     * The SHA-1 checksum of the file.
     */
    ::Ice::ByteSeq checksum;
    /**
     * The size of the compressed file in number of bytes.
     */
    int size;
    /**
     * The executable flag.
     */
    bool executable;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::Ice::ByteSeq&, const int&, const bool&> ice_tuple() const
    {
        return std::tie(path, checksum, size, executable);
    }
};

/**
 * A sequence with information about many files.
 */
using FileInfoSeq = ::std::vector<FileInfo>;

/**
 * Basic information about a single file.
 * \headerfile IcePatch2/IcePatch2.h
 */
struct LargeFileInfo
{
    /**
     * The pathname.
     */
    ::std::string path;
    /**
     * The SHA-1 checksum of the file.
     */
    ::Ice::ByteSeq checksum;
    /**
     * The size of the compressed file in number of bytes.
     */
    long long int size;
    /**
     * The executable flag.
     */
    bool executable;

    /**
     * Obtains a tuple containing all of the struct's data members.
     * @return The data members in a tuple.
     */
    std::tuple<const ::std::string&, const ::Ice::ByteSeq&, const long long int&, const bool&> ice_tuple() const
    {
        return std::tie(path, checksum, size, executable);
    }
};

/**
 * A sequence with information about many files.
 */
using LargeFileInfoSeq = ::std::vector<LargeFileInfo>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits<::IcePatch2::FileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IcePatch2::FileInfo, S>
{
    static void read(S* istr, ::IcePatch2::FileInfo& v)
    {
        istr->readAll(v.path, v.checksum, v.size, v.executable);
    }
};

template<>
struct StreamableTraits<::IcePatch2::LargeFileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IcePatch2::LargeFileInfo, S>
{
    static void read(S* istr, ::IcePatch2::LargeFileInfo& v)
    {
        istr->readAll(v.path, v.checksum, v.size, v.executable);
    }
};

}
/// \endcond

#else // C++98 mapping

namespace IcePatch2
{

/**
 * Basic information about a single file.
 * \headerfile IcePatch2/IcePatch2.h
 */
struct FileInfo
{
    /**
     * The pathname.
     */
    ::std::string path;
    /**
     * The SHA-1 checksum of the file.
     */
    ::Ice::ByteSeq checksum;
    /**
     * The size of the compressed file in number of bytes.
     */
    ::Ice::Int size;
    /**
     * The executable flag.
     */
    bool executable;
};

/**
 * A sequence with information about many files.
 */
typedef ::std::vector<FileInfo> FileInfoSeq;

/**
 * Basic information about a single file.
 * \headerfile IcePatch2/IcePatch2.h
 */
struct LargeFileInfo
{
    /**
     * The pathname.
     */
    ::std::string path;
    /**
     * The SHA-1 checksum of the file.
     */
    ::Ice::ByteSeq checksum;
    /**
     * The size of the compressed file in number of bytes.
     */
    ::Ice::Long size;
    /**
     * The executable flag.
     */
    bool executable;
};

/**
 * A sequence with information about many files.
 */
typedef ::std::vector<LargeFileInfo> LargeFileInfoSeq;

}

/// \cond STREAM
namespace Ice
{

template<>
struct StreamableTraits< ::IcePatch2::FileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 7;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IcePatch2::FileInfo, S>
{
    static void write(S* ostr, const ::IcePatch2::FileInfo& v)
    {
        ostr->write(v.path);
        ostr->write(v.checksum);
        ostr->write(v.size);
        ostr->write(v.executable);
    }
};

template<typename S>
struct StreamReader< ::IcePatch2::FileInfo, S>
{
    static void read(S* istr, ::IcePatch2::FileInfo& v)
    {
        istr->read(v.path);
        istr->read(v.checksum);
        istr->read(v.size);
        istr->read(v.executable);
    }
};

template<>
struct StreamableTraits< ::IcePatch2::LargeFileInfo>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 11;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IcePatch2::LargeFileInfo, S>
{
    static void write(S* ostr, const ::IcePatch2::LargeFileInfo& v)
    {
        ostr->write(v.path);
        ostr->write(v.checksum);
        ostr->write(v.size);
        ostr->write(v.executable);
    }
};

template<typename S>
struct StreamReader< ::IcePatch2::LargeFileInfo, S>
{
    static void read(S* istr, ::IcePatch2::LargeFileInfo& v)
    {
        istr->read(v.path);
        istr->read(v.checksum);
        istr->read(v.size);
        istr->read(v.executable);
    }
};

}
/// \endcond

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
