﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mailmanager/MailManager_EXPORTS.h>
#include <aws/mailmanager/model/AddressList.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MailManager {
namespace Model {
class ListAddressListsResult {
 public:
  AWS_MAILMANAGER_API ListAddressListsResult() = default;
  AWS_MAILMANAGER_API ListAddressListsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MAILMANAGER_API ListAddressListsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of address lists.</p>
   */
  inline const Aws::Vector<AddressList>& GetAddressLists() const { return m_addressLists; }
  template <typename AddressListsT = Aws::Vector<AddressList>>
  void SetAddressLists(AddressListsT&& value) {
    m_addressListsHasBeenSet = true;
    m_addressLists = std::forward<AddressListsT>(value);
  }
  template <typename AddressListsT = Aws::Vector<AddressList>>
  ListAddressListsResult& WithAddressLists(AddressListsT&& value) {
    SetAddressLists(std::forward<AddressListsT>(value));
    return *this;
  }
  template <typename AddressListsT = AddressList>
  ListAddressListsResult& AddAddressLists(AddressListsT&& value) {
    m_addressListsHasBeenSet = true;
    m_addressLists.emplace_back(std::forward<AddressListsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If NextToken is returned, there are more results available. The value of
   * NextToken is a unique pagination token for each page. Make the call again using
   * the returned token to retrieve the next page.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAddressListsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListAddressListsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<AddressList> m_addressLists;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_addressListsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
