﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agentcore/BedrockAgentCore_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentCore {
namespace Model {

/**
 * <p> The token consumption statistics for language model operations during
 * evaluation. Provides detailed breakdown of input, output, and total tokens used
 * for cost tracking and performance monitoring. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agentcore-2024-02-28/TokenUsage">AWS
 * API Reference</a></p>
 */
class TokenUsage {
 public:
  AWS_BEDROCKAGENTCORE_API TokenUsage() = default;
  AWS_BEDROCKAGENTCORE_API TokenUsage(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTCORE_API TokenUsage& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTCORE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p> The number of tokens consumed for input processing during the evaluation.
   * Includes tokens from the evaluation prompt, agent traces, and any additional
   * context provided to the evaluator model. </p>
   */
  inline int GetInputTokens() const { return m_inputTokens; }
  inline bool InputTokensHasBeenSet() const { return m_inputTokensHasBeenSet; }
  inline void SetInputTokens(int value) {
    m_inputTokensHasBeenSet = true;
    m_inputTokens = value;
  }
  inline TokenUsage& WithInputTokens(int value) {
    SetInputTokens(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The number of tokens generated by the evaluator model in its response.
   * Includes tokens for the score, explanation, and any additional output produced
   * during the evaluation process. </p>
   */
  inline int GetOutputTokens() const { return m_outputTokens; }
  inline bool OutputTokensHasBeenSet() const { return m_outputTokensHasBeenSet; }
  inline void SetOutputTokens(int value) {
    m_outputTokensHasBeenSet = true;
    m_outputTokens = value;
  }
  inline TokenUsage& WithOutputTokens(int value) {
    SetOutputTokens(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The total number of tokens consumed during the evaluation, calculated as the
   * sum of input and output tokens. Used for cost calculation and rate limiting
   * within the service limits. </p>
   */
  inline int GetTotalTokens() const { return m_totalTokens; }
  inline bool TotalTokensHasBeenSet() const { return m_totalTokensHasBeenSet; }
  inline void SetTotalTokens(int value) {
    m_totalTokensHasBeenSet = true;
    m_totalTokens = value;
  }
  inline TokenUsage& WithTotalTokens(int value) {
    SetTotalTokens(value);
    return *this;
  }
  ///@}
 private:
  int m_inputTokens{0};

  int m_outputTokens{0};

  int m_totalTokens{0};
  bool m_inputTokensHasBeenSet = false;
  bool m_outputTokensHasBeenSet = false;
  bool m_totalTokensHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentCore
}  // namespace Aws
