﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/fms/FMS_EXPORTS.h>
#include <aws/fms/model/ActionTarget.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace FMS {
namespace Model {

/**
 * <p>Information about the <code>CreateNetworkAcl</code> action in Amazon EC2.
 * This is a remediation option in <code>RemediationAction</code>.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/fms-2018-01-01/CreateNetworkAclAction">AWS
 * API Reference</a></p>
 */
class CreateNetworkAclAction {
 public:
  AWS_FMS_API CreateNetworkAclAction() = default;
  AWS_FMS_API CreateNetworkAclAction(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API CreateNetworkAclAction& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_FMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Brief description of this remediation action. </p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateNetworkAclAction& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The VPC that's associated with the remediation action.</p>
   */
  inline const ActionTarget& GetVpc() const { return m_vpc; }
  inline bool VpcHasBeenSet() const { return m_vpcHasBeenSet; }
  template <typename VpcT = ActionTarget>
  void SetVpc(VpcT&& value) {
    m_vpcHasBeenSet = true;
    m_vpc = std::forward<VpcT>(value);
  }
  template <typename VpcT = ActionTarget>
  CreateNetworkAclAction& WithVpc(VpcT&& value) {
    SetVpc(std::forward<VpcT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates whether it is possible for Firewall Manager to perform this
   * remediation action. A false value indicates that auto remediation is disabled or
   * Firewall Manager is unable to perform the action due to a conflict of some
   * kind.</p>
   */
  inline bool GetFMSCanRemediate() const { return m_fMSCanRemediate; }
  inline bool FMSCanRemediateHasBeenSet() const { return m_fMSCanRemediateHasBeenSet; }
  inline void SetFMSCanRemediate(bool value) {
    m_fMSCanRemediateHasBeenSet = true;
    m_fMSCanRemediate = value;
  }
  inline CreateNetworkAclAction& WithFMSCanRemediate(bool value) {
    SetFMSCanRemediate(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_description;

  ActionTarget m_vpc;

  bool m_fMSCanRemediate{false};
  bool m_descriptionHasBeenSet = false;
  bool m_vpcHasBeenSet = false;
  bool m_fMSCanRemediateHasBeenSet = false;
};

}  // namespace Model
}  // namespace FMS
}  // namespace Aws
