/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi.clients;

import java.io.InterruptedIOException;
import java.util.concurrent.TimeoutException;
import org.a11y.brlapi.Client;
import org.a11y.brlapi.CommandKeycode;
import org.a11y.brlapi.Connection;
import org.a11y.brlapi.DriverKeycode;
import org.a11y.brlapi.Keycode;
import org.a11y.brlapi.OperandUsage;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.ProgramException;
import org.a11y.brlapi.Strings;
import org.a11y.brlapi.SyntaxException;

public class EchoClient
extends Client {
    private boolean echoDriverKeys = false;
    private boolean echoNames = false;
    public static final int MINIMUM_READ_COUNT = 1;
    public static final int DEFAULT_READ_COUNT = 10;
    public static final String NO_TIMEOUT = "none";
    public static final int FOREVER_READ_TIMEOUT = 0;
    public static final int MINIMUM_READ_TIMEOUT = 1;
    public static final int DEFAULT_READ_TIMEOUT = 10;
    private int readCount = 10;
    private final OperandUsage readCountUsage = new OperandUsage("read count").setDefault(this.readCount).setRangeMinimum(1);
    private int readTimeout = 10;
    private final OperandUsage readTimeoutUsage = new OperandUsage("read timeout").setDefault(this.readTimeout).setRangeMinimum(1).setRangeUnits("seconds").setRangeComment("readKeyWithTimeout is used").addWord("none", 0, "readKey is used");
    private int[] ttyPath = null;

    public EchoClient(String ... stringArray2) {
        super(stringArray2);
        this.addRepeatingParameter("tty");
        this.addOption("commands", stringArray -> {
            this.echoDriverKeys = false;
        }, new String[0]);
        this.addOption("keys", stringArray -> {
            this.echoDriverKeys = true;
        }, new String[0]);
        this.addOption("values", stringArray -> {
            this.echoNames = false;
        }, new String[0]);
        this.addOption("names", stringArray -> {
            this.echoNames = true;
        }, new String[0]);
        this.addOption("reads", stringArray -> {
            this.readCount = Parse.asInt(this.readCountUsage.getOperandDescription(), stringArray[0], 1);
        }, "count");
        this.addOption("timeout", stringArray -> {
            String string = stringArray[0];
            this.readTimeout = Strings.isAbbreviation(NO_TIMEOUT, string) ? 0 : Parse.asInt(this.readTimeoutUsage.getOperandDescription(), string, 1);
        }, "seconds");
    }

    @Override
    protected final void extendUsageSummary(StringBuilder stringBuilder) {
        super.extendUsageSummary(stringBuilder);
        this.readCountUsage.appendTo(stringBuilder);
        this.readTimeoutUsage.appendTo(stringBuilder);
    }

    @Override
    protected void processParameters(String[] stringArray) throws SyntaxException {
        int n = stringArray.length;
        this.ttyPath = new int[n];
        for (int i = 0; i < n; ++i) {
            this.ttyPath[i] = Parse.asInt("tty path component", stringArray[i]);
        }
    }

    private final void show(Connection connection, String string) {
        EchoClient.printf("%s\n", string);
        connection.write(string, 0);
    }

    private final String toString(Connection connection, long l) {
        String[] stringArray;
        int n;
        if (this.echoDriverKeys) {
            String string;
            DriverKeycode driverKeycode = new DriverKeycode(l);
            Object object = driverKeycode.toString();
            if (this.echoNames && (string = connection.getParameters().driverKeycodeName.get(driverKeycode.getValue())) != null && !string.isEmpty()) {
                object = (String)object + " Name:" + string;
            }
            return object;
        }
        CommandKeycode commandKeycode = new CommandKeycode(l);
        if (!this.echoNames) {
            return commandKeycode.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Keycode.toString(l));
        String string = commandKeycode.getTypeName();
        if (string != null) {
            stringBuilder.append(" Type:").append(string);
        }
        if ((string = commandKeycode.getCommandName()) != null) {
            stringBuilder.append(" Cmd:").append(string);
        }
        if ((n = commandKeycode.getArgument()) > 0) {
            stringBuilder.append(String.format(" Arg:%04X(%d)", n, n));
        }
        if ((stringArray = commandKeycode.getFlagNames()) != null) {
            int n2 = stringArray.length;
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.isEmpty()) continue;
                if (bl) {
                    bl = false;
                    stringBuilder.append(" Flg:");
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected final void runClient(Connection connection2) throws ProgramException {
        this.ttyMode(connection2, this.echoDriverKeys, (Connection connection) -> {
            this.show(connection, String.format("press keys (timeout is %d seconds)", this.readTimeout));
            while (this.readCount-- > 0) {
                long l;
                try {
                    l = this.readTimeout == 0 ? connection.readKey() : connection.readKeyWithTimeout(this.readTimeout * 1000);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (TimeoutException timeoutException) {
                    break;
                }
                this.show(connection, this.toString(connection, l));
            }
        }, this.ttyPath);
    }
}

