/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.PropertyMaps;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class PropertyMapImpl
implements PropertyMap {
    private static final Map<String, PropDef> DEFAULT_TYPES = new HashMap<String, PropDef>();
    private final String _mapName;
    private final short _mapType;
    private final Map<String, PropertyMap.Property> _props = new LinkedHashMap<String, PropertyMap.Property>();
    private final PropertyMaps _owner;

    public PropertyMapImpl(String name, short type, PropertyMaps owner) {
        this._mapName = name;
        this._mapType = type;
        this._owner = owner;
    }

    @Override
    public String getName() {
        return this._mapName;
    }

    public short getType() {
        return this._mapType;
    }

    public PropertyMaps getOwner() {
        return this._owner;
    }

    @Override
    public int getSize() {
        return this._props.size();
    }

    @Override
    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    @Override
    public PropertyMap.Property get(String name) {
        return this._props.get(DatabaseImpl.toLookupName(name));
    }

    @Override
    public Object getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public Object getValue(String name, Object defaultValue) {
        PropertyMap.Property prop = this.get(name);
        Object value = defaultValue;
        if (prop != null && prop.getValue() != null) {
            value = prop.getValue();
        }
        return value;
    }

    @Override
    public PropertyImpl put(String name, Object value) {
        return this.put(name, null, value, false);
    }

    @Override
    public PropertyImpl put(String name, DataType type, Object value) {
        return this.put(name, type, value, false);
    }

    @Override
    public void putAll(Iterable<? extends PropertyMap.Property> props) {
        if (props == null) {
            return;
        }
        for (PropertyMap.Property property : props) {
            this.put(property);
        }
    }

    public PropertyImpl put(PropertyMap.Property prop) {
        return this.put(prop.getName(), prop.getType(), prop.getValue(), prop.isDdl());
    }

    @Override
    public PropertyImpl put(String name, DataType type, Object value, boolean isDdl) {
        PropertyImpl prop = (PropertyImpl)PropertyMapImpl.createProperty(name, type, value, isDdl);
        this._props.put(DatabaseImpl.toLookupName(name), prop);
        return prop;
    }

    @Override
    public PropertyImpl remove(String name) {
        return (PropertyImpl)this._props.remove(DatabaseImpl.toLookupName(name));
    }

    @Override
    public Iterator<PropertyMap.Property> iterator() {
        return this._props.values().iterator();
    }

    @Override
    public void save() throws IOException {
        this.getOwner().save();
    }

    public String toString() {
        return PropertyMapImpl.toString(this);
    }

    public static String toString(PropertyMap map) {
        StringBuilder sb = new StringBuilder();
        sb.append("".equals(map.getName()) ? "<DEFAULT>" : map.getName()).append(" {");
        Iterator iter = map.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static PropertyMap.Property createProperty(String name, DataType type, Object value) {
        return PropertyMapImpl.createProperty(name, type, value, false);
    }

    public static PropertyMap.Property createProperty(String name, DataType type, Object value, boolean isDdl) {
        PropDef pd = DEFAULT_TYPES.get(name);
        if (value instanceof PropertyMap.EnumValue) {
            value = ((PropertyMap.EnumValue)value).getValue();
        }
        if (pd != null) {
            type = type == null ? pd._type : type;
            isDdl |= pd._isDdl;
        } else if (type == null) {
            if (value instanceof String) {
                type = DataType.TEXT;
            } else if (value instanceof Boolean) {
                type = DataType.BOOLEAN;
            } else if (value instanceof Byte) {
                type = DataType.BYTE;
            } else if (value instanceof Short) {
                type = DataType.INT;
            } else if (value instanceof Integer) {
                type = DataType.LONG;
            } else if (value instanceof Float) {
                type = DataType.FLOAT;
            } else if (value instanceof Double) {
                type = DataType.DOUBLE;
            } else if (value instanceof Date || value instanceof LocalDateTime) {
                type = DataType.SHORT_DATE_TIME;
            } else if (value instanceof byte[]) {
                type = DataType.OLE;
            } else if (value instanceof Long) {
                type = DataType.BIG_INT;
            } else {
                throw new IllegalArgumentException("Could not determine type for property " + name + " with value " + value);
            }
        }
        return new PropertyImpl(name, type, value, isDdl);
    }

    static {
        DEFAULT_TYPES.put("AccessVersion", new PropDef(DataType.TEXT, false));
        DEFAULT_TYPES.put("Title", new PropDef(DataType.TEXT, false));
        DEFAULT_TYPES.put("Author", new PropDef(DataType.TEXT, false));
        DEFAULT_TYPES.put("Company", new PropDef(DataType.TEXT, false));
        DEFAULT_TYPES.put("DefaultValue", new PropDef(DataType.MEMO, true));
        DEFAULT_TYPES.put("Required", new PropDef(DataType.BOOLEAN, true));
        DEFAULT_TYPES.put("AllowZeroLength", new PropDef(DataType.BOOLEAN, true));
        DEFAULT_TYPES.put("DecimalPlaces", new PropDef(DataType.BYTE, true));
        DEFAULT_TYPES.put("Format", new PropDef(DataType.TEXT, true));
        DEFAULT_TYPES.put("InputMask", new PropDef(DataType.TEXT, true));
        DEFAULT_TYPES.put("Caption", new PropDef(DataType.MEMO, false));
        DEFAULT_TYPES.put("ValidationRule", new PropDef(DataType.TEXT, true));
        DEFAULT_TYPES.put("ValidationText", new PropDef(DataType.TEXT, true));
        DEFAULT_TYPES.put("GUID", new PropDef(DataType.BINARY, true));
        DEFAULT_TYPES.put("Description", new PropDef(DataType.MEMO, false));
        DEFAULT_TYPES.put("ResultType", new PropDef(DataType.BYTE, true));
        DEFAULT_TYPES.put("Expression", new PropDef(DataType.MEMO, true));
        DEFAULT_TYPES.put("DisplayControl", new PropDef(DataType.INT, false));
        DEFAULT_TYPES.put("TextFormat", new PropDef(DataType.BYTE, false));
        DEFAULT_TYPES.put("IMEMode", new PropDef(DataType.BYTE, false));
        DEFAULT_TYPES.put("IMESentenceMode", new PropDef(DataType.BYTE, false));
    }

    private static final class PropDef {
        private final DataType _type;
        private final boolean _isDdl;

        private PropDef(DataType type, boolean isDdl) {
            this._type = type;
            this._isDdl = isDdl;
        }
    }

    static final class PropertyImpl
    implements PropertyMap.Property {
        private final String _name;
        private final DataType _type;
        private final boolean _ddl;
        private Object _value;

        private PropertyImpl(String name, DataType type, Object value, boolean ddl) {
            this._name = name;
            this._type = type;
            this._ddl = ddl;
            this._value = value;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public DataType getType() {
            return this._type;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public void setValue(Object newValue) {
            this._value = newValue;
        }

        @Override
        public boolean isDdl() {
            return this._ddl;
        }

        public String toString() {
            Object val = this.getValue();
            if (val instanceof byte[]) {
                val = ByteUtil.toHexString((byte[])val);
            }
            return this.getName() + "[" + (Object)((Object)this.getType()) + (this._ddl ? ":ddl" : "") + "]=" + val;
        }
    }
}

