/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.pages.database;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingAttribute;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingContainer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseMappingType;
import org.jkiss.dbeaver.tools.transfer.database.MappingNameCase;
import org.jkiss.dbeaver.tools.transfer.database.MappingReplaceMechanism;
import org.jkiss.dbeaver.tools.transfer.internal.DTActivator;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class MappingRulesDialog
extends BaseDialog {
    private static final Log log = Log.getLog(MappingRulesDialog.class);
    private final DBPDataSource dataSource;
    private final List<Object> elementList;
    private final DBPPreferenceStore dbpPreferenceStore;
    private final DBPPreferenceStore store;
    private Combo nameCaseCombo;
    private Combo replaceCombo;
    private Spinner typeLengthSpinner;
    private Button saveSettings;
    private final int originalNameCaseSelection;
    private final int originalReplaceSelection;
    private final int originalMaxTypeLength;
    private final boolean originalSaveSettingsValue;

    public MappingRulesDialog(@NotNull Shell parentShell, @NotNull DBPDataSource dataSource, @NotNull List<Object> elementList) {
        super(parentShell, DTUIMessages.mappings_rules_dialog_title, null);
        this.dataSource = dataSource;
        this.elementList = elementList;
        this.dbpPreferenceStore = dataSource.getContainer().getPreferenceStore();
        this.store = DTActivator.getDefault().getPreferences();
        this.originalNameCaseSelection = this.dbpPreferenceStore.contains("nameCaseMapping") ? this.dbpPreferenceStore.getInt("nameCaseMapping") : this.store.getInt("nameCaseMapping");
        int n = this.originalReplaceSelection = this.dbpPreferenceStore.contains("replaceMapping") ? this.dbpPreferenceStore.getInt("replaceMapping") : this.store.getInt("replaceMapping");
        this.originalMaxTypeLength = this.dbpPreferenceStore.contains("maxTypeLengthMapping") ? this.dbpPreferenceStore.getInt("maxTypeLengthMapping") : (this.store.contains("maxTypeLengthMapping") ? this.store.getInt("maxTypeLengthMapping") : this.store.getDefaultInt("maxTypeLengthMapping"));
        this.originalSaveSettingsValue = this.store.contains("saveLocalSettings") ? this.store.getBoolean("saveLocalSettings") : true;
    }

    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Composite mappingGroup = UIUtils.createTitledComposite((Composite)composite, (String)DTUIMessages.pref_data_transfer_mapping_group, (int)2, (int)768);
        Label label = UIUtils.createLabel((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_info_label_mapping);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.nameCaseCombo = UIUtils.createLabelCombo((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_name_case_label, (int)12);
        this.nameCaseCombo.setLayoutData((Object)new GridData(32));
        for (MappingNameCase mappingNameCase : MappingNameCase.values()) {
            this.nameCaseCombo.add(mappingNameCase.getName());
        }
        this.nameCaseCombo.select(this.originalNameCaseSelection);
        this.replaceCombo = UIUtils.createLabelCombo((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_replacing_combo_label, (int)12);
        this.replaceCombo.setLayoutData((Object)new GridData(32));
        for (MappingNameCase mappingNameCase : MappingReplaceMechanism.values()) {
            this.replaceCombo.add(mappingNameCase.getName());
        }
        this.replaceCombo.select(this.originalReplaceSelection);
        this.replaceCombo.setToolTipText(DTUIMessages.pref_data_transfer_replacing_combo_tip);
        UIUtils.createControlLabel((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_spanner_max_length);
        this.typeLengthSpinner = UIUtils.createSpinner((Composite)mappingGroup, (String)DTUIMessages.pref_data_transfer_spanner_max_length_tip, (int)this.originalMaxTypeLength, (int)1, (int)Integer.MAX_VALUE);
        this.saveSettings = UIUtils.createCheckbox((Composite)mappingGroup, (String)DTUIMessages.mappings_rules_dialog_save_settings_checkbox, (boolean)this.originalSaveSettingsValue);
        this.saveSettings.setToolTipText(DTUIMessages.mappings_rules_dialog_save_settings_checkbox_tip);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 2;
        this.saveSettings.setLayoutData((Object)gd2);
        UIUtils.createLink((Composite)mappingGroup, (String)DTMessages.data_transfer_wizard_output_label_global_settings, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.showPreferencesFor((Shell)MappingRulesDialog.this.getShell(), null, (String[])new String[]{"org.jkiss.dbeaver.preferences.datatransfer"});
            }
        });
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void okPressed() {
        if (this.nameCaseCombo.getSelectionIndex() != this.originalNameCaseSelection || this.replaceCombo.getSelectionIndex() != this.originalReplaceSelection || this.typeLengthSpinner.getSelection() != this.originalMaxTypeLength) {
            if (!UIUtils.confirmAction((Shell)this.getShell(), (String)DTUIMessages.mappings_rules_dialog_confirmation_title, (String)DTUIMessages.mappings_rules_dialog_confirmation_message, (DBPImage)DBIcon.STATUS_WARNING)) return;
            this.updateMappingsNames();
        } else if (this.originalSaveSettingsValue != this.saveSettings.getSelection()) {
            this.store.setValue("saveLocalSettings", this.saveSettings.getSelection());
            if (this.saveSettings.getSelection()) {
                this.store.setValue("nameCaseMapping", this.nameCaseCombo.getSelectionIndex());
                this.store.setValue("replaceMapping", this.replaceCombo.getSelectionIndex());
                this.store.setValue("maxTypeLengthMapping", this.typeLengthSpinner.getSelection());
            }
            PrefUtils.savePreferenceStore((DBPPreferenceStore)this.store);
        }
        super.okPressed();
    }

    private void updateMappingsNames() {
        boolean changeNameCase = this.nameCaseCombo != null && this.nameCaseCombo.getSelectionIndex() != this.originalNameCaseSelection;
        boolean changeReplaceMechanism = this.replaceCombo != null && this.replaceCombo.getSelectionIndex() != this.originalReplaceSelection;
        boolean changeDataTypeLength = this.typeLengthSpinner != null && this.typeLengthSpinner.getSelection() != this.originalMaxTypeLength;
        for (Object element : this.elementList) {
            DatabaseMappingContainer container;
            DatabaseMappingType mappingType;
            if (!(element instanceof DatabaseMappingContainer) || (mappingType = (container = (DatabaseMappingContainer)element).getMappingType()) == DatabaseMappingType.skip || mappingType == DatabaseMappingType.unspecified) continue;
            Collection attributeMappings = container.getAttributeMappings();
            for (DatabaseMappingAttribute mapping : attributeMappings) {
                if (mapping.getMappingType() != DatabaseMappingType.create) continue;
                DBSAttributeBase source = mapping.getSource();
                mapping.setTargetName(this.getTransformedName(source != null ? source.getName() : mapping.getTargetName(), changeNameCase));
                if (!changeDataTypeLength || !(source instanceof DBSTypedObjectExt2)) continue;
                int maxDataTypeLength = this.typeLengthSpinner.getSelection();
                if (source.getMaxLength() <= (long)maxDataTypeLength) continue;
                ((DBSTypedObjectExt2)source).setMaxLength((long)maxDataTypeLength);
            }
            if (mappingType != DatabaseMappingType.create || !changeNameCase && !changeReplaceMechanism) continue;
            container.setTargetName(this.getTransformedName(this.getOriginalTargetName(container), changeNameCase));
        }
        boolean saveToGlobalSettings = this.saveSettings.getSelection();
        if (changeNameCase) {
            if (saveToGlobalSettings) {
                this.store.setValue("nameCaseMapping", this.nameCaseCombo.getSelectionIndex());
            } else {
                this.dbpPreferenceStore.setValue("nameCaseMapping", this.nameCaseCombo.getSelectionIndex());
            }
        }
        if (changeReplaceMechanism) {
            if (saveToGlobalSettings) {
                this.store.setValue("replaceMapping", this.replaceCombo.getSelectionIndex());
            } else {
                this.dbpPreferenceStore.setValue("replaceMapping", this.replaceCombo.getSelectionIndex());
            }
        }
        if (changeDataTypeLength) {
            if (saveToGlobalSettings) {
                this.store.setValue("maxTypeLengthMapping", this.typeLengthSpinner.getSelection());
            } else {
                this.dbpPreferenceStore.setValue("maxTypeLengthMapping", this.typeLengthSpinner.getSelection());
            }
        }
        this.store.setValue("saveLocalSettings", saveToGlobalSettings);
        PrefUtils.savePreferenceStore((DBPPreferenceStore)this.store);
        if (!saveToGlobalSettings) {
            PrefUtils.savePreferenceStore((DBPPreferenceStore)this.dbpPreferenceStore);
        }
    }

    @Nullable
    private String getTransformedName(@Nullable String targetName, boolean caseChanged) {
        if (CommonUtils.isEmpty((String)targetName)) {
            return targetName;
        }
        String finalName = targetName;
        MappingNameCase nameCase = MappingNameCase.getCaseBySelectionId((int)this.nameCaseCombo.getSelectionIndex());
        if (nameCase != MappingNameCase.DEFAULT) {
            finalName = nameCase.getIdentifierCase().transform(targetName);
        } else if (caseChanged) {
            finalName = this.dataSource.getSQLDialect().storesUnquotedCase().transform(targetName);
        }
        if (CommonUtils.isNotEmpty((String)finalName) && finalName.contains(" ")) {
            String camelCaseName;
            MappingReplaceMechanism replaceMechanism = MappingReplaceMechanism.getCaseBySelectionId((int)this.replaceCombo.getSelectionIndex());
            if (MappingReplaceMechanism.UNDERSCORES == replaceMechanism) {
                finalName = finalName.replaceAll(" ", "_");
            } else if (MappingReplaceMechanism.CAMELCASE == replaceMechanism && (nameCase != MappingNameCase.DEFAULT || this.dataSource.getSQLDialect().storesUnquotedCase() != DBPIdentifierCase.UPPER) && nameCase != MappingNameCase.UPPER && CommonUtils.isNotEmpty((String)(camelCaseName = CommonUtils.toCamelCase((String)finalName)))) {
                finalName = camelCaseName.replaceAll(" ", "");
            }
        }
        if (CommonUtils.isNotEmpty((String)finalName)) {
            return DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)finalName);
        }
        log.debug((Object)("Can't transform target attribute name: " + targetName));
        return targetName;
    }

    private String getOriginalTargetName(@NotNull DatabaseMappingContainer container) {
        DBSDataContainer source = container.getSource();
        if (source instanceof StreamEntityMapping) {
            String sourceName = source.getName();
            if (sourceName.contains(".")) {
                return sourceName.substring(0, sourceName.lastIndexOf("."));
            }
        } else if (source != null) {
            return source.getName();
        }
        return container.getTargetName();
    }
}

