/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.data.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.data.IStreamValueManager;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class StreamValueManagerDescriptor
extends AbstractDescriptor {
    static final String TAG_STREAM_MANAGER = "streamManager";
    private static final String ATTR_PRIMARY_MIME = "primaryMime";
    private static final String ATTR_SUPPORTED_MIME = "supportedMime";
    private String id;
    private AbstractDescriptor.ObjectType implType;
    private final String label;
    private final String description;
    private final DBPImage icon;
    private final String primaryMime;
    private final String[] supportedMime;
    private boolean supportsText;
    private IStreamValueManager instance;

    StreamValueManagerDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.implType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.primaryMime = config.getAttribute(ATTR_PRIMARY_MIME);
        String supportedMimeString = config.getAttribute(ATTR_SUPPORTED_MIME);
        if (CommonUtils.isEmpty((String)supportedMimeString)) {
            this.supportedMime = new String[]{this.primaryMime};
        } else {
            Object[] mimeList = supportedMimeString.split(",");
            if (!ArrayUtils.contains((Object[])mimeList, (Object)this.primaryMime)) {
                mimeList = (String[])ArrayUtils.add(String.class, (Object[])mimeList, (Object)this.primaryMime);
            }
            this.supportedMime = mimeList;
        }
        for (String mime : this.supportedMime) {
            if (!ContentUtils.isTextMime((String)mime)) continue;
            this.supportsText = true;
            break;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public String[] getSupportedMime() {
        return this.supportedMime;
    }

    public String getPrimaryMime() {
        return this.primaryMime;
    }

    public boolean supportsText() {
        return this.supportsText;
    }

    @NotNull
    public IStreamValueManager getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (IStreamValueManager)this.implType.createInstance(IStreamValueManager.class);
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't instantiate content value manager '" + this.id + "'", e);
            }
        }
        return this.instance;
    }

    public String toString() {
        return this.id + " (" + this.label + ")";
    }
}

