/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class ContextDefaultObjectsReader
implements DBRRunnableWithProgress {
    private final DBPDataSource dataSource;
    private final DBCExecutionContext executionContext;
    private final List<DBNDatabaseNode> nodeList = new ArrayList<DBNDatabaseNode>();
    private DBSObject defaultObject;
    private boolean enabled;
    private boolean readNodes = false;
    private String currentDatabaseInstanceName;
    private Collection<? extends DBSObject> objectList;

    public ContextDefaultObjectsReader(DBPDataSource dataSource, DBCExecutionContext executionContext) {
        this.dataSource = dataSource;
        this.executionContext = executionContext;
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    public DBCExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public String getDefaultCatalogName() {
        return this.currentDatabaseInstanceName;
    }

    public DBSObject getDefaultObject() {
        return this.defaultObject;
    }

    public Collection<? extends DBSObject> getObjectList() {
        return this.objectList;
    }

    public void setReadNodes(boolean readNodes) {
        this.readNodes = readNodes;
    }

    public List<DBNDatabaseNode> getNodeList() {
        return this.nodeList;
    }

    @Override
    public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DBSObjectContainer objectContainer = DBUtils.getAdapter(DBSObjectContainer.class, this.dataSource);
        if (objectContainer == null) {
            return;
        }
        DBCExecutionContextDefaults contextDefaults = null;
        if (this.executionContext != null) {
            contextDefaults = this.executionContext.getContextDefaults();
        }
        if (contextDefaults == null) {
            return;
        }
        try {
            monitor.beginTask("Read default objects", 1);
            this.currentDatabaseInstanceName = null;
            Class<? extends DBSObject> childType = objectContainer.getPrimaryChildType(monitor);
            if (!DBSObjectContainer.class.isAssignableFrom(childType)) {
                this.enabled = false;
            } else {
                this.enabled = true;
                DBSObjectContainer defObject = null;
                if (DBSCatalog.class.isAssignableFrom(childType)) {
                    Class<? extends DBSObject> catalogChildrenType;
                    defObject = (DBSObjectContainer)contextDefaults.getDefaultCatalog();
                    if (defObject != null && DBSSchema.class.isAssignableFrom(catalogChildrenType = defObject.getPrimaryChildType(monitor))) {
                        this.currentDatabaseInstanceName = defObject.getName();
                        if (contextDefaults.supportsSchemaChange()) {
                            objectContainer = defObject;
                        } else if (!contextDefaults.supportsCatalogChange()) {
                            objectContainer = null;
                        }
                        Object defaultSchema = contextDefaults.getDefaultSchema();
                        if (defaultSchema != null) {
                            defObject = defaultSchema;
                        }
                    }
                } else if (DBSSchema.class.isAssignableFrom(childType)) {
                    defObject = (DBSObjectContainer)contextDefaults.getDefaultSchema();
                }
                this.objectList = objectContainer == null ? Collections.singletonList(defObject) : objectContainer.getChildren(monitor);
                this.defaultObject = defObject;
                DBSObjectContainer navigatorSource = objectContainer != null ? objectContainer : DBUtils.getAdapter(DBSObjectContainer.class, this.dataSource);
                DBNModel navigatorModel = DBNUtils.getNavigatorModel(navigatorSource);
                if (this.readNodes && navigatorModel != null && this.objectList != null) {
                    for (DBSObject dBSObject : this.objectList) {
                        DBNDatabaseNode node;
                        if (DBUtils.getAdapter(DBSObjectContainer.class, dBSObject) == null || (node = navigatorModel.getNodeByObject(monitor, dBSObject, false)) == null) continue;
                        this.nodeList.add(node);
                    }
                }
            }
        }
        catch (DBException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
        }
    }
}

