/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.bundle.ModelActivator;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.Base64;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class GeneralUtils {
    private static final Log log = Log.getLog(GeneralUtils.class);
    public static final Pattern URI_SCHEMA_PATTERN = Pattern.compile("([a-zA-Z0-9-_]+:).+");
    public static final String UTF8_ENCODING;
    public static final String DEFAULT_ENCODING;
    public static final Charset UTF8_CHARSET;
    public static final Charset DEFAULT_FILE_CHARSET;
    public static final String DEFAULT_TIMESTAMP_PATTERN = "yyyyMMddHHmm";
    public static final String DEFAULT_DATE_PATTERN = "yyyyMMdd";
    public static final String DEFAULT_TIME_PATTERN = "HHmmss";
    public static final String RESOURCE_NAME_FORBIDDEN_SYMBOLS_REGEX = "(?U)[^/:'\"\\\\<>|?*]+";
    public static final String[] byteToHex;
    public static final char[] nibbleToHex;
    private static final char[] HEX_CHAR_TABLE;
    public static final String PROP_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String PROP_TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String VALUE_TRUST_STORE_TYPE_WINDOWS = "WINDOWS-ROOT";
    public static final String EMPTY_ENV_VARIABLE_VALUE = "''";
    private static final Pattern VAR_PATTERN;

    public static String getDefaultFileEncoding() {
        return UTF8_ENCODING;
    }

    @NotNull
    public static String getDefaultConsoleEncoding() {
        String consoleEncoding = System.getProperty("console.encoding");
        if (CommonUtils.isEmpty((String)consoleEncoding)) {
            consoleEncoding = System.getProperty("file.encoding");
        }
        if (CommonUtils.isEmpty((String)consoleEncoding)) {
            consoleEncoding = GeneralUtils.getDefaultFileEncoding();
        }
        return consoleEncoding;
    }

    @NotNull
    public static String getDefaultLineSeparator() {
        return System.getProperty("line.separator", "\n");
    }

    @NotNull
    public static String normalizeLineSeparators(@NotNull String str) {
        return str.replaceAll("\r\n|\r|\n", GeneralUtils.getDefaultLineSeparator());
    }

    public static void writeBytesAsHex(@NotNull Writer out, @NotNull byte[] buf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            byte b = buf[off + i];
            int v = b & 0xFF;
            out.write(HEX_CHAR_TABLE[v >>> 4]);
            out.write(HEX_CHAR_TABLE[v & 0xF]);
        }
    }

    @NotNull
    public static String convertToString(@NotNull byte[] bytes, int offset, int length) {
        if (length == 0) {
            return "";
        }
        char[] chars = new char[length];
        for (int i = offset; i < offset + length; ++i) {
            int b = bytes[i];
            if (b < 0) {
                b = 256 + b;
            }
            if (b < 32 || b >= 127 && b <= 160) {
                b = 32;
            }
            chars[i - offset] = (char)b;
        }
        return new String(chars);
    }

    @NotNull
    public static byte[] convertToBytes(@NotNull String strValue) {
        int length = strValue.length();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            int c = strValue.charAt(i) & 0xFF;
            if (c > 127) {
                c = -(c - 127);
            }
            bytes[i] = (byte)c;
        }
        return bytes;
    }

    @NotNull
    public static Object makeDisplayString(@Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Number) {
            return NumberFormat.getInstance().format(object);
        }
        Class<?> eClass = object.getClass();
        if (eClass.isArray()) {
            if (eClass == byte[].class) {
                return Arrays.toString((byte[])object);
            }
            if (eClass == short[].class) {
                return Arrays.toString((short[])object);
            }
            if (eClass == int[].class) {
                return Arrays.toString((int[])object);
            }
            if (eClass == long[].class) {
                return Arrays.toString((long[])object);
            }
            if (eClass == char[].class) {
                return Arrays.toString((char[])object);
            }
            if (eClass == float[].class) {
                return Arrays.toString((float[])object);
            }
            if (eClass == double[].class) {
                return Arrays.toString((double[])object);
            }
            if (eClass == boolean[].class) {
                return Arrays.toString((boolean[])object);
            }
            return Arrays.deepToString((Object[])object);
        }
        return object;
    }

    @Nullable
    public static Object convertString(@Nullable String value, @Nullable Class<?> valueType) {
        try {
            if (CommonUtils.isEmpty((String)value)) {
                return null;
            }
            if (valueType == null || CharSequence.class.isAssignableFrom(valueType)) {
                return value;
            }
            if (valueType == Boolean.class || valueType == Boolean.TYPE) {
                return Boolean.valueOf(value);
            }
            if (valueType == Long.class) {
                return Long.valueOf(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Long.TYPE) {
                return Long.parseLong(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Integer.class) {
                return Integer.valueOf(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Integer.TYPE) {
                return Integer.parseInt(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Short.class) {
                return Short.valueOf(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Short.TYPE) {
                return Short.parseShort(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Byte.class) {
                return Byte.valueOf(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Byte.TYPE) {
                return Byte.parseByte(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == Double.class) {
                return Double.valueOf(value);
            }
            if (valueType == Double.TYPE) {
                return Double.parseDouble(value);
            }
            if (valueType == Float.class) {
                return Float.valueOf(value);
            }
            if (valueType == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (valueType == BigInteger.class) {
                return new BigInteger(GeneralUtils.normalizeIntegerString(value));
            }
            if (valueType == BigDecimal.class) {
                return new BigDecimal(value);
            }
            return value;
        }
        catch (RuntimeException e) {
            log.error("Error converting value", e);
            return value;
        }
    }

    @NotNull
    private static String normalizeIntegerString(@NotNull String value) {
        int divPos = value.lastIndexOf(46);
        return divPos == -1 ? value : value.substring(0, divPos);
    }

    @NotNull
    public static IStatus makeInfoStatus(@NotNull String message) {
        return new Status(1, "org.jkiss.dbeaver.model", message, null);
    }

    @NotNull
    public static IStatus makeErrorStatus(@NotNull String message) {
        return new Status(4, "org.jkiss.dbeaver.model", message, null);
    }

    @NotNull
    public static IStatus makeErrorStatus(String message, Throwable e) {
        return new Status(4, "org.jkiss.dbeaver.model", message, e);
    }

    @NotNull
    public static String getProductTitle() {
        return GeneralUtils.getProductName() + " " + GeneralUtils.getPlainVersion();
    }

    @NotNull
    public static String getLongProductTitle() {
        return GeneralUtils.getProductName() + " " + String.valueOf(GeneralUtils.getProductVersion());
    }

    @NotNull
    public static String getProductName() {
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            return ApplicationRegistry.getInstance().getApplication().getName();
        }
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getName();
        }
        return "DBeaver";
    }

    @NotNull
    public static Version getProductVersion() {
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            return application.getContributorBundle().getVersion();
        }
        IProduct product = Platform.getProduct();
        if (product == null) {
            return ModelActivator.getInstance().getBundle().getVersion();
        }
        return product.getDefiningBundle().getVersion();
    }

    @NotNull
    public static String getPlainVersion(String versionStr) {
        try {
            Version version = new Version(versionStr);
            return version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
        }
        catch (Exception e) {
            return versionStr;
        }
    }

    @NotNull
    public static String getPlainVersion() {
        Version version = GeneralUtils.getProductVersion();
        return version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
    }

    @NotNull
    public static String getMajorVersion() {
        Version version = GeneralUtils.getProductVersion();
        return version.getMajor() + "." + version.getMinor();
    }

    @NotNull
    public static Date getProductReleaseDate() {
        String buildTime;
        Bundle definingBundle = null;
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            definingBundle = application.getContributorBundle();
        } else {
            IProduct product = Platform.getProduct();
            if (product != null) {
                definingBundle = product.getDefiningBundle();
            }
        }
        if (definingBundle == null) {
            return new Date();
        }
        Dictionary headers = definingBundle.getHeaders();
        String releaseDate = (String)headers.get("Bundle-Release-Date");
        if (releaseDate != null) {
            try {
                return new SimpleDateFormat(DEFAULT_DATE_PATTERN).parse(releaseDate);
            }
            catch (ParseException e) {
                log.debug(e);
            }
        }
        if ((buildTime = (String)headers.get("Build-Time")) != null) {
            try {
                return new SimpleDateFormat(DEFAULT_TIMESTAMP_PATTERN).parse(buildTime);
            }
            catch (ParseException e) {
                log.debug(e);
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2017);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    @Nullable
    public static Date getProductBuildTime() {
        Bundle definingBundle = null;
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        if (application != null) {
            definingBundle = application.getContributorBundle();
        } else {
            IProduct product = Platform.getProduct();
            if (product != null) {
                definingBundle = product.getDefiningBundle();
            }
        }
        if (definingBundle == null) {
            return null;
        }
        Dictionary headers = definingBundle.getHeaders();
        String buildTime = (String)headers.get("Build-Time");
        if (buildTime != null) {
            try {
                return new SimpleDateFormat(DEFAULT_TIMESTAMP_PATTERN).parse(buildTime);
            }
            catch (ParseException e) {
                log.debug(e);
            }
        }
        return null;
    }

    @NotNull
    public static String getProductEarlyAccessURL() {
        return Platform.getProduct().getProperty("earlyAccessURL");
    }

    @NotNull
    public static String getExpressionParseMessage(@NotNull Exception e) {
        String message = e.getMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        int divPos = message.indexOf(64);
        return divPos == -1 ? message : message.substring(divPos + 1);
    }

    @NotNull
    public static String trimAllWhitespaces(@NotNull String str) {
        int st;
        int len = str.length();
        for (st = 0; st < len && GeneralUtils.isWhitespaceExt(str.charAt(st)); ++st) {
        }
        while (st < len && GeneralUtils.isWhitespaceExt(str.charAt(len - 1))) {
            --len;
        }
        return st > 0 || len < str.length() ? str.substring(st, len) : str;
    }

    public static boolean isWhitespaceExt(char c) {
        return c <= ' ' || c == '\u0160';
    }

    @Nullable
    public static String replaceSystemPropertyVariables(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return GeneralUtils.replaceVariables(string, System::getProperty);
    }

    @NotNull
    public static String variablePattern(@NotNull String name) {
        return "${" + name + "}";
    }

    public static boolean isVariablePattern(@NotNull String pattern) {
        return pattern.startsWith("${") && pattern.endsWith("}");
    }

    @NotNull
    public static String generateVariablesLegend(@NotNull String[][] vars) {
        String[] varPatterns = new String[vars.length];
        int patternMaxLength = 0;
        for (int i = 0; i < vars.length; ++i) {
            varPatterns[i] = GeneralUtils.variablePattern(vars[i][0]);
            patternMaxLength = Math.max(patternMaxLength, varPatterns[i].length());
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < vars.length; ++i) {
            text.append(varPatterns[i]);
            text.append(" ".repeat(Math.max(0, patternMaxLength - varPatterns[i].length())));
            text.append(" - ").append(vars[i][1]).append("\n");
        }
        return text.toString();
    }

    @Nullable
    public static String extractVariableName(@NotNull String variablePattern) {
        Matcher matcher = VAR_PATTERN.matcher(variablePattern);
        String name = null;
        String s = variablePattern;
        while (matcher.find()) {
            name = matcher.group(2);
            s = GeneralUtils.substituteVariable(s, matcher, "");
            matcher = VAR_PATTERN.matcher(s);
        }
        return name;
    }

    @NotNull
    public static List<VariableEntryInfo> findAllVariableEntries(@NotNull String string) {
        if (CommonUtils.isEmpty((String)string)) {
            return Collections.emptyList();
        }
        LinkedList<VariableEntryInfo> variables = new LinkedList<VariableEntryInfo>();
        try {
            Matcher matcher = VAR_PATTERN.matcher(string);
            int pos = 0;
            while (matcher.find(pos)) {
                pos = matcher.end();
                String varName = matcher.group(2);
                variables.add(new VariableEntryInfo(varName, matcher.start(), matcher.end()));
            }
        }
        catch (Exception e) {
            log.warn("Error matching regex", e);
        }
        return variables;
    }

    @NotNull
    public static String replaceVariables(@NotNull String string, @NotNull IVariableResolver resolver) {
        return GeneralUtils.replaceVariables(string, resolver, false);
    }

    @NotNull
    public static String replaceVariables(@NotNull String string, @NotNull IVariableResolver resolver, boolean isUpperCaseVarName) {
        if (CommonUtils.isEmpty((String)string)) {
            return string;
        }
        HashMap<String, String> resolvedVars = null;
        try {
            Matcher matcher = VAR_PATTERN.matcher(string);
            int pos = 0;
            while (matcher.find(pos)) {
                String varValue;
                String varName;
                pos = matcher.end();
                String matchedName = matcher.group(2);
                String string2 = varName = isUpperCaseVarName ? matchedName.toUpperCase(Locale.ENGLISH) : matchedName;
                if (resolvedVars != null && (varValue = (String)resolvedVars.get(varName)) != null) {
                    string = GeneralUtils.substituteVariable(string, matcher, varValue);
                    matcher = VAR_PATTERN.matcher(string);
                    pos = 0;
                    continue;
                }
                varValue = resolver.get(varName);
                if (varValue == null && (varValue = matcher.group(3)) != null && varValue.startsWith(":")) {
                    varValue = varValue.substring(1);
                }
                if (varValue == null) continue;
                if (resolvedVars == null) {
                    resolvedVars = new HashMap<String, String>();
                    if (EMPTY_ENV_VARIABLE_VALUE.equals(varValue)) {
                        varValue = "";
                    }
                    resolvedVars.put(varName, varValue);
                }
                string = GeneralUtils.substituteVariable(string, matcher, varValue);
                matcher = VAR_PATTERN.matcher(string);
                pos = 0;
            }
            return string;
        }
        catch (Exception e) {
            log.warn("Error matching regex", e);
            return string;
        }
    }

    @NotNull
    private static String substituteVariable(@NotNull String string, @NotNull Matcher matcher, @NotNull String varValue) {
        if (matcher.start() == 0 && matcher.end() >= string.length() - 1) {
            return varValue;
        }
        return string.substring(0, matcher.start()) + varValue + string.substring(matcher.end());
    }

    @Nullable
    public static <T extends Throwable> T findNestedException(@NotNull Throwable ex, @NotNull Class<T> theClass) {
        for (Throwable e = ex; e != null; e = e.getCause()) {
            if (!theClass.isInstance(e)) continue;
            return (T)((Throwable)theClass.cast(e));
        }
        return null;
    }

    @NotNull
    public static IStatus makeExceptionStatus(@NotNull Throwable ex) {
        return GeneralUtils.makeExceptionStatus(4, ex);
    }

    @NotNull
    public static IStatus makeExceptionStatus(int severity, @NotNull Throwable ex) {
        return GeneralUtils.makeExceptionStatus(severity, ex, false);
    }

    @NotNull
    public static IStatus transformExceptionsToStatus(@NotNull List<Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            return new Status(4, (Class)null, "Empty exceptions list");
        }
        HashSet<String> exceptionMessageSet = new HashSet<String>();
        Status prev = null;
        for (Throwable exception : exceptions) {
            String message = exception.getMessage();
            if (prev == null) {
                exceptionMessageSet.add(message);
                prev = new Status(4, "org.jkiss.dbeaver.model", message, null);
                continue;
            }
            if (exceptionMessageSet.contains(message)) continue;
            prev = new MultiStatus("org.jkiss.dbeaver.model", 0, new IStatus[]{prev}, message, null);
        }
        return prev;
    }

    @NotNull
    private static IStatus makeExceptionStatus(int severity, @NotNull Throwable ex, boolean nested) {
        if (ex instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)ex;
            ex = ite.getTargetException();
        }
        if (ex instanceof CoreException) {
            CoreException ce = (CoreException)ex;
            return ce.getStatus();
        }
        while (ex.getCause() != null && ex.getMessage() != null && ex.getMessage().equals(ex.getCause().getMessage())) {
            ex = ex.getCause();
        }
        Throwable cause = ex.getCause();
        SQLException nextError = null;
        if (ex instanceof SQLException) {
            SQLException sqlException = (SQLException)ex;
            nextError = sqlException.getNextException();
        } else if (cause instanceof SQLException) {
            SQLException sqlException = (SQLException)cause;
            nextError = sqlException.getNextException();
        }
        if (cause == null && nextError == null) {
            return new Status(severity, "org.jkiss.dbeaver.model", GeneralUtils.getExceptionMessage(ex), ex);
        }
        if (nextError != null) {
            ArrayList<Object> errorChain = new ArrayList<Object>();
            if (cause != null) {
                errorChain.add(GeneralUtils.makeExceptionStatus(severity, cause, true));
            }
            for (SQLException error = nextError; error != null; error = error.getNextException()) {
                errorChain.add(new Status(severity, "org.jkiss.dbeaver.model", GeneralUtils.getExceptionMessage(error)));
            }
            return new MultiStatus("org.jkiss.dbeaver.model", 0, errorChain.toArray(new IStatus[0]), GeneralUtils.getExceptionMessage(ex), ex);
        }
        return new MultiStatus("org.jkiss.dbeaver.model", 0, new IStatus[]{GeneralUtils.makeExceptionStatus(severity, cause, true)}, GeneralUtils.getExceptionMessage(ex), !nested ? null : ex);
    }

    @NotNull
    public static IStatus makeExceptionStatus(@Nullable String message, @NotNull Throwable ex) {
        return GeneralUtils.makeExceptionStatus(4, message, ex);
    }

    @NotNull
    public static IStatus makeExceptionStatus(int severity, @Nullable String message, @NotNull Throwable ex) {
        if (CommonUtils.equalObjects((Object)message, (Object)ex.getMessage())) {
            return GeneralUtils.makeExceptionStatus(severity, ex);
        }
        return new MultiStatus("org.jkiss.dbeaver.model", 0, new IStatus[]{GeneralUtils.makeExceptionStatus(severity, ex)}, message, null);
    }

    @NotNull
    public static IStatus getRootStatus(@NotNull IStatus status) {
        IStatus[] children = status.getChildren();
        if (children == null || children.length == 0) {
            return status;
        }
        return GeneralUtils.getRootStatus(children[0]);
    }

    @NotNull
    public static String getStatusText(@NotNull IStatus status) {
        StringBuilder text = new StringBuilder(status.getMessage());
        IStatus[] children = status.getChildren();
        if (children != null) {
            for (IStatus child : children) {
                text.append("\n").append(GeneralUtils.getStatusText(child));
            }
        }
        return text.toString();
    }

    @NotNull
    public static String serializeObject(@NotNull Object object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream os = new ObjectOutputStream(baos);){
                os.writeObject(object);
            }
            return Base64.encode((byte[])baos.toByteArray());
        }
        catch (Throwable e) {
            log.warn("Error serializing object [" + String.valueOf(object) + "]", e);
            return "";
        }
    }

    @Nullable
    public static Object deserializeObject(@NotNull String text) {
        Object object;
        byte[] bytes = Base64.decode((String)text);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream is = new ObjectInputStream(bais);
        try {
            object = is.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                log.warn("Error deserializing object [" + text + "]", e);
                return null;
            }
        }
        is.close();
        return object;
    }

    @NotNull
    public static Path getMetadataFolder() {
        Path workspacePath;
        if (!DBWorkbench.isPlatformStarted()) {
            log.debug("Platform not initialized: metadata folder may be not set");
            try {
                workspacePath = RuntimeUtils.getLocalPathFromURL(Platform.getInstanceLocation().getURL());
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't parse workspace location URL", e);
            }
        } else {
            DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
            if (workspace == null) {
                log.debug("Metadata is read before workspace initialization");
                try {
                    workspacePath = RuntimeUtils.getLocalPathFromURL(Platform.getInstanceLocation().getURL());
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't parse workspace location URL", e);
                }
            } else {
                workspacePath = workspace.getAbsolutePath();
            }
        }
        Path metaDir = GeneralUtils.getMetadataFolder(workspacePath);
        if (!Files.exists(metaDir, new LinkOption[0])) {
            try {
                Files.createDirectories(metaDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                return Platform.getLogFileLocation().toFile().toPath();
            }
        }
        return metaDir;
    }

    @NotNull
    public static Path getMetadataFolder(@NotNull Path workspaceFolder) {
        return workspaceFolder.resolve(".metadata");
    }

    @NotNull
    public static URI makeURIFromFilePath(@NotNull String path) throws URISyntaxException {
        Matcher matcher = URI_SCHEMA_PATTERN.matcher(path);
        if (matcher.matches()) {
            String plainPath = path.substring(matcher.end(1));
            if (RuntimeUtils.isWindows()) {
                while (plainPath.startsWith("/") && plainPath.indexOf(58) >= 0) {
                    plainPath = plainPath.substring(1);
                }
            }
            return Path.of(plainPath, new String[0]).toUri();
        }
        return Path.of(path, new String[0]).toUri();
    }

    @Nullable
    public static <T> T adapt(@Nullable Object sourceObject, @NotNull Class<T> adapter, boolean allowActivation) {
        IAdaptable adaptable;
        Object result;
        if (sourceObject == null) {
            return null;
        }
        if (adapter.isInstance(sourceObject)) {
            return adapter.cast(sourceObject);
        }
        if (sourceObject instanceof IAdaptable && (result = (adaptable = (IAdaptable)sourceObject).getAdapter(adapter)) != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException(adaptable.getClass().getName() + ".getAdapter(" + adapter.getName() + ".class) returned " + result.getClass().getName() + " that is not an instance the requested type");
            }
            return (T)result;
        }
        if (sourceObject instanceof PlatformObject && !allowActivation) {
            return null;
        }
        String adapterId = adapter.getName();
        result = GeneralUtils.queryAdapterManager(sourceObject, adapterId, allowActivation);
        if (result != null) {
            if (!adapter.isInstance(result)) {
                throw new AssertionFailedException("An adapter factory for " + sourceObject.getClass().getName() + " returned " + result.getClass().getName() + " that is not an instance of " + adapter.getName());
            }
            return adapter.cast(result);
        }
        return null;
    }

    @Nullable
    public static <T> T adapt(@Nullable Object sourceObject, @NotNull Class<T> adapter) {
        return GeneralUtils.adapt(sourceObject, adapter, true);
    }

    @Nullable
    public static Object queryAdapterManager(@NotNull Object sourceObject, @NotNull String adapterId, boolean allowActivation) {
        AdapterManager adapterManager = AdapterManager.getDefault();
        if (adapterManager == null) {
            return null;
        }
        Object result = allowActivation ? adapterManager.loadAdapter(sourceObject, adapterId) : adapterManager.getAdapter(sourceObject, adapterId);
        return result;
    }

    @NotNull
    public static byte[] getBytesFromUUID(@NotNull UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    @NotNull
    public static UUID getUUIDFromBytes(@NotNull byte[] bytes) throws IllegalArgumentException {
        if (bytes.length < 16) {
            throw new IllegalArgumentException("UUID length must be at least 16 bytes (actual length = " + bytes.length + ")");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        return new UUID(byteBuffer.getLong(), byteBuffer.getLong());
    }

    public static UUID getMixedEndianUUIDFromBytes(@NotNull byte[] bytes) {
        ByteBuffer source = ByteBuffer.wrap(bytes);
        ByteBuffer target = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putInt(source.getInt()).putShort(source.getShort()).putShort(source.getShort()).order(ByteOrder.BIG_ENDIAN).putLong(source.getLong());
        target.rewind();
        return new UUID(target.getLong(), target.getLong());
    }

    public static void validateResourceName(@NotNull String name) throws DBException {
        if (!DBWorkbench.isDistributed() && !DBWorkbench.getPlatform().getApplication().isMultiuser()) {
            return;
        }
        GeneralUtils.validateResourceNameUnconditionally(name.trim());
    }

    public static void validateResourceNameUnconditionally(@NotNull String name) throws DBException {
        if (name.startsWith(".")) {
            throw new DBException("Resource name '" + name + "' can't start with dot");
        }
        if (name.endsWith(".")) {
            throw new DBException("Resource name '" + name + "' can't end with dot");
        }
        String forbiddenSymbols = name.replaceAll(RESOURCE_NAME_FORBIDDEN_SYMBOLS_REGEX, "");
        if (CommonUtils.isNotEmpty((String)forbiddenSymbols)) {
            String forbiddenExplain = forbiddenSymbols.chars().mapToObj(c -> Character.toString((char)c)).collect(Collectors.joining(" "));
            throw new DBException("Resource name '" + name + "' contains illegal characters:  " + forbiddenExplain);
        }
    }

    @NotNull
    public static String normalizeLineEndings(@NotNull String text) {
        return text.replaceAll("(\r\n)|\r", "\n");
    }

    @Nullable
    public static String getFirstMessage(@Nullable Throwable ex) {
        for (Throwable e = ex; e != null; e = e.getCause()) {
            String message = GeneralUtils.makeStandardErrorMessage(e);
            if (CommonUtils.isEmpty((String)message)) continue;
            return message;
        }
        return null;
    }

    @NotNull
    public static String getExceptionMessage(@NotNull Throwable ex) {
        try {
            ex.getClass().getDeclaredMethod("toString", new Class[0]);
            return ex.toString();
        }
        catch (NoSuchMethodException e) {
            return GeneralUtils.makeStandardErrorMessage(ex);
        }
    }

    @Nullable
    public static String makeStandardErrorMessage(@NotNull Throwable error) {
        if (error instanceof UnknownHostException) {
            return "Unknown host " + CommonUtils.notEmpty((String)error.getMessage());
        }
        if (error instanceof UnresolvedAddressException) {
            return "Cannot resolve target address " + CommonUtils.notEmpty((String)error.getMessage());
        }
        if (error instanceof NullPointerException) {
            return "Internal error (NPE)";
        }
        if (error instanceof ClassNotFoundException) {
            ClassNotFoundException cnfe = (ClassNotFoundException)error;
            return "Class not found: " + cnfe.getMessage();
        }
        if (error instanceof NoClassDefFoundError) {
            NoClassDefFoundError ncdf = (NoClassDefFoundError)error;
            return "Class definition not found: " + ncdf.getMessage();
        }
        return error.getLocalizedMessage();
    }

    static {
        DEFAULT_ENCODING = UTF8_ENCODING = StandardCharsets.UTF_8.name();
        DEFAULT_FILE_CHARSET = UTF8_CHARSET = StandardCharsets.UTF_8;
        byteToHex = new String[256];
        nibbleToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HEX_CHAR_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int i = 0; i < 256; ++i) {
            GeneralUtils.byteToHex[i] = Character.toString(nibbleToHex[i >>> 4]) + nibbleToHex[i & 0xF];
        }
        VAR_PATTERN = Pattern.compile("(\\$\\{([\\w\\.\\-]+)(\\:[^\\$\\{\\}]+)?\\})", 2);
    }

    public record VariableEntryInfo(@NotNull String name, int start, int end) {
    }

    public static interface IParameterHandler {
        public boolean setParameter(String var1, String var2);
    }
}

