/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.impls;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableInheritance;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablePartition;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreServerExtensionBase
implements PostgreServerExtension {
    public static final int TRUNCATE_TOOL_MODE_SUPPORT_ONLY_ONE_TABLE = 1;
    public static final int TRUNCATE_TOOL_MODE_SUPPORT_IDENTITIES = 2;
    public static final int TRUNCATE_TOOL_MODE_SUPPORT_CASCADE = 4;
    private static final Log log = Log.getLog(PostgreServerExtensionBase.class);
    protected final PostgreDataSource dataSource;

    protected PostgreServerExtensionBase(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsOids() {
        return true;
    }

    @Override
    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsForeignKeys() {
        return true;
    }

    @Override
    public boolean supportsMaterializedViews() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }

    @Override
    public boolean supportsPartitions() {
        return this.dataSource.isServerVersionAtLeast(10, 0);
    }

    @Override
    public boolean supportsInheritance() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsEventTriggers() {
        return false;
    }

    @Override
    public boolean supportsDependencies() {
        return true;
    }

    @Override
    public boolean supportsFunctionCreate() {
        return true;
    }

    @Override
    public boolean supportsRules() {
        return true;
    }

    @Override
    public boolean supportsRowLevelSecurity() {
        return false;
    }

    @Override
    public boolean supportsExtensions() {
        return this.dataSource.isServerVersionAtLeast(9, 1);
    }

    @Override
    public boolean supportsEncodings() {
        return true;
    }

    @Override
    public boolean supportsCollations() {
        return this.dataSource.isServerVersionAtLeast(9, 1);
    }

    @Override
    public boolean supportsLanguages() {
        return true;
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public PostgreSequence createSequence(@NotNull PostgreSchema schema) {
        return new PostgreSequence(schema);
    }

    @Override
    public boolean supportsRoles() {
        return this.dataSource.isServerVersionAtLeast(8, 1);
    }

    @Override
    public boolean supportsSessionActivity() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }

    @Override
    public boolean supportsLocks() {
        return this.dataSource.isServerVersionAtLeast(9, 3);
    }

    @Override
    public boolean supportsForeignServers() {
        return this.dataSource.isServerVersionAtLeast(8, 4);
    }

    @Override
    public boolean supportsAggregates() {
        return true;
    }

    @Override
    public boolean supportsResultSetLimits() {
        return true;
    }

    @Override
    public boolean supportsClientInfo() {
        return true;
    }

    @Override
    public String readTableDDL(DBRProgressMonitor monitor, PostgreTableBase table) throws DBException {
        return null;
    }

    @Override
    public String readViewDDL(DBRProgressMonitor monitor, PostgreViewBase view) throws DBException {
        return null;
    }

    @Override
    public boolean supportsTemplates() {
        return true;
    }

    public PostgreDatabase.SchemaCache createSchemaCache(PostgreDatabase database) {
        return new PostgreDatabase.SchemaCache();
    }

    @Override
    public PostgreTableBase createRelationOfClass(PostgreSchema schema, PostgreClass.RelKind kind, JDBCResultSet dbResult) {
        if (kind == PostgreClass.RelKind.r) {
            return new PostgreTableRegular(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.R) {
            return new PostgreTablePartition(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.v) {
            return new PostgreView(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.m) {
            return new PostgreMaterializedView(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.f) {
            return new PostgreTableForeign(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.S) {
            return new PostgreSequence(schema, dbResult);
        }
        if (kind == PostgreClass.RelKind.t) {
            return new PostgreTableRegular(schema, (ResultSet)dbResult);
        }
        if (kind == PostgreClass.RelKind.p) {
            return new PostgreTableRegular(schema, (ResultSet)dbResult);
        }
        log.debug((Object)("Unsupported PG class: '" + String.valueOf(kind) + "'"));
        return null;
    }

    @Override
    public PostgreTableBase createNewRelation(DBRProgressMonitor monitor, PostgreSchema schema, PostgreClass.RelKind kind, Object copyFrom) throws DBException {
        if (kind == PostgreClass.RelKind.v) {
            return new PostgreView(schema);
        }
        if (kind == PostgreClass.RelKind.m) {
            return new PostgreMaterializedView(schema);
        }
        if (kind == PostgreClass.RelKind.f) {
            return new PostgreTableForeign(schema);
        }
        if (kind == PostgreClass.RelKind.S) {
            return new PostgreSequence(schema);
        }
        if (copyFrom instanceof PostgreTableRegular) {
            return new PostgreTableRegular(monitor, schema, (PostgreTableRegular)copyFrom);
        }
        return new PostgreTableRegular(schema);
    }

    @Override
    public boolean supportsRelationSizeCalc() {
        return true;
    }

    @Override
    public boolean supportsFunctionDefRead() {
        return this.dataSource.isServerVersionAtLeast(8, 4);
    }

    @Override
    public void configureDialect(PostgreDialect dialect) {
    }

    @Override
    public String getTableModifiers(DBRProgressMonitor monitor, PostgreTableBase tableBase, boolean alter, String delimiter) {
        PostgreTable table;
        StringBuilder ddl = new StringBuilder();
        if (tableBase instanceof PostgreTable) {
            String expression;
            table = (PostgreTable)tableBase;
            if (!alter) {
                try {
                    List<PostgreTableInheritance> superTables = table.getSuperInheritance(monitor);
                    if (!CommonUtils.isEmpty(superTables) && !tableBase.isPartition()) {
                        ddl.append(delimiter).append("INHERITS (");
                        for (int i = 0; i < superTables.size(); ++i) {
                            if (i > 0) {
                                ddl.append(",");
                            }
                            ddl.append(superTables.get(i).getAssociatedEntity().getFullyQualifiedName(DBPEvaluationContext.DDL));
                        }
                        ddl.append(")");
                    }
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
                if (!CommonUtils.isEmpty((String)table.getPartitionKey())) {
                    ddl.append(delimiter).append("PARTITION BY ").append(table.getPartitionKey());
                }
            }
            if (tableBase instanceof PostgreTablePartition && !alter && CommonUtils.isNotEmpty((String)(expression = ((PostgreTablePartition)tableBase).getPartitionExpression()))) {
                ddl.append(" ").append(expression);
            }
        }
        if (tableBase instanceof PostgreTableRegular && !alter) {
            this.createUsingClause((PostgreTableRegular)tableBase, ddl);
        }
        if (tableBase instanceof PostgreTableRegular) {
            table = (PostgreTableRegular)tableBase;
            try {
                PostgreTablespace tablespace;
                if (!alter) {
                    ddl.append(this.createWithClause((PostgreTableRegular)table, tableBase));
                }
                boolean hasOtherSpecs = false;
                if (table.isTablespaceSpecified() && (tablespace = table.getTablespace(monitor)) != null) {
                    if (!alter) {
                        ddl.append(delimiter).append("TABLESPACE ").append(tablespace.getName());
                    }
                    hasOtherSpecs = true;
                }
                if (!alter && hasOtherSpecs) {
                    ddl.append(delimiter);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        } else if (tableBase instanceof PostgreTableForeign) {
            PostgreTableForeign table2 = (PostgreTableForeign)tableBase;
            try {
                Object[] foreignOptions;
                PostgreForeignServer foreignServer;
                String foreignServerName = table2.getForeignServerName();
                if (CommonUtils.isEmpty((String)foreignServerName) && (foreignServer = table2.getForeignServer(monitor)) != null) {
                    foreignServerName = DBUtils.getQuotedIdentifier((DBSObject)foreignServer);
                }
                if (foreignServerName != null) {
                    ddl.append(delimiter).append("SERVER ").append(foreignServerName);
                }
                if (!ArrayUtils.isEmpty((Object[])(foreignOptions = table2.getForeignOptions(monitor)))) {
                    ddl.append(delimiter).append("OPTIONS ").append(PostgreUtils.getOptionsString((String[])foreignOptions));
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        tableBase.appendTableModifiers(monitor, ddl);
        return ddl.toString();
    }

    @Override
    public void initDefaultSSLConfig(DBPConnectionConfiguration connectionInfo, Map<String, String> props) {
        if (connectionInfo.getProperty("ssl") == null) {
            props.put("ssl", "false");
        }
    }

    @Override
    public List<PostgrePrivilege> readObjectPermissions(DBRProgressMonitor monitor, PostgreTableBase object, boolean includeNestedObjects) throws DBException {
        List<PostgrePrivilege> tablePermissions = PostgreUtils.extractPermissionsFromACL(monitor, object, object.getAcl(), false);
        if (!includeNestedObjects) {
            return tablePermissions;
        }
        tablePermissions = new ArrayList<PostgrePrivilege>(tablePermissions);
        for (PostgreTableColumn column : CommonUtils.safeCollection(object.getAttributes(monitor))) {
            if (column.getAcl() == null || column.isHidden()) continue;
            tablePermissions.addAll(column.getPrivileges(monitor, true));
        }
        return tablePermissions;
    }

    @Override
    public Map<String, String> getDataTypeAliases() {
        return PostgreConstants.DATA_TYPE_ALIASES;
    }

    @Override
    public boolean supportsTableStatistics() {
        return true;
    }

    @Override
    public boolean supportsEntityMetadataInResults() {
        return false;
    }

    @Override
    public boolean supportsExplainPlan() {
        return true;
    }

    @Override
    public boolean supportsExplainPlanXML() {
        return this.dataSource.isServerVersionAtLeast(9, 0);
    }

    @Override
    public boolean supportsExplainPlanVerbose() {
        return true;
    }

    @Override
    public boolean supportsDatabaseDescription() {
        return this.dataSource.isServerVersionAtLeast(9, 4);
    }

    @Override
    public boolean supportsTemporalAccessor() {
        return false;
    }

    @Override
    public boolean supportsTablespaceLocation() {
        return this.dataSource.isServerVersionAtLeast(9, 2);
    }

    @Override
    public boolean supportsStoredProcedures() {
        return this.dataSource.isServerVersionAtLeast(11, 0);
    }

    @Override
    public String getProceduresSystemTable() {
        return "pg_proc";
    }

    @Override
    public String getProceduresOidColumn() {
        return "oid";
    }

    public String createWithClause(PostgreTableRegular table, PostgreTableBase tableBase) {
        StringBuilder withClauseBuilder = new StringBuilder();
        boolean hasExtraOptions = this.dataSource.isServerVersionAtLeast(8, 2) && table.getRelOptions() != null;
        boolean tableSupportOids = ((PostgreDataSource)table.getDataSource()).getServerType().supportsOids() && table.isHasOids() && ((PostgreDataSource)table.getDataSource()).getServerType().supportsHasOidsColumn();
        ArrayList<String> extraOptions = new ArrayList<String>();
        if (tableSupportOids) {
            extraOptions.add("OIDS=TRUE");
        }
        if (hasExtraOptions) {
            extraOptions.addAll(Arrays.asList(table.getRelOptions()));
        }
        if (!CommonUtils.isEmpty(extraOptions)) {
            withClauseBuilder.append("\nWITH (");
            for (int i = 0; i < extraOptions.size(); ++i) {
                if (i > 0) {
                    withClauseBuilder.append(",");
                }
                withClauseBuilder.append("\n\t");
                withClauseBuilder.append((String)extraOptions.get(i));
            }
            withClauseBuilder.append("\n)");
        }
        return withClauseBuilder.toString();
    }

    public void createUsingClause(@NotNull PostgreTableRegular table, @NotNull StringBuilder ddl) {
    }

    @Override
    public boolean supportsPGConstraintExpressionColumn() {
        return true;
    }

    @Override
    public boolean supportsHasOidsColumn() {
        return true;
    }

    @Override
    public boolean supportsColumnsRequiring() {
        return true;
    }

    @Override
    public boolean supportsDatabaseSize() {
        return false;
    }

    @Override
    public boolean isAlterTableAtomic() {
        return false;
    }

    @Override
    public boolean supportsSuperusers() {
        return true;
    }

    @Override
    public boolean supportsRolesWithCreateDBAbility() {
        return this.supportsRoles();
    }

    @Override
    public boolean supportsRoleReplication() {
        return this.dataSource.isServerVersionAtLeast(9, 1);
    }

    @Override
    public boolean supportsRoleBypassRLS() {
        return this.dataSource.isServerVersionAtLeast(9, 5);
    }

    @Override
    public boolean supportsCommentsOnRole() {
        return this.supportsRoles();
    }

    @Override
    public boolean supportsDefaultPrivileges() {
        return this.dataSource.isServerVersionAtLeast(9, 0);
    }

    @Override
    public boolean supportSerialTypes() {
        return true;
    }

    @Override
    public boolean supportsExternalTypes() {
        return false;
    }

    @Override
    public boolean supportsBackslashStringEscape() {
        return false;
    }

    @Override
    public boolean supportsDisablingAllTriggers() {
        return false;
    }

    @Override
    public boolean supportsGeneratedColumns() {
        return false;
    }

    @Override
    public boolean isHiddenRowidColumn(@NotNull PostgreAttribute attribute) {
        return false;
    }

    @Override
    public boolean supportsShowingOfExtraComments() {
        return true;
    }

    @Override
    public boolean supportsKeyAndIndexRename() {
        return false;
    }

    @Override
    public boolean supportsAlterStorageStrategy() {
        return false;
    }

    @Override
    public boolean supportsStorageModifier() {
        return false;
    }

    @Override
    public boolean supportsAlterUserChangePassword() {
        return false;
    }

    @Override
    public boolean supportsCopyFromStdIn() {
        return false;
    }

    @Override
    public int getParameterBindType(DBSTypedObject type, Object value) {
        return 1111;
    }

    @Override
    public int getTruncateToolModes() {
        return 7;
    }

    @Override
    public boolean supportsAcl() {
        return true;
    }

    @Override
    public boolean supportsCustomDataTypes() {
        return true;
    }

    @Override
    public boolean supportsDistinctForStatementsWithAcl() {
        return true;
    }

    @Override
    public boolean supportsOpFamily() {
        return this.dataSource.isServerVersionAtLeast(8, 3);
    }

    @Override
    public boolean supportsAlterTableColumnWithUSING() {
        return this.dataSource.isServerVersionAtLeast(8, 0);
    }

    @Override
    public boolean supportsAlterTableForViewRename() {
        return false;
    }

    @Override
    public boolean supportsNativeClient() {
        return true;
    }

    @Override
    public boolean supportsJobs() {
        return false;
    }

    @Override
    public boolean isPGObject(@NotNull Object object) {
        String className = object.getClass().getName();
        return "org.postgresql.util.PGobject".equals(className);
    }
}

