/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class SAXReader
implements ContentHandler,
EntityResolver,
DTDHandler {
    public static final int DEFAULT_POOL_SIZE = 10;
    private static SAXParserFactory saxParserFactory = null;
    private static List<Parser> parsersPool = new ArrayList<Parser>();
    private InputSource inputSource;
    private Locator locator;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private List<SAXListener> elementLayers = new ArrayList<SAXListener>();
    private SAXListener curListener;
    private StringBuilder textValue = new StringBuilder();
    private int depth = 0;
    private boolean handleWhiteSpaces = false;

    private SAXReader() {
    }

    public SAXReader(InputStream stream) {
        this();
        this.inputSource = new InputSource(stream);
    }

    public SAXReader(Reader reader) {
        this();
        this.inputSource = new InputSource(reader);
    }

    public boolean isHandleWhiteSpaces() {
        return this.handleWhiteSpaces;
    }

    public void setHandleWhiteSpaces(boolean flag) {
        this.handleWhiteSpaces = flag;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public void parse(SAXListener listener) throws IOException, XMLException {
        try (Parser parser = SAXReader.acquireParser();){
            XMLReader saxReader = parser.getSAXParser().getXMLReader();
            saxReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setErrorHandler(new ParseErrorHandler());
            saxReader.setContentHandler(this);
            saxReader.setEntityResolver(this);
            saxReader.setDTDHandler(this);
            this.curListener = listener;
            this.elementLayers.add(listener);
            saxReader.parse(this.inputSource);
        }
    }

    public static synchronized Parser acquireParser() throws XMLException {
        try {
            if (saxParserFactory == null) {
                try {
                    saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setNamespaceAware(true);
                    saxParserFactory.setValidating(false);
                }
                catch (FactoryConfigurationError toCatch) {
                    throw new XMLException("SAX factory configuration error", toCatch);
                }
            }
            for (int i = 0; i < parsersPool.size(); ++i) {
                Parser parser = parsersPool.get(i);
                if (parser != null) {
                    if (parser.isAcquired()) continue;
                    parser.acquire();
                    return parser;
                }
                parsersPool.remove(i);
                parser = new Parser(saxParserFactory.newSAXParser(), true);
                parsersPool.add(parser);
                return parser;
            }
            if (parsersPool.size() == 10) {
                throw new XMLException("Maximum SAX Parsers Number Exceeded (10)");
            }
            Parser parser = new Parser(saxParserFactory.newSAXParser(), true);
            parsersPool.add(parser);
            return parser;
        }
        catch (ParserConfigurationException toCatch) {
            throw new XMLException("SAX Parser Configuration error", toCatch);
        }
        catch (SAXException toCatch) {
            throw new XMLException("SAX Parser error", toCatch);
        }
    }

    public void close() {
        if (this.elementLayers != null) {
            this.elementLayers.clear();
            this.elementLayers = null;
        }
        this.inputSource = null;
        this.curListener = null;
    }

    public void setListener(SAXListener listener) {
        this.curListener = listener;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.get(name) != null;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    private void handleText() throws SAXException {
        this.curListener = this.elementLayers.get(this.elementLayers.size() - 1);
        try {
            String value = this.textValue.toString();
            this.curListener.saxText(this, value);
        }
        catch (Exception toCatch) {
            throw new SAXException(toCatch);
        }
        finally {
            this.textValue.setLength(0);
        }
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
        this.close();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.depth++ > 0) {
            this.handleText();
        }
        this.curListener = this.elementLayers.get(this.elementLayers.size() - 1);
        try {
            this.curListener.saxStartElement(this, namespaceURI, localName, attributes);
        }
        catch (XMLException toCatch) {
            throw new SAXException(toCatch);
        }
        this.elementLayers.add(this.curListener);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.handleText();
        this.elementLayers.remove(this.elementLayers.size() - 1);
        this.curListener = this.elementLayers.get(this.elementLayers.size() - 1);
        try {
            this.curListener.saxEndElement(this, namespaceURI, localName);
        }
        catch (XMLException toCatch) {
            throw new SAXException(toCatch);
        }
        --this.depth;
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.textValue.append(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.handleWhiteSpaces) {
            this.textValue.append(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public static class Parser {
        private SAXParser saxParser;
        private boolean isAcquired;

        public Parser(SAXParser saxParser, boolean isAcquired) {
            this.saxParser = saxParser;
            this.isAcquired = isAcquired;
        }

        public void setSAXParser(SAXParser saxParser) {
            this.saxParser = saxParser;
        }

        public void acquire() {
            this.isAcquired = true;
        }

        public void close() {
            this.isAcquired = false;
        }

        public SAXParser getSAXParser() {
            return this.saxParser;
        }

        public boolean isAcquired() {
            return this.isAcquired;
        }
    }

    static class ParseErrorHandler
    implements ErrorHandler {
        ParseErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
        }

        @Override
        public void fatalError(SAXParseException exception) {
        }

        @Override
        public void warning(SAXParseException exception) {
        }
    }
}

