/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.importer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.database.DatabaseTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;
import org.jkiss.utils.csv.CSVReader;
import org.jkiss.utils.io.BOMInputStream;

public class DataImporterCSV
extends StreamImporterAbstract {
    private static final Log log = Log.getLog(DataImporterCSV.class);
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_HEADER = "header";
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_EMPTY_STRING_NULL = "emptyStringNull";
    private static final String PROP_ESCAPE_CHAR = "escapeChar";
    private static final String PROP_STRICT_QUOTES = "strictQuotes";
    private static final String PROP_TRIM_WHITESPACES = "trimWhitespaces";
    public static final int READ_BUFFER_SIZE = 261120;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        ArrayList<StreamDataImporterColumnInfo> columnsInfo = new ArrayList<StreamDataImporterColumnInfo>();
        Map<String, Object> processorProperties = this.getSite().getProcessorProperties();
        HeaderPosition headerPosition = this.getHeaderPosition(processorProperties);
        String encoding = CommonUtils.toString((Object)processorProperties.get(PROP_ENCODING), (String)GeneralUtils.UTF8_ENCODING);
        int columnSamplesCount = Math.max(CommonUtils.toInt((Object)processorProperties.get("columnTypeSamplesCount"), (int)100), 0);
        int columnMinimalLength = Math.max(CommonUtils.toInt((Object)processorProperties.get("columnTypeMinimalLength"), (int)1), 1);
        boolean columnIsByteLength = CommonUtils.getBoolean((Object)processorProperties.get("columnTypeIsByteLength"), (boolean)false);
        try (Reader reader = this.openStreamReader(inputStream, processorProperties, true);
             CSVReader csvReader = this.openCSVReader(reader, processorProperties);){
            String[] header = this.getNextLine(csvReader);
            if (header == null) {
                ArrayList<StreamDataImporterColumnInfo> arrayList = columnsInfo;
                return arrayList;
            }
            for (int i = 0; i < header.length; ++i) {
                Object column = null;
                if (headerPosition == HeaderPosition.top) {
                    column = DBUtils.getUnQuotedIdentifier((DBPDataSource)entityMapping.getDataSource(), (String)header[i]);
                }
                if (CommonUtils.isEmptyTrimmed(column)) {
                    column = "Column" + (i + 1);
                }
                StreamDataImporterColumnInfo columnInfo = new StreamDataImporterColumnInfo(entityMapping, i, (String)column, "String", columnMinimalLength, DBPDataKind.UNKNOWN);
                columnInfo.setMappingMetadataPresent(headerPosition != HeaderPosition.none);
                columnsInfo.add(columnInfo);
            }
            for (int sample = 0; sample < columnSamplesCount; ++sample) {
                String[] line;
                if (sample == 0 && headerPosition == HeaderPosition.none) {
                    line = header;
                } else {
                    line = this.getNextLine(csvReader);
                    if (line == null) break;
                }
                block20: for (int i = 0; i < Math.min(line.length, header.length); ++i) {
                    Pair<DBPDataKind, String> dataType = DatabaseTransferUtils.getDataType(line[i]);
                    StreamDataImporterColumnInfo columnInfo = (StreamDataImporterColumnInfo)((Object)columnsInfo.get(i));
                    switch ((DBPDataKind)dataType.getFirst()) {
                        case STRING: {
                            columnInfo.updateMaxLength(entityMapping.getDataSource(), columnIsByteLength ? (long)line[i].getBytes(encoding).length : (long)line[i].length());
                        }
                        case NUMERIC: 
                        case BOOLEAN: {
                            columnInfo.updateType((DBPDataKind)dataType.getFirst(), (String)dataType.getSecond());
                            continue block20;
                        }
                    }
                }
            }
            for (StreamDataImporterColumnInfo columnInfo : columnsInfo) {
                if (columnInfo.getDataKind() != DBPDataKind.UNKNOWN) continue;
                log.debug((Object)("Cannot guess data type for column '" + columnInfo.getName() + "', defaulting to VARCHAR"));
                columnInfo.updateType(DBPDataKind.STRING, "VARCHAR");
            }
        }
        catch (IOException e) {
            throw new DBException("IO error reading CSV", (Throwable)e);
        }
        return columnsInfo;
    }

    private HeaderPosition getHeaderPosition(Map<String, Object> processorProperties) {
        return (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)CommonUtils.toString((Object)processorProperties.get(PROP_HEADER)), (Enum)HeaderPosition.top);
    }

    private CSVReader openCSVReader(Reader reader, Map<String, Object> processorProperties) {
        String escapeChar;
        String delimiter = StreamTransferUtils.getDelimiterString(processorProperties, PROP_DELIMITER);
        String quoteChar = CommonUtils.toString((Object)processorProperties.get(PROP_QUOTE_CHAR));
        if (CommonUtils.isEmpty((String)quoteChar)) {
            quoteChar = String.valueOf('\u0000');
        }
        if (CommonUtils.isEmpty((String)(escapeChar = CommonUtils.toString((Object)processorProperties.get(PROP_ESCAPE_CHAR))))) {
            escapeChar = String.valueOf('\u0000');
        }
        boolean strictQuotes = CommonUtils.toBoolean((Object)processorProperties.get(PROP_STRICT_QUOTES));
        return new CSVReader(reader, delimiter.charAt(0), quoteChar.charAt(0), escapeChar.charAt(0), 0, strictQuotes);
    }

    private Reader openStreamReader(InputStream inputStream, Map<String, Object> processorProperties, boolean useBufferedStream) throws UnsupportedEncodingException {
        String encoding = CommonUtils.toString((Object)processorProperties.get(PROP_ENCODING), (String)GeneralUtils.UTF8_ENCODING);
        Charset charset = Charset.forName(encoding);
        if (useBufferedStream) {
            inputStream = new BufferedInputStream(inputStream, 261120);
        }
        try {
            inputStream = new BOMInputStream(inputStream, charset);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new InputStreamReader(inputStream, charset);
    }

    private String[] getNextLine(CSVReader csvReader) throws IOException {
        String[] line;
        do {
            if ((line = csvReader.readNext()) != null) continue;
            return null;
        } while (line.length == 0);
        return line;
    }

    @Override
    public void runImport(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, @NotNull IDataTransferConsumer<?, ?> consumer) throws DBException {
        IStreamDataImporterSite site = this.getSite();
        StreamEntityMapping entityMapping = site.getSourceObject();
        Map<String, Object> properties = site.getProcessorProperties();
        HeaderPosition headerPosition = this.getHeaderPosition(properties);
        boolean emptyStringNull = CommonUtils.getBoolean((Object)properties.get(PROP_EMPTY_STRING_NULL), (boolean)false);
        boolean trimWhitespaces = CommonUtils.getBoolean((Object)properties.get(PROP_TRIM_WHITESPACES), (boolean)false);
        String nullValueMark = CommonUtils.toString((Object)properties.get(PROP_NULL_STRING));
        DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
        try (DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");
             LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM Stream");
             StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);){
            DBDDataReceiver.startFetchWorkflow(consumer, (DBCSession)producerSession, (DBCResultSet)resultSet, (long)-1L, (long)-1L);
            this.applyTransformHints(resultSet, consumer, properties, "timestampFormat", "timestampZone");
            try (Reader reader = this.openStreamReader(inputStream, properties, true);
                 CSVReader csvReader = this.openCSVReader(reader, properties);){
                int maxRows = site.getSettings().getMaxRows();
                int targetAttrSize = entityMapping.getStreamColumns().size();
                boolean headerRead = false;
                long lineNum = 0L;
                while (!monitor.isCanceled()) {
                    Object[] line = csvReader.readNext();
                    if (line == null) {
                        if (csvReader.getParser().isPending()) {
                            throw new IOException("Un-terminated quote sequence was detected");
                        }
                        break;
                    }
                    if (line.length == 0) continue;
                    if (headerPosition != HeaderPosition.none && !headerRead) {
                        headerRead = true;
                        continue;
                    }
                    if (maxRows > 0 && lineNum >= (long)maxRows) {
                        break;
                    }
                    if (line.length < targetAttrSize) {
                        String[] newLine = new String[targetAttrSize];
                        System.arraycopy(line, 0, newLine, 0, line.length);
                        for (int i = line.length; i < targetAttrSize; ++i) {
                            newLine[i] = null;
                        }
                        line = newLine;
                    }
                    if (trimWhitespaces) {
                        for (int i = 0; i < line.length; ++i) {
                            line[i] = ((String)line[i]).trim();
                        }
                    }
                    if (emptyStringNull) {
                        for (int i = 0; i < line.length; ++i) {
                            if (!"".equals(line[i])) continue;
                            line[i] = null;
                        }
                    }
                    if (!CommonUtils.isEmpty((String)nullValueMark)) {
                        for (int i = 0; i < line.length; ++i) {
                            if (!nullValueMark.equals(line[i])) continue;
                            line[i] = null;
                        }
                    }
                    resultSet.setStreamRow(line);
                    consumer.fetchRow(producerSession, resultSet);
                    if (!DBFetchProgress.monitorFetchProgress((long)(++lineNum))) continue;
                    monitor.subTask(Long.toUnsignedString(lineNum) + " rows processed");
                }
            }
            catch (IOException e) {
                throw new DBException("IO error reading CSV", (Throwable)e);
            }
        }
    }

    public static enum HeaderPosition {
        none,
        top;

    }
}

