/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.tools;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConnection;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTable;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableForeignKey;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTablePartitionColumn;
import org.jkiss.dbeaver.ext.exasol.model.ExasolTableUniqueKey;
import org.jkiss.dbeaver.ext.exasol.model.security.ExasolTableObjectType;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class ExasolUtils {
    public static final String SNAPSHOT_EXEC = "/*snapshot execution*/";
    private static final String TABLE_QUERY_COLUMNS = "/*snapshot execution*/ SELECT * FROM EXA_ALL_COLUMNS WHERE COLUMN_SCHEMA='%s' AND COLUMN_TABLE='%s' ORDER BY COLUMN_ORDINAL_POSITION";
    private static final Log log = Log.getLog(ExasolUtils.class);

    public static String quoteString(String input) {
        return input.replaceAll("'", "''");
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String generateDDLforTable(DBRProgressMonitor monitor, ExasolDataSource dataSource, ExasolTable exasolTable) throws DBException {
        StringBuilder ddlOutput = new StringBuilder();
        ddlOutput.append("CREATE TABLE ").append(exasolTable.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" (");
        try {
            String string;
            block28: {
                JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)exasolTable, (String)"Get Table DDL");
                try {
                    Collection<ExasolTableForeignKey> fks;
                    try (JDBCStatement dbStat = session.createStatement();){
                        JDBCResultSet rs = dbStat.executeQuery(String.format(TABLE_QUERY_COLUMNS, ExasolUtils.quoteString(exasolTable.getSchema().getName()), ExasolUtils.quoteString(exasolTable.getName())));
                        ArrayList<String> columns = new ArrayList<String>();
                        ArrayList<String> distKey = new ArrayList<String>();
                        while (rs.next()) {
                            String columnComment;
                            BigDecimal bigDecimal;
                            StringBuilder columnString = new StringBuilder();
                            columnString.append("\n\t\t").append(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)CommonUtils.notEmpty((String)rs.getString("COLUMN_NAME")))).append(" ").append(rs.getString("COLUMN_TYPE"));
                            String columnDefault = rs.getString("COLUMN_DEFAULT");
                            if (columnDefault != null) {
                                columnString.append(" DEFAULT ").append(columnDefault);
                            }
                            if ((bigDecimal = rs.getBigDecimal("COLUMN_IDENTITY")) != null) {
                                columnString.append(" IDENTITY ").append(bigDecimal.toString());
                            }
                            if (!rs.getBoolean("COLUMN_IS_NULLABLE")) {
                                columnString.append(" NOT NULL");
                            }
                            if ((columnComment = rs.getString("COLUMN_COMMENT")) != null) {
                                columnString.append(" COMMENT IS '").append(columnComment.replaceAll("'", "''")).append("'");
                            }
                            if (rs.getBoolean("COLUMN_IS_DISTRIBUTION_KEY")) {
                                distKey.add(rs.getString("COLUMN_NAME"));
                            }
                            columns.add(columnString.toString());
                        }
                        ddlOutput.append(CommonUtils.joinStrings((String)",", columns));
                        if (distKey.size() > 0) {
                            ddlOutput.append(",\n\t\t DISTRIBUTE BY ").append(CommonUtils.joinStrings((String)",", distKey));
                        }
                        ddlOutput.append("\n);\n");
                    }
                    ddlOutput.append(ExasolUtils.getPartitionDdl(exasolTable, monitor));
                    Collection<ExasolTableUniqueKey> pks = exasolTable.getConstraints(monitor);
                    if (pks != null && pks.size() > 0) {
                        ExasolTableUniqueKey pk = pks.iterator().next();
                        ddlOutput.append("\n").append(ExasolUtils.getPKDdl(pk, monitor)).append(";\n");
                    }
                    if ((fks = exasolTable.getAssociations(monitor)) != null && fks.size() > 0) {
                        for (ExasolTableForeignKey fk : fks) {
                            ddlOutput.append("\n").append(ExasolUtils.getFKDdl(fk, monitor)).append(";\n");
                        }
                    }
                    string = ddlOutput.toString();
                    if (session == null) break block28;
                }
                catch (Throwable throwable) {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new DBDatabaseException((Throwable)e, (DBPDataSource)dataSource);
                    }
                }
                session.close();
            }
            return string;
        }
        finally {
            monitor.done();
        }
    }

    public static String getPartitionDdl(ExasolTable table, DBRProgressMonitor monitor) throws DBException {
        if (table.getPartitions(monitor).size() == 0) {
            return "";
        }
        Collection cols = table.getPartitions(monitor).stream().sorted(Comparator.comparing(ExasolTablePartitionColumn::getOrdinalPosition)).map(pc -> DBUtils.getQuotedIdentifier((DBSObject)pc)).collect(Collectors.toCollection(ArrayList::new));
        String colList = String.join((CharSequence)",", cols);
        return String.format("ALTER TABLE %s PARTITION BY %s;\n", DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL), colList);
    }

    public static String getFKDdl(ExasolTableForeignKey fk, DBRProgressMonitor monitor) throws DBException {
        ExasolTable exasolTable = (ExasolTable)fk.getTable();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> refColumns = new ArrayList<String>();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : fk.getAttributeReferences(monitor)) {
            columns.add(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttributeRef.getAttribute()));
        }
        for (DBSEntityAttributeRef dBSEntityAttributeRef : fk.getReferencedConstraint().getAttributeReferences(monitor)) {
            refColumns.add(DBUtils.getQuotedIdentifier((DBSObject)dBSEntityAttributeRef.getAttribute()));
        }
        String fk_enabled = " DISABLE";
        if (fk.getEnabled().booleanValue()) {
            fk_enabled = " ENABLE";
        }
        return "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)exasolTable, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)fk) + " FOREIGN KEY (" + CommonUtils.joinStrings((String)",", columns) + ") REFERENCES " + DBUtils.getObjectFullName((DBPNamedObject)fk.getAssociatedEntity(), (DBPEvaluationContext)DBPEvaluationContext.DDL) + " (" + CommonUtils.joinStrings((String)",", refColumns) + ")" + fk_enabled;
    }

    public static String getPKDdl(ExasolTableUniqueKey pk, DBRProgressMonitor monitor) throws DBException {
        ExasolTable exasolTable = pk.getTable();
        ArrayList<CallSite> columns = new ArrayList<CallSite>();
        for (DBSEntityAttributeRef dBSEntityAttributeRef : pk.getAttributeReferences(monitor)) {
            columns.add((CallSite)((Object)("\"" + dBSEntityAttributeRef.getAttribute().getName() + "\"")));
        }
        return "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)exasolTable, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ADD CONSTRAINT " + DBUtils.getQuotedIdentifier((DBSObject)pk) + " PRIMARY KEY (" + CommonUtils.joinStrings((String)",", columns) + ") " + (pk.getEnabled() != false ? "ENABLE" : "DISABLE");
    }

    public static String getConnectionDdl(ExasolConnection con, DBRProgressMonitor monitor) throws DBException {
        Object userInfo = "";
        if (con.getUserName() != null) {
            userInfo = " USER '" + con.getUserName() + "' IDENTIFIED BY '<password>' ";
        }
        return "CREATE CONNECTION \"" + con.getName() + "\" to '" + con.getConnectionString() + "'" + (String)userInfo + ";";
    }

    private ExasolUtils() {
    }

    public static ExasolTable findTableBySchemaNameAndName(DBRProgressMonitor monitor, ExasolDataSource dataSource, String exasolSchemaName, String exasolTableName) throws DBException {
        ExasolSchema exasolSchema = dataSource.getSchema(monitor, exasolSchemaName);
        if (exasolSchema == null) {
            return null;
        }
        return exasolSchema.getTable(monitor, exasolTableName);
    }

    public static String generateDDLforSchema(DBRProgressMonitor monitor, ExasolSchema exasolSchema) {
        return "CREATE SCHEMA " + exasolSchema.getName() + ";\nALTER SCHEMA " + exasolSchema.getName() + " CHANGE OWNER " + exasolSchema.getOwner() + ";\n";
    }

    public static ExasolTableObjectType getTableObjectType(String objectType) {
        try {
            return ExasolTableObjectType.valueOf(objectType);
        }
        catch (Exception e) {
            log.error((Object)("Unsupported object table type: " + objectType));
            return ExasolTableObjectType.TABLE;
        }
    }
}

