/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.NamedObjectPatternFilter;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardActivator;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.utils.CommonUtils;

public class DashboardDatabaseSelectDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.DashboardDatabaseSelectDialog";
    private DBPNamedObject target;
    private TreeViewer treeViewer;

    public DashboardDatabaseSelectDialog(Shell shell) {
        super(shell, UIDashboardMessages.dialog_dashboard_database_select_title, null);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)UIDashboardActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        this.treeViewer = DialogUtils.createFilteredTree((Composite)dialogArea, (int)2048, (PatternFilter)new NamedObjectPatternFilter(), null);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 300;
        this.treeViewer.getControl().setLayoutData((Object)gd);
        this.treeViewer.getTree().setHeaderVisible(true);
        UIUtils.createTreeColumn((Tree)this.treeViewer.getTree(), (int)16384, (String)UIDashboardMessages.dialog_dashboard_database_select_column_name);
        UIUtils.createTreeColumn((Tree)this.treeViewer.getTree(), (int)16384, (String)UIDashboardMessages.dialog_dashboard_database_select_column_description);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider(this){

            public Object[] getChildren(Object parentElement) {
                List result = null;
                if (parentElement instanceof List) {
                    result = (List)parentElement;
                } else if (parentElement instanceof DBPDataSourceProviderDescriptor && (result = ((DBPDataSourceProviderDescriptor)parentElement).getEnabledDrivers()).size() <= 1) {
                    result = null;
                }
                if (result == null) {
                    return new Object[0];
                }
                result.sort(DBUtils.nameComparator());
                return result.toArray();
            }

            public boolean hasChildren(Object element) {
                if (element instanceof DBPDriver) {
                    return false;
                }
                return ((DBPDataSourceProviderDescriptor)element).getEnabledDrivers().size() > 1;
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(this){

            public void update(ViewerCell cell) {
                DBPNamedObject element = (DBPNamedObject)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    cell.setText(element.getName());
                    DBPImage icon = null;
                    if (element instanceof DBPDriver) {
                        icon = ((DBPDriver)element).getIcon();
                    } else if (element instanceof DBPDataSourceProviderDescriptor) {
                        icon = ((DBPDataSourceProviderDescriptor)element).getIcon();
                    }
                    if (icon != null) {
                        cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                    }
                } else if (element instanceof DBPDriver) {
                    cell.setText(CommonUtils.notEmpty((String)((DBPDriver)element).getDescription()));
                } else if (element instanceof DBPDataSourceProviderDescriptor) {
                    cell.setText(((DBPDataSourceProviderDescriptor)element).getDescription());
                }
            }
        });
        this.treeViewer.setInput((Object)DBWorkbench.getPlatform().getDataSourceProviderRegistry().getDataSourceProviders());
        this.treeViewer.addDoubleClickListener(event -> {
            if (this.target != null) {
                this.okPressed();
            }
        });
        this.treeViewer.addSelectionChangedListener(event -> {
            Object selectedObject;
            this.target = null;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (selectedObject = ((IStructuredSelection)selection).getFirstElement()) instanceof DBPNamedObject) {
                this.target = (DBPNamedObject)selectedObject;
            }
            this.updateButtons();
        });
        UIUtils.asyncExec(() -> {
            this.treeViewer.expandAll();
            UIUtils.packColumns((Tree)this.treeViewer.getTree(), (boolean)true, null);
        });
        return dialogArea;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.updateButtons();
        return contents;
    }

    private void updateButtons() {
        this.getButton(0).setEnabled(this.target != null);
    }

    public DBPNamedObject getTarget() {
        return this.target;
    }
}

