/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view.catalogpanel;

import java.util.List;
import java.util.function.Function;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFolder;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardProviderDescriptor;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistryListener;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardRendererDescriptor;
import org.jkiss.dbeaver.ui.dashboard.registry.DashboardUIRegistry;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardItemConfigurationTransfer;
import org.jkiss.dbeaver.ui.dashboard.view.catalogpanel.DashboardCatalogPanelTreeContentProvider;
import org.jkiss.utils.CommonUtils;

public abstract class DashboardCatalogPanel
extends Composite
implements DashboardRegistryListener {
    private static final Log log = Log.getLog(DashboardCatalogPanel.class);
    private final TreeViewer dashboardTable;
    private DashboardItemConfiguration selectedDashboard;
    @NotNull
    private final DBPProject project;
    @Nullable
    private final DBPDataSourceContainer dataSourceContainer;

    public DashboardCatalogPanel(@NotNull Composite parent, @NotNull DBPProject project, @Nullable DBPDataSourceContainer dataSourceContainer, @Nullable Function<DashboardItemConfiguration, Boolean> itemFilter, boolean isFlat) {
        super(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        if (isFlat) {
            layout.marginWidth = 0;
            layout.marginHeight = 0;
        }
        this.setLayout((Layout)layout);
        this.project = project;
        this.dataSourceContainer = dataSourceContainer;
        int style = 65536;
        if (!isFlat) {
            style |= 0x800;
        }
        this.dashboardTable = new TreeViewer((Composite)this, style);
        this.dashboardTable.getControl().setLayoutData((Object)new GridData(1808));
        Tree table = this.dashboardTable.getTree();
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        UIUtils.createTreeColumn((Tree)table, (int)16384, (String)UIDashboardMessages.dialog_add_dashboard_column_name);
        UIUtils.createTreeColumn((Tree)table, (int)16384, (String)UIDashboardMessages.dialog_add_dashboard_column_description);
        this.dashboardTable.setLabelProvider((IBaseLabelProvider)new CellLabelProvider(this){

            public void update(ViewerCell cell) {
                Object object = cell.getElement();
                if (object instanceof DashboardProviderDescriptor) {
                    DashboardProviderDescriptor dpd = (DashboardProviderDescriptor)object;
                    if (cell.getColumnIndex() == 0) {
                        cell.setText(dpd.getName());
                        cell.setImage(DBeaverIcons.getImage((DBPImage)dpd.getIcon()));
                    } else {
                        cell.setText(CommonUtils.notEmpty((String)dpd.getDescription()));
                    }
                } else {
                    object = cell.getElement();
                    if (object instanceof DBDashboardFolder) {
                        DBDashboardFolder folder = (DBDashboardFolder)object;
                        if (cell.getColumnIndex() == 0) {
                            cell.setText(folder.getName());
                            icon = folder.getIcon();
                            if (icon == null) {
                                icon = DBIcon.TREE_FOLDER;
                            }
                            cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                        } else {
                            cell.setText(CommonUtils.notEmpty((String)folder.getDescription()));
                        }
                    } else {
                        icon = cell.getElement();
                        if (icon instanceof DashboardItemConfiguration) {
                            DashboardItemConfiguration dashboardDescriptor = (DashboardItemConfiguration)icon;
                            if (cell.getColumnIndex() == 0) {
                                cell.setText(dashboardDescriptor.getName());
                                icon = null;
                                if (dashboardDescriptor.isCustom()) {
                                    icon = DBIcon.TYPE_OBJECT;
                                } else {
                                    DashboardRendererDescriptor viewType = DashboardUIRegistry.getInstance().getViewType(dashboardDescriptor.getDashboardRenderer());
                                    if (viewType != null) {
                                        icon = viewType.getIcon();
                                    }
                                }
                                if (icon != null) {
                                    cell.setImage(DBeaverIcons.getImage((DBPImage)icon));
                                }
                            } else {
                                cell.setText(CommonUtils.notEmpty((String)dashboardDescriptor.getDescription()));
                            }
                        }
                    }
                }
            }
        });
        this.dashboardTable.addDoubleClickListener(event -> {
            if (this.dashboardTable.getStructuredSelection().getFirstElement() instanceof DashboardItemConfiguration) {
                this.handleChartSelectedFinal();
            }
        });
        this.dashboardTable.addSelectionChangedListener(event -> {
            ISelection selection = this.dashboardTable.getSelection();
            if (selection instanceof IStructuredSelection) {
                DashboardItemConfiguration dd;
                IStructuredSelection ss = (IStructuredSelection)selection;
                Object patt0$temp = ss.getFirstElement();
                this.selectedDashboard = patt0$temp instanceof DashboardItemConfiguration ? (dd = (DashboardItemConfiguration)patt0$temp) : null;
            }
            this.handleChartSelected();
        });
        table.addPaintListener(e -> {
            if (table.getItemCount() == 0) {
                String dbmsName = dataSourceContainer == null ? project.getName() : dataSourceContainer.getDriver().getName();
                String msg = NLS.bind((String)UIDashboardMessages.dialog_add_dashboard_message_no_more_dashboards_for, (Object)dbmsName);
                UIUtils.drawMessageOverControl((Control)table, (PaintEvent)e, (String)msg, (int)0);
            }
        });
        this.dashboardTable.setContentProvider((IContentProvider)new DashboardCatalogPanelTreeContentProvider(dataSourceContainer, project, itemFilter));
        this.refreshInput();
        if (isFlat) {
            DashboardCatalogPanel.addDragAndDropSupport(table);
        }
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)table, (boolean)true, null));
        DashboardRegistry.getInstance().addListener((DashboardRegistryListener)this);
        this.addDisposeListener(e -> DashboardRegistry.getInstance().removeListener((DashboardRegistryListener)this));
    }

    private void refreshInput() {
        List dbProviders = DashboardRegistry.getInstance().getDashboardProviders(this.dataSourceContainer);
        this.dashboardTable.setInput((Object)dbProviders);
        this.dashboardTable.expandToLevel(2);
    }

    private static void addDragAndDropSupport(final Tree table) {
        DragSource source = new DragSource((Control)table, 2);
        source.setTransfer(new Transfer[]{TextTransfer.getInstance(), DashboardItemConfigurationTransfer.INSTANCE});
        source.addDragListener(new DragSourceListener(){
            private TreeItem dragItem;
            private Image dragImage;

            public void dragStart(DragSourceEvent event) {
                Point point = table.toControl(table.getDisplay().getCursorLocation());
                this.dragItem = table.getItem(point);
                if (this.dragItem == null || !(this.dragItem.getData() instanceof DashboardItemConfiguration)) {
                    return;
                }
                Rectangle columnBounds = this.dragItem.getBounds();
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
                GC gc = new GC((Drawable)table);
                this.dragImage = new Image((Device)Display.getCurrent(), columnBounds.width, columnBounds.height);
                gc.copyArea(this.dragImage, columnBounds.x, columnBounds.y);
                event.image = this.dragImage;
                gc.dispose();
            }

            /*
             * Enabled aggressive block sorting
             */
            public void dragSetData(DragSourceEvent event) {
                Object object = this.dragItem.getData();
                if (object instanceof DashboardItemConfiguration) {
                    DashboardItemConfiguration dashboardDescriptor = (DashboardItemConfiguration)object;
                    if (DashboardItemConfigurationTransfer.INSTANCE.isSupportedType(event.dataType)) {
                        event.data = dashboardDescriptor;
                        return;
                    }
                }
                event.data = this.dragItem.getText();
            }

            public void dragFinished(DragSourceEvent event) {
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
            }
        });
    }

    @NotNull
    public DBPProject getProject() {
        return this.project;
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public DashboardItemConfiguration getSelectedDashboard() {
        return this.selectedDashboard;
    }

    protected abstract void handleChartSelected();

    protected abstract void handleChartSelectedFinal();

    public void handleItemCreate(@NotNull DashboardItemConfiguration item) {
        this.refreshInput();
    }

    public void handleItemDelete(@NotNull DashboardItemConfiguration item) {
        this.refreshInput();
    }
}

