/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.GherkinDialect;
import io.cucumber.gherkin.GherkinLineSpan;
import io.cucumber.gherkin.IGherkinLine;
import io.cucumber.gherkin.Location;
import io.cucumber.gherkin.Parser;
import io.cucumber.messages.types.StepKeywordType;
import java.util.List;

class Token {
    public final IGherkinLine line;
    public Parser.TokenType matchedType;
    public String matchedKeyword;
    public String matchedText;
    public List<GherkinLineSpan> matchedItems;
    public int matchedIndent;
    public GherkinDialect matchedGherkinDialect;
    public StepKeywordType keywordType;
    public Location location;

    public Token(IGherkinLine line, Location location) {
        this.line = line;
        this.location = location;
    }

    public boolean isEOF() {
        return this.line == null;
    }

    public void detach() {
        if (this.line != null) {
            this.line.detach();
        }
    }

    public String getTokenValue() {
        return this.isEOF() ? "EOF" : this.line.getLineText(-1);
    }

    public String toString() {
        return String.format("%s: %s/%s", new Object[]{this.matchedType, this.matchedKeyword, this.matchedText});
    }
}

