/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.ComboProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.link.mindmapmode.editor.ControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ControlGroupChangeListener;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.mindmapmode.MUIFactory;

public class FontSizeControlGroup
implements ControlGroup {
    private static final String NODE_FONT_SIZE = "nodefontsize";
    private BooleanProperty mSetNodeFontSize;
    private ComboProperty mNodeFontSize;
    private FontSizeChangeListener propertyChangeListener;
    private ConnectorModel connector;

    @Override
    public void updateValue(ConnectorModel connector) {
        this.connector = connector;
        this.propertyChangeListener.update();
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetNodeFontSize = new BooleanProperty("set_property_text");
        ArrayList<String> sizesVector = new ArrayList<String>(Arrays.asList(MUIFactory.FONT_SIZES));
        this.mNodeFontSize = new ComboProperty(NODE_FONT_SIZE, sizesVector, sizesVector);
        this.mNodeFontSize.setEditable(true);
        this.propertyChangeListener = new FontSizeChangeListener(this.mSetNodeFontSize, (IPropertyControl)this.mNodeFontSize);
        this.mSetNodeFontSize.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mNodeFontSize.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mSetNodeFontSize.appendToForm(formBuilder);
        this.mNodeFontSize.appendToForm(formBuilder);
    }

    private class FontSizeChangeListener
    extends ControlGroupChangeListener {
        public FontSizeChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, PropertyChangeEvent evt) {
            MLinkController linkController = (MLinkController)Controller.getCurrentModeController().getExtension(LinkController.class);
            try {
                linkController.setLabelFontSize(FontSizeControlGroup.this.connector, enabled ? Optional.of(Integer.valueOf(FontSizeControlGroup.this.mNodeFontSize.getValue())) : Optional.empty());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        void updateValue() {
            LinkController linkController = LinkController.getController();
            Optional fontSize = FontSizeControlGroup.this.connector.getLabelFontSize();
            Integer viewFontSize = linkController.getLabelFontSize(FontSizeControlGroup.this.connector);
            FontSizeControlGroup.this.mSetNodeFontSize.setValue(fontSize.isPresent());
            FontSizeControlGroup.this.mNodeFontSize.setValue(viewFontSize.toString());
        }
    }
}

