/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.propertymap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.infonode.properties.base.Property;
import net.infonode.properties.base.exception.InvalidPropertyException;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.ref.CompositeMapRef;
import net.infonode.properties.propertymap.ref.ParentMapRef;
import net.infonode.properties.propertymap.ref.PropertyMapPropertyRef;
import net.infonode.properties.propertymap.ref.PropertyMapRef;
import net.infonode.properties.propertymap.ref.ThisPropertyMapRef;
import net.infonode.properties.propertymap.value.PropertyRefValue;
import net.infonode.properties.propertymap.value.PropertyValue;
import net.infonode.properties.propertymap.value.ValueDecoder;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.properties.util.PropertyPath;
import net.infonode.util.Printer;
import net.infonode.util.Utils;
import net.infonode.util.ValueChange;
import net.infonode.util.collection.map.ConstVectorMap;
import net.infonode.util.collection.map.MapAdapter;
import net.infonode.util.collection.map.SingleValueMap;
import net.infonode.util.collection.map.base.ConstMap;
import net.infonode.util.collection.map.base.ConstMapIterator;
import net.infonode.util.collection.map.base.MapIterator;
import net.infonode.util.collection.notifymap.AbstractConstChangeNotifyMap;
import net.infonode.util.collection.notifymap.ChangeNotifyMapWrapper;
import net.infonode.util.collection.notifymap.ConstChangeNotifyMap;
import net.infonode.util.collection.notifymap.ConstChangeNotifyVectorMap;
import net.infonode.util.signal.Signal;
import net.infonode.util.signal.SignalListener;

public class PropertyMapImpl
implements PropertyMap {
    private static final int SERIALIZE_VERSION = 1;
    private PropertyMapGroup propertyGroup;
    private PropertyMapImpl parent;
    private PropertyMapProperty property;
    private ChangeNotifyMapWrapper values = new ChangeNotifyMapWrapper(new MapAdapter());
    private ConstChangeNotifyVectorMap superMap = new ConstChangeNotifyVectorMap();
    private ConstVectorMap vectorMap = new ConstVectorMap();
    private PropertyObjectMap map = new PropertyObjectMap();
    private ArrayList superMaps = new ArrayList(1);
    private MapAdapter childMaps = new MapAdapter();
    private HashMap propertyChangeListeners;
    private ArrayList listeners;
    private ArrayList treeListeners;
    private SignalListener mapListener;

    public PropertyMapImpl(PropertyMapGroup propertyGroup) {
        this(propertyGroup, null);
    }

    public PropertyMapImpl(PropertyMapImpl inheritFrom) {
        this(inheritFrom.getPropertyGroup(), inheritFrom);
    }

    public PropertyMapImpl(PropertyMapGroup propertyGroup, PropertyMapImpl superObject) {
        this(propertyGroup, null, null);
        if (superObject != null) {
            this.addSuperMap(superObject);
        }
    }

    public PropertyMapImpl(PropertyMapImpl parent, PropertyMapProperty property) {
        this(property.getPropertyMapGroup(), parent, property);
    }

    public PropertyMapImpl(PropertyMapGroup propertyGroup, PropertyMapImpl parent, PropertyMapProperty property) {
        this.parent = parent;
        this.property = property;
        this.propertyGroup = propertyGroup;
        Property[] properties = this.propertyGroup.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (properties[i] instanceof PropertyMapProperty) {
                PropertyMapProperty p = (PropertyMapProperty)properties[i];
                PropertyMapImpl propertyObject = new PropertyMapImpl(this, p);
                this.childMaps.put(p, propertyObject);
            }
            ++i;
        }
        this.vectorMap.addMap(this.values);
        this.vectorMap.addMap(this.superMap);
    }

    private boolean hasTreeListener() {
        return this.treeListeners != null && this.treeListeners.size() > 0 || this.parent != null && this.parent.hasTreeListener();
    }

    private boolean hasListener() {
        return this.hasTreeListener() || this.listeners != null && this.listeners.size() > 0 || this.propertyChangeListeners != null && this.propertyChangeListeners.size() > 0;
    }

    private void updateListenerRecursive() {
        this.updateListener();
        ConstMapIterator iterator = this.childMaps.constIterator();
        while (iterator.atEntry()) {
            ((PropertyMapImpl)iterator.getValue()).updateListenerRecursive();
            iterator.next();
        }
    }

    private void updateListener() {
        if (this.hasListener()) {
            if (this.mapListener == null) {
                this.mapListener = new SignalListener(){

                    @Override
                    public void signalEmitted(Signal signal, Object object) {
                        PropertyMapManager.getInstance().addMapChanges(PropertyMapImpl.this, (ConstMap)object);
                    }
                };
                this.map.getChangeSignal().add(this.mapListener);
            }
        } else if (this.mapListener != null) {
            this.map.getChangeSignal().remove(this.mapListener);
            this.mapListener = null;
            this.map.updateListeners();
        }
    }

    private boolean checkListeners(Set visited) {
        if (visited.contains(this)) {
            return false;
        }
        visited.add(this);
        return this.hasListener() || this.map.checkListeners(visited);
    }

    public ConstChangeNotifyMap getMap() {
        return this.map;
    }

    @Override
    public PropertyMap getSuperMap() {
        return this.superMaps.size() == 0 ? null : (PropertyMap)this.superMaps.get(0);
    }

    @Override
    public Object removeValue(Property property) throws InvalidPropertyException {
        this.checkProperty(property);
        PropertyValue value = (PropertyValue)this.values.get(property);
        if (value == null || value.getParent() != null) {
            return null;
        }
        this.values.remove(property);
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.firePropertyValueChanged(property, new ValueChange(value, this.getValue(property)));
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
        return value.get(this);
    }

    private PropertyMapRef getPathFrom(PropertyMapImpl parentObject) {
        if (this.parent == null) {
            return null;
        }
        if (this.parent == parentObject) {
            return new PropertyMapPropertyRef(this.property);
        }
        PropertyMapRef parentRef = this.parent.getPathFrom(parentObject);
        return parentRef == null ? null : new CompositeMapRef(parentRef, new PropertyMapPropertyRef(this.property));
    }

    private PropertyMapRef getRelativePathTo(PropertyMapImpl propertyObject) {
        ThisPropertyMapRef ref;
        PropertyMapRef propertyMapRef = ref = propertyObject == this ? ThisPropertyMapRef.INSTANCE : propertyObject.getPathFrom(this);
        return ref == null ? (this.parent == null ? null : new CompositeMapRef(ParentMapRef.INSTANCE, this.parent.getRelativePathTo(propertyObject))) : ref;
    }

    @Override
    public Object createRelativeRef(Property fromProperty, PropertyMap toObject, Property toProperty) {
        PropertyValue value = this.setValue(fromProperty, new PropertyRefValue(this, fromProperty, this.getRelativePathTo((PropertyMapImpl)toObject), toProperty, null));
        return value == null ? null : value.getWithDefault(this);
    }

    public int getSuperMapCount() {
        return this.superMaps.size();
    }

    @Override
    public void addSuperMap(PropertyMap superMap) {
        PropertyMapImpl superMapImpl = (PropertyMapImpl)superMap;
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.addSuperMap(0, superMapImpl);
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    @Override
    public PropertyMap removeSuperMap() {
        if (this.superMaps.size() > (this.parent == null ? 0 : this.parent.superMaps.size())) {
            PropertyMapImpl object = (PropertyMapImpl)this.superMaps.get(0);
            this.removeSuperMap(0);
            return object;
        }
        return null;
    }

    @Override
    public boolean removeSuperMap(PropertyMap superMap) {
        if (this.superMaps.size() > (this.parent == null ? 0 : this.parent.superMaps.size())) {
            int index = this.superMaps.indexOf(superMap);
            if (index == -1) {
                return false;
            }
            this.removeSuperMap(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean replaceSuperMap(PropertyMap oldSuperMap, PropertyMap newSuperMap) {
        if (oldSuperMap != newSuperMap && this.superMaps.size() > (this.parent == null ? 0 : this.parent.superMaps.size())) {
            int index = this.superMaps.indexOf(oldSuperMap);
            if (index == -1) {
                return false;
            }
            PropertyMapManager.getInstance().beginBatch();
            try {
                this.removeSuperMap(index);
                this.addSuperMap(index, (PropertyMapImpl)newSuperMap);
            }
            finally {
                PropertyMapManager.getInstance().endBatch();
            }
            return true;
        }
        return false;
    }

    private void removeParentSuperMap(int parentIndex) {
        this.removeSuperMap(this.superMaps.size() - this.parent.superMaps.size() - 1 + parentIndex);
    }

    private void removeSuperMap(int index) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.superMap.removeMap(index);
            this.superMaps.remove(index);
            ConstMapIterator iterator = this.childMaps.constIterator();
            while (iterator.atEntry()) {
                ((PropertyMapImpl)iterator.getValue()).removeParentSuperMap(index);
                iterator.next();
            }
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    private void addSuperMap(PropertyMapImpl propertyObjectImpl) {
        this.addSuperMap(0, propertyObjectImpl);
    }

    private void addParentSuperMap(PropertyMapImpl propertyObjectImpl, int parentIndex) {
        this.addSuperMap(this.superMaps.size() - this.parent.superMaps.size() + 1 + parentIndex, propertyObjectImpl);
    }

    private void addSuperMap(int index, PropertyMapImpl propertyObjectImpl) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.superMap.addMap(index, propertyObjectImpl.map);
            this.superMaps.add(index, propertyObjectImpl);
            ConstMapIterator iterator = this.childMaps.constIterator();
            while (iterator.atEntry()) {
                ((PropertyMapImpl)iterator.getValue()).addParentSuperMap(propertyObjectImpl.getChildMapImpl((PropertyMapProperty)iterator.getKey()), index);
                iterator.next();
            }
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    @Override
    public void addTreeListener(PropertyMapTreeListener listener) {
        if (this.treeListeners == null) {
            this.treeListeners = new ArrayList(2);
        }
        this.treeListeners.add(listener);
        this.updateListenerRecursive();
    }

    @Override
    public void removeTreeListener(PropertyMapTreeListener listener) {
        if (this.treeListeners != null) {
            this.treeListeners.remove(listener);
            if (this.treeListeners.size() == 0) {
                this.treeListeners = null;
            }
            this.updateListenerRecursive();
        }
    }

    @Override
    public void addListener(PropertyMapListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(listener);
        this.updateListener();
    }

    @Override
    public void removeListener(PropertyMapListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
        this.updateListener();
    }

    public PropertyMapGroup getPropertyGroup() {
        return this.propertyGroup;
    }

    @Override
    public void addPropertyChangeListener(Property property, PropertyChangeListener listener) {
        ArrayList<PropertyChangeListener> list;
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new HashMap(4);
        }
        if ((list = (ArrayList<PropertyChangeListener>)this.propertyChangeListeners.get(property)) == null) {
            list = new ArrayList<PropertyChangeListener>(2);
            this.propertyChangeListeners.put(property, list);
        }
        list.add(listener);
        this.updateListener();
    }

    @Override
    public void removePropertyChangeListener(Property property, PropertyChangeListener listener) {
        if (this.propertyChangeListeners != null) {
            ArrayList list = (ArrayList)this.propertyChangeListeners.get(property);
            if (list == null) {
                return;
            }
            list.remove(listener);
            if (list.isEmpty()) {
                this.propertyChangeListeners.remove(property);
                if (this.propertyChangeListeners.isEmpty()) {
                    this.propertyChangeListeners = null;
                }
            }
            this.updateListener();
        }
    }

    public PropertyMapImpl getParent() {
        return this.parent;
    }

    public PropertyMapProperty getProperty() {
        return this.property;
    }

    private void checkProperty(Property property) {
        if (!this.propertyGroup.hasProperty(property)) {
            throw new InvalidPropertyException(property, "Property '" + property + "' not found in object '" + this.propertyGroup + "'!");
        }
    }

    public PropertyMap getChildMap(PropertyMapProperty property) {
        return this.getChildMapImpl(property);
    }

    public PropertyMapImpl getChildMapImpl(PropertyMapProperty property) {
        this.checkProperty(property);
        return (PropertyMapImpl)this.childMaps.get(property);
    }

    private PropertyValue getParentDefaultValue(PropertyPath path) {
        PropertyValue value = this.parent == null ? null : this.parent.getParentDefaultValue(new PropertyPath(this.property, path));
        return value == null ? ((PropertyMapImpl)this.propertyGroup.getDefaultMap()).getValue(path) : value;
    }

    public PropertyValue getValueWithDefault(Property property) {
        PropertyValue value = this.getValue(property);
        return value == null ? this.getParentDefaultValue(new PropertyPath(property)) : value;
    }

    private PropertyValue getValue(PropertyPath propertyPath) {
        return propertyPath.getTail() == null ? this.getValue(propertyPath.getProperty()) : this.getChildMapImpl((PropertyMapProperty)propertyPath.getProperty()).getValue(propertyPath.getTail());
    }

    public PropertyValue getValue(Property property) {
        this.checkProperty(property);
        return (PropertyValue)this.map.get(property);
    }

    private PropertyValue internalSetValue(Property property, PropertyValue value) {
        PropertyValue oldValue = (PropertyValue)(value == null ? this.values.remove(property) : this.values.put(property, value));
        if (value != null) {
            value.updateListener(this.hasListener());
        }
        if (oldValue != null) {
            oldValue.unset();
        }
        return oldValue;
    }

    public PropertyValue setValue(Property property, PropertyValue value) {
        this.checkProperty(property);
        PropertyValue oldValue = this.getValue(property);
        this.internalSetValue(property, value);
        if (!Utils.equals(value, oldValue)) {
            PropertyMapManager.getInstance().beginBatch();
            try {
                this.firePropertyValueChanged(property, new ValueChange(oldValue, value));
            }
            finally {
                PropertyMapManager.getInstance().endBatch();
            }
        }
        return oldValue;
    }

    public boolean valueIsSet(Property property) {
        PropertyValue value = (PropertyValue)this.values.get(property);
        return value != null && value.getParent() == null;
    }

    public void firePropertyValueChanged(Property property, ValueChange change) {
        this.map.fireEntriesChanged(new SingleValueMap(property, change));
    }

    protected void firePropertyTreeValuesChanged(Map changes) {
        if (this.treeListeners != null) {
            PropertyMapTreeListener[] l = this.treeListeners.toArray(new PropertyMapTreeListener[this.treeListeners.size()]);
            int i = 0;
            while (i < l.length) {
                l[i].propertyValuesChanged(changes);
                ++i;
            }
        }
    }

    void firePropertyValuesChanged(Map changes) {
        if (this.listeners != null) {
            PropertyMapListener[] l = this.listeners.toArray(new PropertyMapListener[this.listeners.size()]);
            int i = 0;
            while (i < l.length) {
                l[i].propertyValuesChanged(this, changes);
                ++i;
            }
        }
        if (this.propertyChangeListeners != null) {
            for (Map.Entry entry : changes.entrySet()) {
                ArrayList list = (ArrayList)this.propertyChangeListeners.get(entry.getKey());
                if (list == null) continue;
                ValueChange vc = (ValueChange)entry.getValue();
                PropertyChangeListener[] l = list.toArray(new PropertyChangeListener[list.size()]);
                int i = 0;
                while (i < l.length) {
                    l[i].propertyChanged((Property)entry.getKey(), this, vc.getOldValue(), vc.getNewValue());
                    ++i;
                }
            }
        }
    }

    public void dump() {
        this.dump(new Printer(), new HashSet(4));
    }

    public void dump(Printer printer, Set printed) {
        printed.add(this);
        ConstMapIterator iterator = this.values.constIterator();
        while (iterator.atEntry()) {
            printer.println(iterator.getKey() + " = " + iterator.getValue());
            iterator.next();
        }
        if (!this.values.isEmpty()) {
            printer.println();
        }
        int i = 0;
        while (i < this.superMaps.size()) {
            printer.println("Super Object " + (i + 1) + ':');
            printer.beginSection();
            ((PropertyMapImpl)this.superMaps.get(i)).dump(printer, printed);
            printer.endSection();
            printer.println();
            ++i;
        }
        iterator = this.childMaps.constIterator();
        while (iterator.atEntry()) {
            printer.println(iterator.getKey() + ":");
            printer.beginSection();
            ((PropertyMapImpl)iterator.getValue()).dump(printer, printed);
            printer.endSection();
            printer.println();
            iterator.next();
        }
    }

    public void dumpSuperMaps(Printer printer) {
        printer.println(String.valueOf(System.identityHashCode(this)) + ":" + this);
        int i = 0;
        while (i < this.superMaps.size()) {
            printer.beginSection();
            ((PropertyMapImpl)this.superMaps.get(i)).dumpSuperMaps(printer);
            printer.endSection();
            ++i;
        }
    }

    @Override
    public void clear(boolean recursive) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.doClear(recursive);
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    private void doClear(boolean recursive) {
        ArrayList<Object> items = new ArrayList<Object>(10);
        MapIterator iterator = this.values.iterator();
        while (iterator.atEntry()) {
            PropertyValue value = (PropertyValue)iterator.getValue();
            if (value.getParent() == null) {
                items.add(iterator.getKey());
            }
            iterator.next();
        }
        int i = 0;
        while (i < items.size()) {
            this.removeValue((Property)items.get(i));
            ++i;
        }
        if (recursive) {
            ConstMapIterator iterator2 = this.childMaps.constIterator();
            while (iterator2.atEntry()) {
                ((PropertyMapImpl)iterator2.getValue()).doClear(recursive);
                iterator2.next();
            }
        }
    }

    @Override
    public boolean isEmpty(boolean recursive) {
        ConstMapIterator iterator = this.values.constIterator();
        while (iterator.atEntry()) {
            PropertyValue value = (PropertyValue)iterator.getValue();
            if (value.getParent() == null) {
                return false;
            }
            iterator.next();
        }
        if (recursive) {
            iterator = this.childMaps.constIterator();
            while (iterator.atEntry()) {
                if (!((PropertyMapImpl)iterator.getValue()).isEmpty(recursive)) {
                    return false;
                }
                iterator.next();
            }
        }
        return true;
    }

    private void doRead(ObjectInputStream in) throws IOException {
        while (in.readBoolean()) {
            String propertyName = in.readUTF();
            Property property = this.getPropertyGroup().getProperty(propertyName);
            PropertyValue value = ValueDecoder.decode(in, this, property);
            if (property == null || value == null) continue;
            this.setValue(property, value);
        }
        while (in.readBoolean()) {
            PropertyMapProperty property = (PropertyMapProperty)this.getPropertyGroup().getProperty(in.readUTF());
            this.getChildMapImpl(property).doRead(in);
        }
    }

    @Override
    public void write(ObjectOutputStream out, boolean recursive) throws IOException {
        out.writeInt(1);
        this.doWrite(out, recursive);
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        this.write(out, true);
    }

    private void doWrite(ObjectOutputStream out, boolean recursive) throws IOException {
        ConstMapIterator iterator = this.values.constIterator();
        while (iterator.atEntry()) {
            PropertyValue value = (PropertyValue)iterator.getValue();
            if (value.getParent() == null && value.isSerializable()) {
                out.writeBoolean(true);
                out.writeUTF(((Property)iterator.getKey()).getName());
                value.write(out);
            }
            iterator.next();
        }
        out.writeBoolean(false);
        if (recursive) {
            iterator = this.childMaps.constIterator();
            while (iterator.atEntry()) {
                if (!((PropertyMapImpl)iterator.getValue()).isEmpty(true)) {
                    out.writeBoolean(true);
                    out.writeUTF(((Property)iterator.getKey()).getName());
                    ((PropertyMapImpl)iterator.getValue()).doWrite(out, recursive);
                }
                iterator.next();
            }
        }
        out.writeBoolean(false);
    }

    @Override
    public void read(ObjectInputStream in) throws IOException {
        PropertyMapManager.getInstance().beginBatch();
        try {
            int version = in.readInt();
            if (version > 1) {
                throw new IOException("Can't read object because serialized version is newer than current version!");
            }
            this.doRead(in);
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    public static void skip(ObjectInputStream in) throws IOException {
        int version = in.readInt();
        if (version > 1) {
            throw new IOException("Can't read object because serialized version is newer than current version!");
        }
        PropertyMapImpl.doSkip(in);
    }

    private static void doSkip(ObjectInputStream in) throws IOException {
        while (in.readBoolean()) {
            in.readUTF();
            ValueDecoder.skip(in);
        }
        while (in.readBoolean()) {
            in.readUTF();
            PropertyMapImpl.doSkip(in);
        }
    }

    private boolean doValuesEqual(PropertyMapImpl propertyObject, boolean recursive) {
        Property property;
        ConstMapIterator iterator = this.map.constIterator();
        while (iterator.atEntry()) {
            property = (Property)iterator.getKey();
            if (!Utils.equals(((PropertyValue)iterator.getValue()).get(this), propertyObject.getValue(property).get(this))) {
                return false;
            }
            iterator.next();
        }
        if (recursive) {
            iterator = this.childMaps.constIterator();
            while (iterator.atEntry()) {
                property = (PropertyMapProperty)iterator.getKey();
                if (!((PropertyMapImpl)iterator.getValue()).doValuesEqual(propertyObject.getChildMapImpl((PropertyMapProperty)property), recursive)) {
                    return false;
                }
                iterator.next();
            }
        }
        return true;
    }

    @Override
    public boolean valuesEqualTo(PropertyMap propertyObject, boolean recursive) {
        return this.doValuesEqual((PropertyMapImpl)propertyObject, recursive);
    }

    @Override
    public PropertyMap copy(boolean copySuperMaps, boolean recursive) {
        PropertyMapImpl map = new PropertyMapImpl(this.propertyGroup);
        this.doCopy(map, copySuperMaps, recursive, true);
        return map;
    }

    private void doCopy(PropertyMapImpl map, boolean copySuperMaps, boolean recursive, boolean topMap) {
        ConstMapIterator iterator = this.values.constIterator();
        while (iterator.atEntry()) {
            PropertyValue value = (PropertyValue)iterator.getValue();
            if (value.getParent() == null) {
                map.values.put(iterator.getKey(), value.copyTo(map));
            }
            iterator.next();
        }
        if (copySuperMaps) {
            int i = 0;
            while (i < (topMap ? this.superMaps.size() : this.superMaps.size() - this.parent.superMaps.size())) {
                map.addSuperMap((PropertyMapImpl)this.superMaps.get(i));
                ++i;
            }
        }
        if (recursive) {
            iterator = this.childMaps.constIterator();
            while (iterator.atEntry()) {
                ((PropertyMapImpl)iterator.getValue()).doCopy((PropertyMapImpl)map.getChildMap((PropertyMapProperty)iterator.getKey()), copySuperMaps, recursive, false);
                iterator.next();
            }
        }
    }

    private class PropertyObjectMap
    extends AbstractConstChangeNotifyMap
    implements SignalListener {
        private boolean listenerActive;

        PropertyObjectMap() {
        }

        @Override
        protected void listenerAdded() {
            if (!this.listenerActive) {
                this.listenerActive = true;
                this.addInheritedReferences();
                PropertyMapImpl.this.superMap.getChangeSignal().add(this);
            }
        }

        @Override
        public void signalEmitted(Signal signal, Object object) {
            ConstMap changes = (ConstMap)object;
            MapAdapter m = new MapAdapter();
            ConstMapIterator iterator = changes.constIterator();
            while (iterator.atEntry()) {
                PropertyValue currentValue;
                Property property = (Property)iterator.getKey();
                if (PropertyMapImpl.this.propertyGroup.hasProperty(property) && ((currentValue = (PropertyValue)PropertyMapImpl.this.values.get(property)) == null || currentValue.getParent() != null)) {
                    ValueChange vc = (ValueChange)iterator.getValue();
                    PropertyValue superValue = (PropertyValue)vc.getNewValue();
                    PropertyValue newValue = superValue == null ? null : superValue.getSubValue(PropertyMapImpl.this);
                    PropertyMapImpl.this.internalSetValue(property, newValue);
                    m.put(property, new ValueChange(currentValue != null ? currentValue : vc.getOldValue(), newValue != null ? newValue : vc.getNewValue()));
                }
                iterator.next();
            }
            if (!m.isEmpty()) {
                this.fireEntriesChanged(m);
            }
        }

        @Override
        protected void lastListenerRemoved() {
            if (this.listenerActive) {
                this.listenerActive = false;
                PropertyMapImpl.this.superMap.getChangeSignal().remove(this);
                this.removeInheritedReferences();
            }
        }

        public boolean checkListeners(Set visited) {
            Iterator it = this.getChangeSignalInternal().iterator();
            while (it.hasNext()) {
                PropertyRefValue v;
                Object l = it.next();
                if (!(l instanceof PropertyRefValue) || !(v = (PropertyRefValue)l).getMap().checkListeners(visited)) continue;
                return true;
            }
            return false;
        }

        public void updateListeners() {
            Iterator it = this.getChangeSignalInternal().iterator();
            while (it.hasNext()) {
                if (it.next() instanceof PropertyRefValue) continue;
                return;
            }
            it = this.getChangeSignalInternal().iterator();
            while (it.hasNext()) {
                PropertyRefValue v;
                Object l = it.next();
                if (!(l instanceof PropertyRefValue) || !(v = (PropertyRefValue)l).getMap().checkListeners(new HashSet())) continue;
                return;
            }
            this.lastListenerRemoved();
        }

        private void addInheritedReferences() {
            PropertyValue currentValue;
            Property property;
            ConstMapIterator iterator = PropertyMapImpl.this.values.constIterator();
            while (iterator.atEntry()) {
                property = (Property)iterator.getKey();
                currentValue = (PropertyValue)PropertyMapImpl.this.values.get(property);
                currentValue.updateListener(true);
                iterator.next();
            }
            iterator = PropertyMapImpl.this.superMap.constIterator();
            while (iterator.atEntry()) {
                property = (Property)iterator.getKey();
                if (PropertyMapImpl.this.propertyGroup.hasProperty(property) && ((currentValue = (PropertyValue)PropertyMapImpl.this.values.get(property)) == null || currentValue.getParent() != null)) {
                    PropertyValue superValue = (PropertyValue)iterator.getValue();
                    PropertyValue newValue = superValue == null ? null : superValue.getSubValue(PropertyMapImpl.this);
                    PropertyMapImpl.this.internalSetValue(property, newValue);
                }
                iterator.next();
            }
        }

        private void removeInheritedReferences() {
            ArrayList<Property> toBeRemoved = new ArrayList<Property>();
            ConstMapIterator iterator = PropertyMapImpl.this.values.constIterator();
            while (iterator.atEntry()) {
                Property property = (Property)iterator.getKey();
                PropertyValue currentValue = (PropertyValue)PropertyMapImpl.this.values.get(property);
                if (currentValue.getParent() != null) {
                    currentValue.unset();
                    toBeRemoved.add(property);
                } else {
                    currentValue.updateListener(false);
                }
                iterator.next();
            }
            int i = 0;
            while (i < toBeRemoved.size()) {
                PropertyMapImpl.this.values.remove(toBeRemoved.get(i));
                ++i;
            }
        }

        @Override
        public Object get(Object key) {
            return PropertyMapImpl.this.vectorMap.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return PropertyMapImpl.this.vectorMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return PropertyMapImpl.this.vectorMap.containsValue(value);
        }

        @Override
        public boolean isEmpty() {
            return PropertyMapImpl.this.vectorMap.isEmpty();
        }

        @Override
        public ConstMapIterator constIterator() {
            return PropertyMapImpl.this.vectorMap.constIterator();
        }

        @Override
        protected void fireEntriesChanged(ConstMap changes) {
            super.fireEntriesChanged(changes);
        }
    }
}

