/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.Timer;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;

public class DoAutomaticSave
implements ActionListener {
    private int changeState;
    private final boolean filesShouldBeDeletedAfterShutdown;
    private final MapModel model;
    private final int numberOfFiles;

    public DoAutomaticSave(MapModel model, int numberOfTempFiles, boolean filesShouldBeDeletedAfterShutdown) {
        this.model = model;
        this.numberOfFiles = numberOfTempFiles > 0 ? numberOfTempFiles : 1;
        this.filesShouldBeDeletedAfterShutdown = filesShouldBeDeletedAfterShutdown;
        this.changeState = model.getNumberOfChangesSinceLastSave();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        URL url = this.model.getURL();
        if (url == null) {
            return;
        }
        if (this.model.isReadOnly() || this.model.getNumberOfChangesSinceLastSave() == this.changeState) {
            return;
        }
        this.changeState = this.model.getNumberOfChangesSinceLastSave();
        if (this.changeState == 0) {
            return;
        }
        Timer timer = (Timer)e.getSource();
        timer.stop();
        try {
            ModeController currentModeController = Controller.getCurrentModeController();
            if (!(currentModeController instanceof MModeController)) {
                return;
            }
            UrlManager fileManager = UrlManager.getController();
            if (!(fileManager instanceof MFileManager)) {
                return;
            }
            MModeController modeController = (MModeController)currentModeController;
            File file = new File(url.getFile());
            File pathToStore = MFileManager.backupDir(url != null ? file : null);
            pathToStore.mkdirs();
            File tempFile = MFileManager.renameAutosaveFiles(pathToStore, file, this.numberOfFiles, this.filesShouldBeDeletedAfterShutdown);
            if (tempFile == null) {
                if (this.numberOfFiles > 0) {
                    LogUtils.severe((String)("Can't create automatic backup for " + file));
                }
                return;
            }
            if (this.filesShouldBeDeletedAfterShutdown) {
                tempFile.deleteOnExit();
            }
            if (ResourceController.getResourceController().getBooleanProperty("automatically_overwrite_mindmap_files")) {
                if (tempFile.isFile() && tempFile.canWrite()) {
                    tempFile.delete();
                }
                if (file.renameTo(tempFile)) {
                    ((MFileManager)fileManager).save(this.model);
                    this.outputStatusMessageAfterAutomaticSave(modeController, this.model.getFile());
                } else {
                    LogUtils.severe((String)("Can't create automatic backup for " + file));
                }
            } else if (tempFile.isFile() && tempFile.canWrite() || !tempFile.exists() && tempFile.getParentFile().canWrite()) {
                ((MFileManager)fileManager).saveInternal((MMapModel)this.model, tempFile, true);
                this.outputStatusMessageAfterAutomaticSave(modeController, tempFile);
            } else if (this.numberOfFiles > 0) {
                LogUtils.severe((String)("Can't create automatic backup for " + file));
            }
        }
        catch (Exception ex) {
            LogUtils.severe((String)"Error in automatic MapModel.save(): ", (Throwable)ex);
        }
    }

    private void outputStatusMessageAfterAutomaticSave(MModeController modeController, File savedFile) {
        if (ResourceController.getResourceController().getBooleanProperty("outputs_status_message_after_automatic_save", true)) {
            modeController.getController().getViewController().out(TextUtils.format((String)"automatically_save_message", (Object[])new Object[]{savedFile}));
        }
    }
}

