/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.Serializable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class OpenContentBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ColorProvider topLeftLineColor;
    private final ColorProvider bottomRightLineColor;
    private final ColorProvider highlightColorProvider;
    private int tabLeftInset = 1;

    public OpenContentBorder(Color color, int tabLeftInset) {
        this(color);
        this.tabLeftInset = tabLeftInset;
    }

    public OpenContentBorder() {
        this(null);
    }

    public OpenContentBorder(Color color) {
        this(color, null);
    }

    public OpenContentBorder(Color color, Color highlightColor) {
        this(ColorProviderUtil.getColorProvider(color, UIManagerColorProvider.TABBED_PANE_DARK_SHADOW), highlightColor == null ? null : new FixedColorProvider(highlightColor), 1);
    }

    public OpenContentBorder(ColorProvider lineColor, ColorProvider highlightColorProvider, int tabLeftInset) {
        this(lineColor, lineColor, highlightColorProvider, tabLeftInset);
    }

    public OpenContentBorder(ColorProvider topLeftLineColor, ColorProvider bottomRightLineColor, ColorProvider highlightColorProvider, int tabLeftInset) {
        this.topLeftLineColor = topLeftLineColor;
        this.bottomRightLineColor = bottomRightLineColor;
        this.highlightColorProvider = highlightColorProvider;
        this.tabLeftInset = tabLeftInset;
    }

    private static int getLineIntersection(int edge, float x1, float y1, float x2, float y2, Direction orientation) {
        return orientation.isHorizontal() ? (x1 <= (float)edge && x2 >= (float)edge || x1 >= (float)edge && x2 <= (float)edge ? Math.round(x2 == x1 ? y2 : y1 + ((float)edge - x1) * (y2 - y1) / (x2 - x1)) : Integer.MAX_VALUE) : (y1 <= (float)edge && y2 >= (float)edge || y1 >= (float)edge && y2 <= (float)edge ? Math.round(y2 == y1 ? x2 : x1 + ((float)edge - y1) * (x2 - x1) / (y2 - y1)) : Integer.MAX_VALUE);
    }

    private static Point getTabBounds(Component c, Tab tab, Direction orientation, int x, int y, int width, int height) {
        Rectangle r = tab.getVisibleRect();
        r = SwingUtilities.convertRectangle(tab, r, c);
        int start = orientation.isHorizontal() ? Math.max(y, r.y) : Math.max(x, r.x);
        int end = start + (orientation.isHorizontal() ? r.height : r.width) - 1;
        Shape shape = tab.getShape();
        if (shape != null) {
            int edge = orientation == Direction.UP ? tab.getHeight() : (orientation == Direction.RIGHT ? -1 : (orientation == Direction.DOWN ? -1 : tab.getWidth()));
            float[] coords = new float[6];
            PathIterator it = shape.getPathIterator(null);
            it.currentSegment(coords);
            it.next();
            float x1 = coords[0];
            float y1 = coords[1];
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            while (!it.isDone()) {
                float lastX = coords[0];
                float lastY = coords[1];
                it.currentSegment(coords);
                int li = OpenContentBorder.getLineIntersection(edge, lastX, lastY, coords[0], coords[1], orientation);
                if (li != Integer.MAX_VALUE) {
                    if (li < min) {
                        min = li;
                    }
                    if (li > max) {
                        max = li;
                    }
                }
                it.next();
            }
            int li = OpenContentBorder.getLineIntersection(edge, coords[0], coords[1], x1, y1, orientation);
            if (li != Integer.MAX_VALUE) {
                if (li < min) {
                    min = li;
                }
                if (li > max) {
                    max = li;
                }
            }
            Point p0 = SwingUtilities.convertPoint(tab, 0, 0, c);
            if (orientation.isHorizontal()) {
                min += p0.y;
                max += p0.y;
            } else {
                min += p0.x;
                max += p0.x;
            }
            start = Math.max(start, min);
            end = Math.min(end, max);
        }
        return new Point(start, end);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        TabbedPanel tabbedPanel = TabbedUtils.getParentTabbedPanelContentPanel(c).getTabbedPanel();
        if (c != null && tabbedPanel != null) {
            Color hc1;
            Tab tab = tabbedPanel.getHighlightedTab();
            int tabStart = -1;
            int tabEnd = -1;
            int clipOffset = 0;
            Direction orientation = tabbedPanel.getProperties().getTabAreaOrientation();
            if (tab != null) {
                Point p = OpenContentBorder.getTabBounds(c, tab, orientation, x, y, width, height);
                tabStart = p.x;
                tabEnd = p.y;
                Rectangle visible = tab.getVisibleRect();
                int tabWidth = (int)visible.getWidth();
                int tabHeight = (int)visible.getHeight();
                clipOffset = (orientation.isHorizontal() ? tab.getHeight() > tabHeight : tab.getWidth() > tabWidth) ? -1 : 0;
            }
            Color topLeftColor = this.topLeftLineColor != null ? this.topLeftLineColor.getColor(c) : null;
            Color bottomRightColor = this.bottomRightLineColor != null ? this.bottomRightLineColor.getColor(c) : null;
            Color color = hc1 = this.highlightColorProvider == null ? null : this.highlightColorProvider.getColor(c);
            if (orientation == Direction.UP && tab != null) {
                if (topLeftColor != null) {
                    g.setColor(topLeftColor);
                    OpenContentBorder.drawLine(g, x, y, tabStart - 1 + this.tabLeftInset, y);
                    OpenContentBorder.drawLine(g, tabEnd - clipOffset, y, x + width - 1, y);
                }
                if (this.highlightColorProvider != null) {
                    g.setColor(hc1);
                    OpenContentBorder.drawLine(g, x + 1, y + 1, tabStart + this.tabLeftInset - 1, y + 1);
                    if (tabEnd > tabStart) {
                        OpenContentBorder.drawLine(g, tabStart + this.tabLeftInset, y, tabStart + this.tabLeftInset, y + 1);
                    }
                    OpenContentBorder.drawLine(g, tabEnd, y + 1, x + width - 3, y + 1);
                }
            } else {
                if (topLeftColor != null) {
                    g.setColor(topLeftColor);
                    OpenContentBorder.drawLine(g, x, y, x + width - 1, y);
                }
                if (this.highlightColorProvider != null) {
                    g.setColor(hc1);
                    OpenContentBorder.drawLine(g, x + 1, y + 1, x + width - (orientation == Direction.RIGHT && tabStart == 0 ? 1 : 3), y + 1);
                }
            }
            if (orientation == Direction.LEFT && tab != null) {
                if (topLeftColor != null) {
                    g.setColor(topLeftColor);
                    OpenContentBorder.drawLine(g, x, y + 1, x, tabStart - 1 + this.tabLeftInset);
                    OpenContentBorder.drawLine(g, x, tabEnd - clipOffset, x, y + height - 1);
                }
                if (this.highlightColorProvider != null) {
                    g.setColor(hc1);
                    OpenContentBorder.drawLine(g, x + 1, y + 2, x + 1, tabStart + this.tabLeftInset - 1);
                    if (tabEnd > tabStart) {
                        OpenContentBorder.drawLine(g, x, tabStart + this.tabLeftInset, x + 1, tabStart + this.tabLeftInset);
                    }
                    OpenContentBorder.drawLine(g, x + 1, tabEnd, x + 1, y + height - 3);
                }
            } else {
                if (topLeftColor != null) {
                    g.setColor(topLeftColor);
                    OpenContentBorder.drawLine(g, x, y + 1, x, y + height - 1);
                }
                if (this.highlightColorProvider != null) {
                    g.setColor(hc1);
                    OpenContentBorder.drawLine(g, x + 1, y + 2, x + 1, y + height - (orientation == Direction.DOWN && tabStart == 0 ? 1 : 3));
                }
            }
            if (bottomRightColor != null) {
                g.setColor(bottomRightColor);
                if (orientation == Direction.RIGHT && tab != null) {
                    OpenContentBorder.drawLine(g, x + width - 1, y + 1, x + width - 1, tabStart - 1 + this.tabLeftInset);
                    OpenContentBorder.drawLine(g, x + width - 1, tabEnd - clipOffset, x + width - 1, y + height - 1);
                } else {
                    OpenContentBorder.drawLine(g, x + width - 1, y + 1, x + width - 1, y + height - 1);
                }
                if (orientation == Direction.DOWN && tab != null) {
                    g.setColor(bottomRightColor);
                    OpenContentBorder.drawLine(g, x + 1, y + height - 1, tabStart - 1 + this.tabLeftInset, y + height - 1);
                    OpenContentBorder.drawLine(g, tabEnd - clipOffset, y + height - 1, x + width - 2, y + height - 1);
                } else {
                    OpenContentBorder.drawLine(g, x + 1, y + height - 1, x + width - 2, y + height - 1);
                }
            }
        }
    }

    private static void drawLine(Graphics graphics, int x1, int y1, int x2, int y2) {
        if (x2 < x1 || y2 < y1) {
            return;
        }
        GraphicsUtil.drawOptimizedLine(graphics, x1, y1, x2, y2);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int hInset = this.highlightColorProvider != null ? 1 : 0;
        int tlInset = (this.topLeftLineColor != null ? 1 : 0) + hInset;
        int brInset = this.bottomRightLineColor != null ? 1 : 0;
        return new Insets(tlInset, tlInset, brInset, brInset);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

