/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.TagReference;
import org.freeplane.features.icon.Tags;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.TextController;
import org.freeplane.plugin.ai.tools.content.ContentType;
import org.freeplane.plugin.ai.tools.content.ContentTypeConverter;
import org.freeplane.plugin.ai.tools.content.EditableAttribute;
import org.freeplane.plugin.ai.tools.content.EditableContent;
import org.freeplane.plugin.ai.tools.content.EditableContentField;
import org.freeplane.plugin.ai.tools.content.EditableContentRequest;
import org.freeplane.plugin.ai.tools.content.EditableIcon;
import org.freeplane.plugin.ai.tools.content.EditableTag;
import org.freeplane.plugin.ai.tools.content.EditableText;
import org.freeplane.plugin.ai.tools.content.IconDescriptionResolver;

public class EditableContentReader {
    private final TextController textController;
    private final IconDescriptionResolver iconDescriptionResolver;
    private final ContentTypeConverter contentTypeConverter;

    public EditableContentReader(TextController textController, IconDescriptionResolver iconDescriptionResolver, ContentTypeConverter contentTypeConverter) {
        this.textController = Objects.requireNonNull(textController, "textController");
        this.iconDescriptionResolver = Objects.requireNonNull(iconDescriptionResolver, "iconDescriptionResolver");
        this.contentTypeConverter = Objects.requireNonNull(contentTypeConverter, "contentTypeConverter");
    }

    public EditableContent readEditableContent(NodeModel nodeModel, EditableContentRequest request) {
        List<EditableIcon> editableIcons;
        if (nodeModel == null || request == null) {
            return null;
        }
        EditableText editableText = request.includesField(EditableContentField.TEXT) ? this.buildEditableTextForNodeText(nodeModel) : null;
        EditableText editableDetails = request.includesField(EditableContentField.DETAILS) ? this.buildEditableText(DetailModel.getDetailText((NodeModel)nodeModel), DetailModel.getDetailContentType((NodeModel)nodeModel), nodeModel, DetailModel.getDetail((NodeModel)nodeModel)) : null;
        EditableText editableNote = request.includesField(EditableContentField.NOTE) ? this.buildEditableText(NoteModel.getNoteText((NodeModel)nodeModel), NoteModel.getNoteContentType((NodeModel)nodeModel), nodeModel, NoteModel.getNote((NodeModel)nodeModel)) : null;
        List<EditableAttribute> editableAttributes = request.includesField(EditableContentField.ATTRIBUTES) ? this.buildEditableAttributes(nodeModel) : null;
        List<EditableTag> editableTags = request.includesField(EditableContentField.TAGS) ? this.buildEditableTags(nodeModel) : null;
        List<EditableIcon> list = editableIcons = request.includesField(EditableContentField.ICONS) ? this.buildEditableIcons(nodeModel) : null;
        if (editableText == null && editableDetails == null && editableNote == null && editableAttributes == null && editableTags == null && editableIcons == null) {
            return null;
        }
        return new EditableContent(editableText, editableDetails, editableNote, editableAttributes, editableTags, editableIcons);
    }

    private EditableText buildEditableTextForNodeText(NodeModel nodeModel) {
        ContentType contentType;
        boolean formulaDetected;
        Object rawObject = nodeModel.getUserObject();
        String rawValue = rawObject == null ? null : String.valueOf(rawObject);
        String transformedValue = null;
        if (rawObject != null) {
            String transformed = this.textController.getTransformedTextForClipboard(nodeModel, (Object)nodeModel, rawObject);
            transformedValue = transformed == null ? null : String.valueOf(transformed);
        }
        String plainValue = null;
        if (transformedValue != null) {
            plainValue = HtmlUtils.htmlToPlain(transformedValue);
        }
        boolean bl = formulaDetected = rawObject != null && this.textController.isFormula(rawObject);
        ContentType contentType2 = rawObject == null ? null : (contentType = formulaDetected ? ContentType.FORMULA : this.contentTypeConverter.toTextContentTypeForNode(this.textController.getNodeFormat(nodeModel), rawValue));
        Boolean isEditable = rawObject == null ? null : Boolean.valueOf(!formulaDetected);
        return new EditableText(rawValue, transformedValue, plainValue, contentType, isEditable);
    }

    private EditableText buildEditableText(Object rawObject, String freeplaneContentType, NodeModel nodeModel, Object nodeProperty) {
        ContentType contentType;
        String rawValue = rawObject == null ? null : String.valueOf(rawObject);
        String transformedValue = null;
        if (rawObject != null) {
            String transformed = this.textController.getTransformedTextForClipboard(nodeModel, nodeProperty, rawObject);
            transformedValue = transformed == null ? null : String.valueOf(transformed);
        }
        String plainValue = null;
        if (transformedValue != null) {
            plainValue = HtmlUtils.htmlToPlain(transformedValue);
        }
        boolean formulaDetected = rawObject != null && this.textController.isFormula(rawObject);
        ContentType contentType2 = contentType = rawObject == null ? null : this.contentTypeConverter.toContentType(freeplaneContentType, formulaDetected, rawValue);
        Boolean isEditable = rawObject == null ? null : Boolean.valueOf(!formulaDetected);
        return new EditableText(rawValue, transformedValue, plainValue, contentType, isEditable);
    }

    private List<EditableAttribute> buildEditableAttributes(NodeModel nodeModel) {
        NodeAttributeTableModel attributeTableModel = NodeAttributeTableModel.getModel((NodeModel)nodeModel);
        int rowCount = attributeTableModel.getRowCount();
        if (rowCount == 0) {
            return null;
        }
        ArrayList<EditableAttribute> attributes = new ArrayList<EditableAttribute>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            boolean formulaDetected;
            Attribute attribute = attributeTableModel.getAttribute(row);
            if (attribute == null) continue;
            String rawValue = Objects.toString(attribute.getValue(), null);
            String transformedValue = null;
            if (rawValue != null) {
                Object transformed = this.textController.getTransformedObjectNoFormattingNoThrow(nodeModel, (Object)attributeTableModel, (Object)rawValue);
                transformedValue = transformed == null ? null : String.valueOf(transformed);
            }
            String plainValue = null;
            if (transformedValue != null) {
                plainValue = HtmlUtils.htmlToPlain(transformedValue);
            }
            boolean bl = formulaDetected = rawValue != null && this.textController.isFormula((Object)rawValue);
            Boolean isEditable = rawValue == null ? null : Boolean.valueOf(!formulaDetected);
            attributes.add(new EditableAttribute(attribute.getName(), rawValue, transformedValue, plainValue, isEditable, row));
        }
        return attributes.isEmpty() ? null : attributes;
    }

    private List<EditableTag> buildEditableTags(NodeModel nodeModel) {
        List tagReferences = Tags.getTagReferences((NodeModel)nodeModel);
        if (tagReferences == null || tagReferences.isEmpty()) {
            return null;
        }
        ArrayList<EditableTag> tags = new ArrayList<EditableTag>(tagReferences.size());
        for (int index = 0; index < tagReferences.size(); ++index) {
            TagReference reference = (TagReference)tagReferences.get(index);
            if (reference == null) continue;
            tags.add(new EditableTag(reference.getContent(), index));
        }
        return tags.isEmpty() ? null : tags;
    }

    private List<EditableIcon> buildEditableIcons(NodeModel nodeModel) {
        List icons = nodeModel.getIcons();
        if (icons.isEmpty()) {
            return null;
        }
        ArrayList<EditableIcon> editableIcons = new ArrayList<EditableIcon>(icons.size());
        for (int index = 0; index < icons.size(); ++index) {
            NamedIcon icon = (NamedIcon)icons.get(index);
            if (icon == null) continue;
            editableIcons.add(new EditableIcon(this.iconDescriptionResolver.resolveDescription(icon), index));
        }
        return editableIcons.isEmpty() ? null : editableIcons;
    }
}

