---
stage: Create
group: Code Review
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: マージリクエストのレビューを使用して、コードをプロジェクトにマージする前に、コードについて話し合い、改善します。
title: 'チュートリアル: マージリクエストをレビューする'
---

マージリクエストのレビューは、高品質のコードベースのみがコードに組み込まれるようにするのに役立ちます。このチュートリアルでは、GitLabでマージリクエストをレビューする方法について説明します。これは、マージリクエスト自体の構造と、建設的で役立つフィードバックを提供するプロセスを説明するものです。チュートリアルの終わりまでに、マージリクエストを承認するか、またはさらに変更をリクエストする準備ができます。

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>概要については、[マージリクエストのレビュー](https://www.youtube.com/watch?v=2MayfXKpU08&list=PLFGfElNsQthYDx0A_FaNNfUm9NHsK6zED&index=183)をご覧ください。
<!-- Video published on 2023-04-29 -->

マージリクエストをレビューするには、次のようにします:

1. [マージリクエスト](#go-to-the-merge-request)に移動します
1. [マージリクエストの構造を理解する](#understand-the-structure-of-merge-requests)
1. [概要を把握する](#get-a-high-level-view-of-the-merge-request)
   1. [関連するイシューを確認](#check-related-issues)
   1. [サイドバーを確認](#check-the-sidebar)
   1. [コメントを確認](#check-the-comments)
1. [コードの変更点を読む](#read-the-code-changes)
   1. [概要を把握するために変更点をざっと見る](#skim-changes-for-an-overview)
   1. [各ファイルを詳細に調べる](#examine-each-file-in-depth)
   1. [コードをテストする](#test-the-code)
   1. [パイプラインを確認](#check-the-pipelines)
   1. [再レビューの考慮事項](#re-review-considerations)
   1. [全体像を考える](#think-about-the-big-picture)
1. [レビューを完了する](#finish-your-review)
   1. [レビューコメントを書く](#write-your-review-comments)
   1. [レビューを要約する](#summarize-your-review)
1. [クリーンアップタスクを実行](#perform-cleanup-tasks)

## マージリクエストに移動します {#go-to-the-merge-request}

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. 次のいずれかの操作を行います:
   - <kbd>Shift</kbd>+<kbd>r</kbd>を押して、**Review requests**（レビューリクエスト）ページに移動します。
   - 左側のサイドバーで、**マージリクエスト**（{{< icon name="merge-request" >}}）**Review requests**（レビューリクエスト）を選択します。
<!-- When the feature flag paneled_view is removed, refer only to the button icon -->

## マージリクエストの構造を理解する {#understand-the-structure-of-merge-requests}

マージリクエストには、4つのオプションを持つセカンダリメニューがあります。レビュー中、マージリクエストのこれらの領域を異なるタイミングで使用します:

![タイトル、リクエスタ、ステータスが選択された概要タブとともに表示され、コミット、パイプライン、変更タブが並んでいます](img/top_bar_v17_0.png)

- **概要**: マージリクエストの説明、現在のマージ可能性に関するレポート、コメント付きの**アクティビティー**領域、および詳細情報を含むサイドバー。
- **コミット**: このマージリクエストのコミットのリスト。最新のコミットが最初に表示されます。
- **パイプライン**: このマージリクエストのコンテンツに対して実行されるCI/CDパイプラインのリスト。
- **変更**: このマージリクエストで提案された変更の差分。削除、追加、変更されたコード行を示します。

**概要**タブのサイドバーには、マージリクエスト自体の重要なメタデータが含まれています。

## マージリクエストの概要を把握する {#get-a-high-level-view-of-the-merge-request}

コードレビューに飛び込む前に、マージリクエストを高いレベルで評価する必要があります。マージリクエストのコンテキストと目的、つまり何を実現しようとしているのか、そしてその理由を理解します。これらのニーズをあなたのスキルセットと比較しながら、以下の質問を自問してください:

1. マージリクエストの背景にあるストーリーは何ですか？思慮深いレビューを実行するために、この分野で十分なバックグラウンド知識がありますか？
1. どのような種類と深さのレビューがリクエストされていますか？たとえば、範囲が狭いバグの修正と詳細なアーキテクチャレビューでは、レビューに対する期待が大きく異なる可能性があります。
1. あなたはこの作業をレビューするのに適切な人ですか？必要なレビューの種類は、あなたのスキルと能力に合っていますか？

まず、マージリクエストの説明を見てください。それは、イシューにおける問題またはストーリーリクエストに対するソリューションであるはずです。

- 作成者は誰ですか？あなたはこの人の作業に精通していますか？あなたがこの人に詳しい場合、彼らは通常コードベースのどの部分を扱っていますか？後で、作成者の知識は、変更をどのように精査するかを判断するのに役立ちます。
- 目標は何ですか？説明を読んで、作成者の意図を理解してください。
- これはドラフトですか？ドラフトは、多くの場合、不完全または理論的なソリューションです。ドラフトのマージリクエストでは、完全に完了したマージリクエストとは異なるレベルの精査が必要になる場合があります。
- 問題をどのように再現できますか？説明には、問題の再現方法、変更のテスト方法、または新機能の試用方法が記載されていますか？あなたを案内するスクリーンショットは含まれていますか？

説明の下にあるマージリクエストウィジェットを調べて、この作業の現在のステータスを理解してください。この例は、承認がなく、まだドラフトモードであり、ディスカッションスレッドが開いているマージリクエストのマージウィジェットを示しています:

![承認の欠落、ドラフトモード、および開いているスレッドという3つの失敗したチェックで、ブロッカーのステータスを示すマージウィジェット](img/widget_v17_0.png)

- それはクロスリンクをイシューにしますか？他のイシューへのリンクについて、説明とマージウィジェットを確認してください。一部のマージリクエストは簡単ですが、一部では、対応するイシューを読んで、このマージリクエストがどのようにして実現したかを理解する必要があります。より複雑なマージリクエストは、完全な情報を含むイシューにさかのぼって指摘する必要があります。
- パイプラインのステータスはどうですか？パイプラインは緑色ですか？赤いパイプラインは問題を示しています。パイプラインが不完全またはキャンセルされている場合、まだ作業の完全なマージ可能性を評価できません。

### 関連するイシューを確認 {#check-related-issues}

関連するイシューが存在し、マージリクエストが十分に複雑で、より多くの情報が必要な場合は、イシューの説明をスキャンします。

- 問題と解決策は分離されていますか？イシューは問題を説明および調査し、マージリクエストはソリューションに焦点を当てる必要があります。
- マージリクエストの作成者はイシューに関与していますか？レビュープロセス全体を通して、誰が問題（または機能）の定義を支援したかを検討してください。理想的には、これらの人々もマージリクエストに関与しています。

### サイドバーを確認 {#check-the-sidebar}

- どのようなラベルが付いていますか？ラベルは、マージリクエストのコンテンツへの手がかりを提供できます。チームのワークフローによっては、不完全または欠落しているラベルは無害であるか、またはこのマージリクエストに完全な情報が不足していることを示している可能性があります。
  - ラベルがあなたの専門分野と一致する場合、あなたはこのマージリクエストをレビューするのに適した候補者である可能性が高くなります。
  - ラベルがあなたの専門分野と一致しない場合は、マージリクエストを別のレビュアーに再割り当てする必要があるかもしれません。
  - あなたのワークフローが予期するラベルを追加します。

  この例では、正確なラベルに精通していなくても、このマージリクエストがデータベースのバグに関するものであると判断できます:

  ![「database」や「type: bug」など、さまざまな色の10個のラベルを表示するマージリクエストのラベルセクション](img/labels_v17_0.png)

- レビュアーは誰ですか？レビュアーリストの名前をスキャンします。説明と（オプションで）ラベルに基づいて、期待する作業の種類と一致していますか？誰が存在し、誰が不在であるかを検討してください。これらの名前は、このマージリクエストがレビューサイクルのどこにあるかを教えてくれますか？誰かを追加または削除する必要がありますか？
- すでに承認したレビュアーはいますか？これらのレビュアーとその専門分野を知っている場合は、提案された変更のどの側面があなたの注意を必要としているかをある程度知ることができます。

  この例では、ThomasとNickの両方がレビュアーです。Thomasはまだマージリクエストをレビューしていません（{{< icon name="dotted-circle" >}}）。Nickはレビューして承認しました（{{< icon name="check-circle" >}}）:

  ![2人のレビュアーをリストするマージリクエストのレビュアーセクション](img/reviewer_list_v17_0.png)

### コメントを確認 {#check-the-comments}

**概要**ページで、作成者や他の人が残したコメントを読みます。コードの変更を読むときは、それらのディスカッションを念頭に置いてください。

コメントに以前のレビューの証拠が表示されますか？多数のコメントは、この作業をどれだけ深くレビューしたいかに影響を与える可能性があります。

## コードの変更点を読む {#read-the-code-changes}

これで、提案された変更を読む準備ができました。大規模なマージリクエストの場合は、飛び込む前に変更点をざっと見てください。コード行ごとに変更を読み始める前に、何を期待するかを理解してください。

{{< alert type="note" >}}

**変更**タブに表示される差分には、情報が密集しています。このページを最大限に活用する方法については、[マージリクエストの変更](../../user/project/merge_requests/changes.md)を参照してください。

{{< /alert >}}

### 概要を把握するために変更点をざっと見る {#skim-changes-for-an-overview}

最初に**変更**ページを開くときは、まずより広範な詳細に焦点を当ててください:

- **What files have changed**（どのファイルが変更されましたか）？ファイルブラウザ（{{< icon name="file-tree" >}}）を展開して、変更されたファイルのリストを表示します。これらのファイルに精通していますか？これらのファイルはコードベースのどの部分にありますか？

  ![場所とコード行の変更インジケーターを示す2つの変更されたファイルを表示するファイルブラウザ](img/file_tree_v17_0.png)

- ファイルリストはあなたの期待と一致しますか？すでにマージリクエストの説明を読んでいます。これらのファイルは、この種の作業で変更されることが予想されるファイルですか？予期しないファイルへの変更、または表示されると予想される変更がない場合は、特に注意してください。
- コード行が追加、削除、または変更されましたか？これらの数値は、より深く読むときにどのような種類の作業を期待するかを示しています。新しい機能、削除された機能、または動作の変更ですか？
- テストは変更されましたか？ファイルはテストスイートの一部ですか？そうでない場合は、作成者にテストの更新を促す必要があるかもしれません。
- 機能フラグは使用されていますか？機能フラグが表示された場合は、詳細な読み取りでそれらの使用状況を確認するためのメモを作成してください。

変更のざっと見が終わったら、コード行ごとに変更を読む準備ができています！

### 各ファイルを詳細に調べる {#examine-each-file-in-depth}

これで、このマージリクエストに含まれる変更の概要がわかりました。飛び込んで変更を完全に読む時が来ました。あなたの知識がどこで強く、どこが弱いかを常に意識してください。このプロジェクトをよく知っていますか？変更は、あなたが快適に作業できる言語で書かれていますか？

- 変更は明確で理解できますか？
- 機能フラグは使用されていますか？変更は、機能フラグの有無をテストしますか？機能フラグがブロックされている場合、機能フラグ付きの変更が誤って漏洩しないようにしてください。
- パフォーマンスは良いですか？自分自身でパフォーマンスをテストすることに慣れていますか？それとも、より詳細なパフォーマンス知識を持つレビュアーを追加する必要がありますか？
- 簡略化できますか？
- エッジケースを考慮に入れていますか？
- コメントとドキュメントは正しく書かれていますか？優れたコードは、作成者だけでなく、他の人が保守性を維持できます。作成者は、この作業の保守性を維持するために十分な説明を提供しましたか？
- チームのスタイルの期待に従っていますか？
- 下位互換性はありますか？この作業は破壊的な変更ですか？データ損失を引き起こす可能性はありますか？
- セキュリティ上の懸念は解決されていますか？変更は、特別なセキュリティ上の懸念があるプロジェクトの領域にありますか？機密データを適切に処理しますか？ユーザー入力を受け入れますか？また、サニタイズされていますか？より多くのセキュリティ知識を持つレビュアーを追加する必要がありますか？
- デバッグステートメントは残っていますか？

変更の種類が異なると、コードベースに異なる影響があります。広義には、次のように考えてください:

- 追加されたコード行: 新しいコードは、既存の動作を変更すべきではありません。新しい動作はテストされていますか？テストは十分に詳細ですか？
- 削除されたコード行: 削除はクリーンで完了していますか？削除されたコードとテストのスコープは一致していますか？どちらの場所にも部分的なスタブが残っていないことを確認してください。
- 変更されたコード行: 追加および削除されたコード行がほぼ同じ場合、変更は既存のコードのリファクタリングですか？リファクタリングの場合、以前のコードが何をしたのか、新しいコードがそれをどのように異なる方法で行うのかを理解していますか？動作の変更は、説明における作成者の述べられた意図と一致しますか？テストはまだ正常に機能しますか？

### コードをテストする {#test-the-code}

残念ながら、ここではあまりガイダンスを提供できません。すべてのプロジェクトは異なります！あなたのアプリケーションを直接知らずに、変更をテストする方法をお伝えすることはできませんが、検討すべきいくつかの質問を提供できます:

- 動作可能？それは一見単純な質問ですが、心に留めておくことが重要です。コードは醜く、入り組んでいて、ドキュメント化されていなくても、それでも機能する可能性があります。
- レビュープロセスはどこまで進んでいますか？レビュープロセスの初期段階ですか、それとも後期段階ですか？あなたはスペシャリストですか？

  - プロセスの初期段階のレビュアーは、作成者が言うとおりにコードが動作することを検証する必要があります。これにより、マージできない、またはマージすべきでないコードに、多くの人が時間を費やすことを防ぎます。
  - プロセスの後半のレビュアーは、機能が宣伝どおりに動作することを保証することには関与せず、代わりにスタイルと保守性を重視する場合があります。
  - 専門のレビュアーは、マージリクエスト全体が期待どおりに動作するかどうかには対処せずに、マージリクエストの特定の部分のみをレビューする場合があります。

コードをテストしている間は、パイプラインのステータスも確認する必要があります。まだレビューコメントを記述していませんが、準備はほぼ完了です。

### パイプラインを確認する {#check-the-pipelines}

マージリクエストの**パイプライン**タブに移動し、パイプラインのステータスを確認します。パイプラインが成功した場合にのみ、マージリクエストを承認してください。この例では、複数のジョブが失敗しています:

![マージ結果パイプラインで成功したジョブと失敗したジョブを表示するパイプラインステータスウィジェット](img/failed_pipeline_v17_0.png)

- 期待されるテストはすべて実行されましたか？パイプラインが緑色であるだけでなく、完了していることを確認してください。
- テストが失敗しましたか？**失敗したジョブ**を展開して、失敗したテストがあるかどうかを確認します。
- 失敗した各ジョブで何が起こりましたか？失敗した各ジョブを選択します。出力をスクロールして、失敗、エラー、および赤でマークされたコード行に関する記述をスキャンします。レビューコメントを記述するときは、作成者が何を修正する必要があるか、およびその方法を理解できるようにする必要があります。
- その失敗は変更に関連していますか？その失敗が関係ないと思われる場合は、ジョブまたはパイプラインを再実行することを検討してください。

### 再レビューの考慮事項 {#re-review-considerations}

マージリクエストのレビューは単純ではなく、割り当て担当者とレビュアーの間でやり取りが必要になる場合があります。作業を再レビューする場合は、このマージリクエストの**コミット**ページに移動し、最後のレビュー後に追加されたコミットの内容を読み取ります。

これらのコミットは、最初のレビューでの懸念事項に対処していますか？

### 全体像を考える {#think-about-the-big-picture}

これで、思慮深く役立つレビューの準備作業が完了しました。最初にマージリクエストをざっと読んだとき、コード行レベルの変更を完全に把握していませんでした。今では把握しています。記述を開始する前に、マージリクエストのコード行ごとの表示から一歩離れて、もう一度大まかに考えてください。これで、マージリクエストが何をしようとしているのか、そしてそれをどのように行っているのかがわかりました。

- マージリクエストの変更は、意図されたスコープと一致していますか？そうでない場合は、作業を簡素化するか、複数のマージリクエストに分割する必要があるかどうかを自問してください。自分の知識のスコープと限界について正直になりましょう。
- [コードスメル](https://martinfowler.com/bliki/CodeSmell.html)を検出しますか？目にしているものがバグではなくても、将来の品質、保守性、またはセキュリティの問題を指摘している場合は、注意してください。変更について何かおかしい、不明瞭、または不十分に感じる場合は、自分の本能を信じてください。そのコードは技術的には正しいかもしれませんが、将来問題を引き起こす可能性のある弱点が含まれている可能性があります。

最高で最も役立つコードレビューは、コード行ごとの修正に焦点を当てているだけではありません。また、保守性や技術的負債など、長期的な懸念事項も考慮します。

## レビューを完了する {#finish-your-review}

フィードバックを提供する時が来ました。

マージリクエストのレビューに慣れていない場合は、最初のコメントを記述する前に、どれだけの時間を考えているかに驚くかもしれません。コードベースに慣れてくると、新しいマージリクエストをより速く理解できるようになります。ただし、より複雑なレビューにも取り組むようになるでしょう。

### レビューコメントを記述する {#write-your-review-comments}

**レビューを開始**機能を使用すると、考えを保留中のコメントに書き留めることができます。これらのコメントは、レビューを送信するまで他の人には表示されません。これにより、受信者へのメッセージのオーバーロードが回避され、公開する前に言葉を再確認（および変更）する機会が得られます。

建設的で親切であることを忘れないでください。[従来のコメント](https://conventionalcomments.org/)の構造は、思慮深く建設的なコメントを作成するのに役立ちます。

まず、特定のコード行またはファイルに添付するコメントを記述します:

1. **変更**タブを選択します。
1. 質問したいコード行を見つけた場合、またはフィードバックを提供するには、ガターで**この行にコメントを追加**（{{< icon name="comment" >}}）を選択します。これにより、差分行が展開され、コメントボックスが表示されます。
1. [複数行を選択](../../user/project/merge_requests/reviews/suggestions.md#multi-line-suggestions)するか、ファイル全体を選択してコメントすることもできます:

   ![1つまたは複数の行にコメントを追加するためのツールチップが表示された行番号の横に吹き出しボタンを表示するコード差分インターフェース](img/comment_on_any_diff_line_v16_6.png)

1. テキスト領域に、最初のコメントを記述します。レビューが完了するまでコメントを非公開にするには、コメントの下にある**レビューを開始**を選択します。
1. 修正のドラフトが簡単な場合、またはより良いアプローチを作成者に示したい場合は、[提案](../../user/project/merge_requests/reviews/suggestions.md)を行います。提案形式ではコードの変更が大きすぎるか複雑すぎる場合は、変更をリクエストするコメントを残してください。
1. ファイルと個々のコード行にコメントを追加し続けます。コメントごとに、**レビューに追加する**を選択します。

作業中に、[クイックアクション](../../user/project/quick_actions.md)（`/label`や`/assign_reviewer`など）をレビューコメントで使用できます。保留中のコメントには、リクエストされたアクションが表示されますが、レビューを送信するまでアクションは実行されません。（後で、`/submit_review`クイックアクションでレビューを送信することもできます。）

### レビューを要約する {#summarize-your-review}

ファイルとコード行に固有のフィードバックを追加したので、レビューを要約する準備ができました。最後にもう一度、大局的に考える時が来ました。

1. マージリクエストの**概要**ページに戻ります。
1. 保留中のコメントをスキャンします。それらは、役立ち、思慮深く、親切で、そして最も重要なこととして、実行可能である必要があります。見つけた問題を修正するための明白な次のステップを作成者に伝えましたか？
1. 口調を検討してください。教えていますか、議論していますか、それとも話し合っていますか？コメントは目標を達成していますか？自分が作成者だった場合、次に何をすべきかわかりますか？良い行動を強化し、悪い行動から作成者を遠ざけてください。
1. コメントはまだ意味がありますか？大規模なマージリクエストでは、一部のコメントが役に立たなくなったり、その間に質問に回答されたりする場合があります。
1. 一般化されたフィードバックのためにスレッドを開始します。無関係なアイテムが同じコメントにまとめられていないことを確認してください。これにより、スレッドが解決されるときに、未対処のフィードバックが非表示にならないようになります。可能性のあるトピックを次に示します:
   - 大きな関数を、より小さな単一目的の関数に分割します。
   - 意味のある変数名を使用します。
   - 複雑なコードを説明するために、さらにコメントを追加します。
   - エッジケースとエラーを確認します。
1. サマリ―コメントの新しいスレッドを開始します。作業をTo-Doアイテムから行う場合に備えて、作成者のユーザー名を必ず記載してください。明確に述べてください:
   - 全体的な調査結果は何ですか？
   - レビューを完了しましたか、それともさらに作業を行った後でこのマージリクエストをもう一度確認しますか？
1. 右上で**あなたのレビュー**を選択して、レビューに関する詳細を表示します:

   ![レビューの進行状況を示すレビュードロワー。これには、1行のレビューコメントと、コードの2行にまたがるコメントが含まれています。](../../user/project/merge_requests/reviews/img/review_drawer_v18_3.png)

1. 保留中のコメントをレビューします。必要に応じて編集します。
1. レビューの結果を選択します。

   - **承認する**: フィードバックを残して、変更を承認します。
   - **コメント**: 明示的な承認または変更リクエストなしで、一般的なフィードバックを残してください。
   - **変更の要求**: 作成者がフィードバックに対応するまで、マージリクエストがマージされないようにブロックします。

1. オプション。レビューのサマリ―コメントを記述します。GitLabプレミアムおよびUltimateプランのユーザー名は、**概要を追加する**（{{< icon name="tanuki-ai">}}）を選択して、サマリ―コメントを作成できます。実行するクイックアクションを含めます。

レビュー以外のコメントのテキストで、`/submit_review`[クイックアクション](../../user/project/quick_actions.md)を使用することもできます。

[マージリクエストを承認する](../../user/project/merge_requests/approvals/_index.md#approve-a-merge-request)と、レビュアーリストに表示され、緑色のチェックマーク{{< icon name="check-circle-filled" >}}が名前の横に表示されます。

## クリーンアップタスクを実行する {#perform-cleanup-tasks}

フィードバックを提供したら、整理します。

- 保留中のコメントがすべて送信されていることを確認してください。
- ラベルとマイルストーンを更新します。
- 承認要件を確認してください。
  - マージリクエスト内の各タイプの作業（バックエンド、フロントエンド、ドキュメント）が適切な人物によってレビューされているか？
  - さらにレビューが必要な場合は、次のレビュアーのユーザー名を記載し、それらをレビュアーとして追加します。
- マージウィジェットを確認してください。
  - 対処できるブロッカーに対処し、対処できないユーザー名を割り当てて支援を求めます。
  - レビューに必要なコードオーナーを追加します。
- このマージリクエストはマージする準備ができていますか？マージリクエストが完全にレビューされ、承認されている場合は、マージのためにメンテナーに割り当てます。

## 関連トピック {#related-topics}

- [従来のコメント](https://conventionalcomments.org/)は、コメントに役立つ構造を提供します。
- [効率的なコードレビューのヒント](https://about.gitlab.com/blog/2020/09/08/efficient-code-review-tips/)
