/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes.matching;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.jspecify.annotations.Nullable;

public interface AttributeSelectionSchema {
    public boolean hasAttribute(Attribute<?> var1);

    public <T> @Nullable Set<T> disambiguate(Attribute<T> var1, @Nullable T var2, Set<T> var3);

    public <T> boolean matchValue(Attribute<T> var1, T var2, T var3);

    default public <T> boolean weakMatchValue(Attribute<T> attribute, T requested, T candidate) {
        return this.matchValue(attribute, requested, candidate) || this.matchValue(attribute, candidate, requested);
    }

    default public Attribute<?> tryRehydrate(Attribute<?> attribute) {
        Attribute<?> typedAttribute = this.getAttribute(attribute.getName());
        if (typedAttribute == null) {
            return attribute;
        }
        return typedAttribute;
    }

    public @Nullable Attribute<?> getAttribute(String var1);

    public Attribute<?>[] collectExtraAttributes(ImmutableAttributes[] var1, ImmutableAttributes var2);

    public PrecedenceResult orderByPrecedence(Collection<Attribute<?>> var1);

    public static class PrecedenceResult {
        private final List<Integer> sortedIndices;
        private final Collection<Integer> unsortedIndices;

        public PrecedenceResult(List<Integer> sortedIndices, Collection<Integer> unsortedIndices) {
            this.sortedIndices = sortedIndices;
            this.unsortedIndices = unsortedIndices;
        }

        public PrecedenceResult(Collection<Integer> unsortedIndices) {
            this(Collections.emptyList(), unsortedIndices);
        }

        public List<Integer> getSortedOrder() {
            return this.sortedIndices;
        }

        public Collection<Integer> getUnsortedOrder() {
            return this.unsortedIndices;
        }
    }
}

