/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.NativeIntegration;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.ThreadSafe;
import net.rubygrapefruit.platform.internal.NativeLibraryLoader;
import net.rubygrapefruit.platform.internal.NativeLibraryLocator;
import net.rubygrapefruit.platform.internal.Platform;
import net.rubygrapefruit.platform.internal.jni.NativeLibraryFunctions;

@ThreadSafe
public class Native {
    private final NativeLibraryLoader loader;
    private final Map<Class<?>, Object> integrations = new HashMap();
    private static Native instance;

    private Native(NativeLibraryLoader loader) {
        this.loader = loader;
    }

    @ThreadSafe
    public static Native init(File extractDir) throws NativeIntegrationUnavailableException, NativeException {
        Class<Native> clazz = Native.class;
        synchronized (Native.class) {
            if (instance != null) {
                throw new NativeException("Native integration already initialised.");
            }
            Platform platform = Platform.current();
            try {
                NativeLibraryLoader loader = new NativeLibraryLoader(platform, new NativeLibraryLocator(extractDir, "660c5614fbf4a5f2a75b1949f50a0caf5cd603558e7d8a26e50b933a0cfb79d1"));
                loader.load(platform.getLibraryName(), platform.getLibraryVariants());
                String nativeVersion = NativeLibraryFunctions.getVersion();
                if (!nativeVersion.equals("660c5614fbf4a5f2a75b1949f50a0caf5cd603558e7d8a26e50b933a0cfb79d1")) {
                    throw new NativeException(String.format("Unexpected native library version loaded. Expected %s, was %s.", "660c5614fbf4a5f2a75b1949f50a0caf5cd603558e7d8a26e50b933a0cfb79d1", nativeVersion));
                }
                instance = new Native(loader);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
            catch (NativeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NativeException("Failed to initialise native integration.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadSafe
    public <T extends NativeIntegration> T get(Class<T> type) throws NativeIntegrationUnavailableException, NativeException {
        Native native_ = this;
        synchronized (native_) {
            Platform platform = Platform.current();
            Class<T> canonicalType = platform.canonicalise(type);
            Object instance = this.integrations.get(canonicalType);
            if (instance == null) {
                try {
                    instance = platform.get(canonicalType, this.loader);
                }
                catch (NativeException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new NativeException(String.format("Failed to load native integration %s.", type.getSimpleName()), t);
                }
                this.integrations.put(canonicalType, instance);
            }
            return (T)((NativeIntegration)type.cast(instance));
        }
    }
}

