/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

import antlr.CharFormatter;
import antlr.collections.impl.IntRange;
import antlr.collections.impl.Vector;

public class BitSet
implements Cloneable {
    protected static final int BITS = 64;
    protected static final int NIBBLE = 4;
    protected static final int LOG_BITS = 6;
    protected static final int MOD_MASK = 63;
    protected long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(int n15) {
        this.bits = new long[(n15 - 1 >> 6) + 1];
    }

    public void add(int n15) {
        int n16 = BitSet.wordNumber(n15);
        if (n16 >= this.bits.length) {
            this.growToInclude(n15);
        }
        int n17 = n16;
        this.bits[n17] = this.bits[n17] | BitSet.bitMask(n15);
    }

    public BitSet and(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.andInPlace(bitSet);
        return bitSet2;
    }

    public void andInPlace(BitSet bitSet) {
        int n15;
        int n16 = Math.min(this.bits.length, bitSet.bits.length);
        for (n15 = n16 - 1; n15 >= 0; --n15) {
            int n17 = n15;
            this.bits[n17] = this.bits[n17] & bitSet.bits[n15];
        }
        for (n15 = n16; n15 < this.bits.length; ++n15) {
            this.bits[n15] = 0L;
        }
    }

    private static final long bitMask(int n15) {
        int n16 = n15 & 0x3F;
        return 1L << n16;
    }

    public void clear() {
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            this.bits[i15] = 0L;
        }
    }

    public void clear(int n15) {
        int n16 = BitSet.wordNumber(n15);
        if (n16 >= this.bits.length) {
            this.growToInclude(n15);
        }
        int n17 = n16;
        this.bits[n17] = this.bits[n17] & (BitSet.bitMask(n15) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public int degree() {
        int n15 = 0;
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            long l15 = this.bits[i15];
            if (l15 == 0L) continue;
            for (int i16 = 63; i16 >= 0; --i16) {
                if ((l15 & 1L << i16) == 0L) continue;
                ++n15;
            }
        }
        return n15;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof BitSet) {
            int n15;
            BitSet bitSet = (BitSet)object;
            int n16 = n15 = Math.min(this.bits.length, bitSet.bits.length);
            while (n16-- > 0) {
                if (this.bits[n16] == bitSet.bits[n16]) continue;
                return false;
            }
            if (this.bits.length > n15) {
                n16 = this.bits.length;
                while (n16-- > n15) {
                    if (this.bits[n16] == 0L) continue;
                    return false;
                }
            } else if (bitSet.bits.length > n15) {
                n16 = bitSet.bits.length;
                while (n16-- > n15) {
                    if (bitSet.bits[n16] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static Vector getRanges(int[] nArray) {
        if (nArray.length == 0) {
            return null;
        }
        int n15 = nArray[0];
        int n16 = nArray[nArray.length - 1];
        if (nArray.length <= 2) {
            return null;
        }
        Vector vector = new Vector(5);
        for (int i15 = 0; i15 < nArray.length - 2; ++i15) {
            int n17 = nArray.length - 1;
            for (int i16 = i15 + 1; i16 < nArray.length; ++i16) {
                if (nArray[i16] == nArray[i16 - 1] + 1) continue;
                n17 = i16 - 1;
                break;
            }
            if (n17 - i15 <= 2) continue;
            vector.appendElement(new IntRange(nArray[i15], nArray[n17]));
        }
        return vector;
    }

    public void growToInclude(int n15) {
        int n16 = Math.max(this.bits.length << 1, this.numWordsToHold(n15));
        long[] lArray = new long[n16];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public boolean member(int n15) {
        int n16 = BitSet.wordNumber(n15);
        if (n16 >= this.bits.length) {
            return false;
        }
        return (this.bits[n16] & BitSet.bitMask(n15)) != 0L;
    }

    public boolean nil() {
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            if (this.bits[i15] == 0L) continue;
            return false;
        }
        return true;
    }

    public BitSet not() {
        BitSet bitSet = (BitSet)this.clone();
        bitSet.notInPlace();
        return bitSet;
    }

    public void notInPlace() {
        for (int i15 = this.bits.length - 1; i15 >= 0; --i15) {
            this.bits[i15] = this.bits[i15] ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void notInPlace(int n15) {
        this.notInPlace(0, n15);
    }

    public void notInPlace(int n15, int n16) {
        this.growToInclude(n16);
        for (int i15 = n15; i15 <= n16; ++i15) {
            int n17;
            int n18 = n17 = BitSet.wordNumber(i15);
            this.bits[n18] = this.bits[n18] ^ BitSet.bitMask(i15);
        }
    }

    private final int numWordsToHold(int n15) {
        return (n15 >> 6) + 1;
    }

    public static BitSet of(int n15) {
        BitSet bitSet = new BitSet(n15 + 1);
        bitSet.add(n15);
        return bitSet;
    }

    public BitSet or(BitSet bitSet) {
        BitSet bitSet2 = (BitSet)this.clone();
        bitSet2.orInPlace(bitSet);
        return bitSet2;
    }

    public void orInPlace(BitSet bitSet) {
        if (bitSet.bits.length > this.bits.length) {
            this.setSize(bitSet.bits.length);
        }
        int n15 = Math.min(this.bits.length, bitSet.bits.length);
        for (int i15 = n15 - 1; i15 >= 0; --i15) {
            int n16 = i15;
            this.bits[n16] = this.bits[n16] | bitSet.bits[i15];
        }
    }

    public void remove(int n15) {
        int n16 = BitSet.wordNumber(n15);
        if (n16 >= this.bits.length) {
            this.growToInclude(n15);
        }
        int n17 = n16;
        this.bits[n17] = this.bits[n17] & (BitSet.bitMask(n15) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private void setSize(int n15) {
        long[] lArray = new long[n15];
        int n16 = Math.min(n15, this.bits.length);
        System.arraycopy(this.bits, 0, lArray, 0, n16);
        this.bits = lArray;
    }

    public int size() {
        return this.bits.length << 6;
    }

    public int lengthInLongWords() {
        return this.bits.length;
    }

    public boolean subset(BitSet bitSet) {
        if (bitSet == null || !(bitSet instanceof BitSet)) {
            return false;
        }
        return this.and(bitSet).equals(this);
    }

    public void subtractInPlace(BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        for (int i15 = 0; i15 < this.bits.length && i15 < bitSet.bits.length; ++i15) {
            int n15 = i15;
            this.bits[n15] = this.bits[n15] & (bitSet.bits[i15] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.degree()];
        int n15 = 0;
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            nArray[n15++] = i15;
        }
        return nArray;
    }

    public long[] toPackedArray() {
        return this.bits;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String string) {
        String string2 = "";
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = string2 + i15;
        }
        return string2;
    }

    public String toString(String string, CharFormatter charFormatter) {
        String string2 = "";
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = string2 + charFormatter.literalChar(i15);
        }
        return string2;
    }

    public String toString(String string, Vector vector) {
        if (vector == null) {
            return this.toString(string);
        }
        String string2 = "";
        for (int i15 = 0; i15 < this.bits.length << 6; ++i15) {
            if (!this.member(i15)) continue;
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            string2 = i15 >= vector.size() ? string2 + "<bad element " + i15 + ">" : (vector.elementAt(i15) == null ? string2 + "<" + i15 + ">" : string2 + (String)vector.elementAt(i15));
        }
        return string2;
    }

    public String toStringOfHalfWords() {
        String string = new String();
        for (int i15 = 0; i15 < this.bits.length; ++i15) {
            if (i15 != 0) {
                string = string + ", ";
            }
            long l15 = this.bits[i15];
            string = string + (l15 &= 0xFFFFFFFFL) + "UL";
            string = string + ", ";
            l15 = this.bits[i15] >>> 32;
            string = string + (l15 &= 0xFFFFFFFFL) + "UL";
        }
        return string;
    }

    public String toStringOfWords() {
        String string = new String();
        for (int i15 = 0; i15 < this.bits.length; ++i15) {
            if (i15 != 0) {
                string = string + ", ";
            }
            string = string + this.bits[i15] + "L";
        }
        return string;
    }

    public String toStringWithRanges(String string, CharFormatter charFormatter) {
        String string2 = "";
        int[] nArray = this.toArray();
        if (nArray.length == 0) {
            return "";
        }
        for (int i15 = 0; i15 < nArray.length; ++i15) {
            int n15 = 0;
            int n16 = i15 + 1;
            while (n16 < nArray.length && nArray[n16] == nArray[n16 - 1] + 1) {
                n15 = n16++;
            }
            if (string2.length() > 0) {
                string2 = string2 + string;
            }
            if (n15 - i15 >= 2) {
                string2 = string2 + charFormatter.literalChar(nArray[i15]);
                string2 = string2 + "..";
                string2 = string2 + charFormatter.literalChar(nArray[n15]);
                i15 = n15;
                continue;
            }
            string2 = string2 + charFormatter.literalChar(nArray[i15]);
        }
        return string2;
    }

    private static final int wordNumber(int n15) {
        return n15 >> 6;
    }
}

