/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.MultiCstInsn;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstBaseMethodRef;
import com.android.dx.rop.cst.CstCallSiteRef;
import com.android.dx.rop.cst.CstProtoRef;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.FixedSizeList;
import com.android.dx.util.IndentingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;

public final class DalvInsnList
extends FixedSizeList {
    private final int regCount;

    public static DalvInsnList makeImmutable(ArrayList<DalvInsn> list2, int regCount) {
        int size = list2.size();
        DalvInsnList result = new DalvInsnList(size, regCount);
        for (int i15 = 0; i15 < size; ++i15) {
            result.set(i15, list2.get(i15));
        }
        result.setImmutable();
        return result;
    }

    public DalvInsnList(int size, int regCount) {
        super(size);
        this.regCount = regCount;
    }

    public DalvInsn get(int n15) {
        return (DalvInsn)this.get0(n15);
    }

    public void set(int n15, DalvInsn insn) {
        this.set0(n15, insn);
    }

    public int codeSize() {
        int sz4 = this.size();
        if (sz4 == 0) {
            return 0;
        }
        DalvInsn last = this.get(sz4 - 1);
        return last.getNextAddress();
    }

    public void writeTo(AnnotatedOutput out) {
        int startCursor = out.getCursor();
        int sz4 = this.size();
        if (out.annotates()) {
            boolean verbose = out.isVerbose();
            for (int i15 = 0; i15 < sz4; ++i15) {
                DalvInsn insn = (DalvInsn)this.get0(i15);
                int codeBytes = insn.codeSize() * 2;
                String s15 = codeBytes != 0 || verbose ? insn.listingString("  ", out.getAnnotationWidth(), true) : null;
                if (s15 != null) {
                    out.annotate(codeBytes, s15);
                    continue;
                }
                if (codeBytes == 0) continue;
                out.annotate(codeBytes, "");
            }
        }
        for (int i16 = 0; i16 < sz4; ++i16) {
            DalvInsn insn = (DalvInsn)this.get0(i16);
            try {
                insn.writeTo(out);
                continue;
            }
            catch (RuntimeException ex4) {
                throw ExceptionWithContext.withContext(ex4, "...while writing " + insn);
            }
        }
        int written = (out.getCursor() - startCursor) / 2;
        if (written != this.codeSize()) {
            throw new RuntimeException("write length mismatch; expected " + this.codeSize() + " but actually wrote " + written);
        }
    }

    public int getRegistersSize() {
        return this.regCount;
    }

    public int getOutsSize() {
        int sz4 = this.size();
        int result = 0;
        for (int i15 = 0; i15 < sz4; ++i15) {
            DalvInsn insn = (DalvInsn)this.get0(i15);
            int count = 0;
            if (insn instanceof CstInsn) {
                Constant cst = ((CstInsn)insn).getConstant();
                if (cst instanceof CstBaseMethodRef) {
                    CstBaseMethodRef methodRef = (CstBaseMethodRef)cst;
                    boolean isStatic = insn.getOpcode().getFamily() == 113;
                    count = methodRef.getParameterWordCount(isStatic);
                } else if (cst instanceof CstCallSiteRef) {
                    CstCallSiteRef invokeDynamicRef = (CstCallSiteRef)cst;
                    count = invokeDynamicRef.getPrototype().getParameterTypes().getWordCount();
                }
            } else {
                if (!(insn instanceof MultiCstInsn)) continue;
                if (insn.getOpcode().getFamily() != 250) {
                    throw new RuntimeException("Expecting invoke-polymorphic");
                }
                MultiCstInsn mci = (MultiCstInsn)insn;
                CstProtoRef proto = (CstProtoRef)mci.getConstant(1);
                count = proto.getPrototype().getParameterTypes().getWordCount();
                ++count;
            }
            if (count <= result) continue;
            result = count;
        }
        return result;
    }

    public void debugPrint(Writer out, String prefix, boolean verbose) {
        IndentingWriter iw4 = new IndentingWriter(out, 0, prefix);
        int sz4 = this.size();
        try {
            for (int i15 = 0; i15 < sz4; ++i15) {
                DalvInsn insn = (DalvInsn)this.get0(i15);
                String s15 = insn.codeSize() != 0 || verbose ? insn.listingString("", 0, verbose) : null;
                if (s15 == null) continue;
                iw4.write(s15);
            }
            iw4.flush();
        }
        catch (IOException ex4) {
            throw new RuntimeException(ex4);
        }
    }

    public void debugPrint(OutputStream out, String prefix, boolean verbose) {
        OutputStreamWriter w15 = new OutputStreamWriter(out);
        this.debugPrint(w15, prefix, verbose);
        try {
            ((Writer)w15).flush();
        }
        catch (IOException ex4) {
            throw new RuntimeException(ex4);
        }
    }
}

