/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.rop.cst;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.util.Hex;
import com.android.dx.util.MutabilityControl;

public final class StdConstantPool
extends MutabilityControl
implements ConstantPool {
    private final Constant[] entries;

    public StdConstantPool(int size) {
        super(size > 1);
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.entries = new Constant[size];
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public Constant getOrNull(int n15) {
        try {
            return this.entries[n15];
        }
        catch (IndexOutOfBoundsException ex4) {
            return StdConstantPool.throwInvalid(n15);
        }
    }

    @Override
    public Constant get0Ok(int n15) {
        if (n15 == 0) {
            return null;
        }
        return this.get(n15);
    }

    @Override
    public Constant get(int n15) {
        try {
            Constant result = this.entries[n15];
            if (result == null) {
                StdConstantPool.throwInvalid(n15);
            }
            return result;
        }
        catch (IndexOutOfBoundsException ex4) {
            return StdConstantPool.throwInvalid(n15);
        }
    }

    @Override
    public Constant[] getEntries() {
        return this.entries;
    }

    public void set(int n15, Constant cst) {
        Constant prev;
        boolean cat2;
        this.throwIfImmutable();
        boolean bl4 = cat2 = cst != null && cst.isCategory2();
        if (n15 < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        if (cat2) {
            if (n15 == this.entries.length - 1) {
                throw new IllegalArgumentException("(n == size - 1) && cst.isCategory2()");
            }
            this.entries[n15 + 1] = null;
        }
        if (cst != null && this.entries[n15] == null && (prev = this.entries[n15 - 1]) != null && prev.isCategory2()) {
            this.entries[n15 - 1] = null;
        }
        this.entries[n15] = cst;
    }

    private static Constant throwInvalid(int idx) {
        throw new ExceptionWithContext("invalid constant pool index " + Hex.u2(idx));
    }
}

