/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.targeting.TargetingDimension;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;

public class DeviceGroupParityValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        BundleModule referenceModule = null;
        ImmutableSet<String> referenceGroups = null;
        for (BundleModule module : modules) {
            ImmutableSet<String> moduleGroups = TargetingUtils.extractDeviceGroups(TargetingUtils.extractAssetsTargetedDirectories(module));
            if (moduleGroups.isEmpty()) continue;
            this.validateModuleDirectoryParity(module, moduleGroups);
            if (referenceGroups == null) {
                referenceModule = module;
                referenceGroups = moduleGroups;
                continue;
            }
            if (referenceGroups.equals(moduleGroups)) continue;
            throw InvalidBundleException.builder().withUserMessage("All modules with device group targeting must support the same set of groups, but module '%s' supports %s and module '%s' supports %s.", referenceModule.getName(), referenceGroups, module.getName(), moduleGroups).build();
        }
    }

    private void validateModuleDirectoryParity(BundleModule module, ImmutableSet<String> moduleGroups) {
        ImmutableSetMultimap<String, String> groupsPerDirectory = TargetingUtils.extractAssetsTargetedDirectories(module).stream().filter(directory -> TargetingUtils.extractDeviceGroup(directory).isPresent()).collect(ImmutableSetMultimap.toImmutableSetMultimap(directory -> directory.getSubPathBaseName(TargetingDimension.DEVICE_GROUP), directory -> TargetingUtils.extractDeviceGroup(directory).get()));
        for (String subpath : groupsPerDirectory.keySet()) {
            if (((ImmutableSet)groupsPerDirectory.get((Object)subpath)).equals(moduleGroups)) continue;
            throw InvalidBundleException.builder().withUserMessage("All device-group-targeted folders in a module must support the same set of groups, but module '%s' supports %s and folder '%s' supports only %s.", module.getName(), moduleGroups, subpath, groupsPerDirectory.get((Object)subpath)).build();
        }
    }
}

