/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class FlatButtonUI
extends BasicButtonUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    protected int iconTextGap;
    protected Color background;
    protected Color foreground;
    protected Color startBackground;
    protected Color endBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected Color focusedForeground;
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color pressedBackground;
    @FlatStylingSupport.Styleable
    protected Color pressedForeground;
    @FlatStylingSupport.Styleable
    protected Color selectedBackground;
    @FlatStylingSupport.Styleable
    protected Color selectedForeground;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledText;
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedBackground;
    @FlatStylingSupport.Styleable
    protected Color disabledSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultBackground;
    protected Color defaultEndBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultFocusedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultPressedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected boolean defaultBoldText;
    @FlatStylingSupport.Styleable
    protected boolean paintShadow;
    @FlatStylingSupport.Styleable
    protected int shadowWidth;
    @FlatStylingSupport.Styleable
    protected Color shadowColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color defaultShadowColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarPressedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarPressedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarDisabledSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color toolbarDisabledSelectedForeground;
    @FlatStylingSupport.Styleable
    protected String buttonType;
    @FlatStylingSupport.Styleable
    protected boolean squareSize;
    @FlatStylingSupport.Styleable
    protected int minimumHeight;
    private Icon helpButtonIcon;
    private Insets defaultMargin;
    private final boolean shared;
    private boolean helpButtonIconShared = true;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;
    static final int TYPE_OTHER = -1;
    static final int TYPE_SQUARE = 0;
    static final int TYPE_ROUND_RECT = 1;
    private static Rectangle viewR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Rectangle iconR = new Rectangle();

    public static ComponentUI createUI(JComponent c15) {
        return FlatUIUtils.canUseSharedUI(c15) && !FlatUIUtils.needsLightAWTPeer(c15) ? FlatUIUtils.createSharedUI(FlatButtonUI.class, () -> new FlatButtonUI(true)) : new FlatButtonUI(false);
    }

    protected FlatButtonUI(boolean shared) {
        this.shared = shared;
    }

    @Override
    public void installUI(JComponent c15) {
        if (FlatUIUtils.needsLightAWTPeer(c15)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(c15));
        } else {
            this.installUIImpl(c15);
        }
    }

    private void installUIImpl(JComponent c15) {
        super.installUI(c15);
        this.installStyle((AbstractButton)c15);
    }

    @Override
    protected void installDefaults(AbstractButton b15) {
        Color bg5;
        super.installDefaults(b15);
        if (!this.defaults_initialized) {
            String prefix = this.getPropertyPrefix();
            this.minimumWidth = UIManager.getInt(prefix + "minimumWidth");
            this.iconTextGap = FlatUIUtils.getUIInt(prefix + "iconTextGap", 4);
            this.background = UIManager.getColor(prefix + "background");
            this.foreground = UIManager.getColor(prefix + "foreground");
            this.startBackground = UIManager.getColor(prefix + "startBackground");
            this.endBackground = UIManager.getColor(prefix + "endBackground");
            this.focusedBackground = UIManager.getColor(prefix + "focusedBackground");
            this.focusedForeground = UIManager.getColor(prefix + "focusedForeground");
            this.hoverBackground = UIManager.getColor(prefix + "hoverBackground");
            this.hoverForeground = UIManager.getColor(prefix + "hoverForeground");
            this.pressedBackground = UIManager.getColor(prefix + "pressedBackground");
            this.pressedForeground = UIManager.getColor(prefix + "pressedForeground");
            this.selectedBackground = UIManager.getColor(prefix + "selectedBackground");
            this.selectedForeground = UIManager.getColor(prefix + "selectedForeground");
            this.disabledBackground = UIManager.getColor(prefix + "disabledBackground");
            this.disabledText = UIManager.getColor(prefix + "disabledText");
            this.disabledSelectedBackground = UIManager.getColor(prefix + "disabledSelectedBackground");
            this.disabledSelectedForeground = UIManager.getColor(prefix + "disabledSelectedForeground");
            this.defaultBackground = FlatUIUtils.getUIColor("Button.default.startBackground", "Button.default.background");
            this.defaultEndBackground = UIManager.getColor("Button.default.endBackground");
            this.defaultForeground = UIManager.getColor("Button.default.foreground");
            this.defaultFocusedBackground = UIManager.getColor("Button.default.focusedBackground");
            this.defaultFocusedForeground = UIManager.getColor("Button.default.focusedForeground");
            this.defaultHoverBackground = UIManager.getColor("Button.default.hoverBackground");
            this.defaultHoverForeground = UIManager.getColor("Button.default.hoverForeground");
            this.defaultPressedBackground = UIManager.getColor("Button.default.pressedBackground");
            this.defaultPressedForeground = UIManager.getColor("Button.default.pressedForeground");
            this.defaultBoldText = UIManager.getBoolean("Button.default.boldText");
            this.paintShadow = UIManager.getBoolean("Button.paintShadow");
            this.shadowWidth = FlatUIUtils.getUIInt("Button.shadowWidth", 2);
            this.shadowColor = UIManager.getColor("Button.shadowColor");
            this.defaultShadowColor = UIManager.getColor("Button.default.shadowColor");
            this.toolbarHoverBackground = UIManager.getColor(prefix + "toolbar.hoverBackground");
            this.toolbarHoverForeground = UIManager.getColor(prefix + "toolbar.hoverForeground");
            this.toolbarPressedBackground = UIManager.getColor(prefix + "toolbar.pressedBackground");
            this.toolbarPressedForeground = UIManager.getColor(prefix + "toolbar.pressedForeground");
            this.toolbarSelectedBackground = UIManager.getColor(prefix + "toolbar.selectedBackground");
            this.toolbarSelectedForeground = UIManager.getColor(prefix + "toolbar.selectedForeground");
            this.toolbarDisabledSelectedBackground = UIManager.getColor(prefix + "toolbar.disabledSelectedBackground");
            this.toolbarDisabledSelectedForeground = UIManager.getColor(prefix + "toolbar.disabledSelectedForeground");
            this.helpButtonIcon = UIManager.getIcon("HelpButton.icon");
            this.defaultMargin = UIManager.getInsets(prefix + "margin");
            this.helpButtonIconShared = true;
            this.defaults_initialized = true;
        }
        if (this.startBackground != null && ((bg5 = b15.getBackground()) == null || bg5 instanceof UIResource)) {
            b15.setBackground(this.startBackground);
        }
        LookAndFeel.installProperty(b15, "opaque", false);
        LookAndFeel.installProperty(b15, "iconTextGap", UIScale.scale(this.iconTextGap));
    }

    @Override
    protected void uninstallDefaults(AbstractButton b15) {
        super.uninstallDefaults(b15);
        this.oldStyleValues = null;
        this.borderShared = null;
        this.defaults_initialized = false;
    }

    @Override
    protected void installListeners(AbstractButton b15) {
        super.installListeners(b15);
        MigLayoutVisualPadding.install(b15);
    }

    @Override
    protected void uninstallListeners(AbstractButton b15) {
        super.uninstallListeners(b15);
        MigLayoutVisualPadding.uninstall(b15);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b15) {
        return new FlatButtonListener(b15);
    }

    protected void propertyChange(AbstractButton b15, PropertyChangeEvent e15) {
        switch (e15.getPropertyName()) {
            case "html": {
                FlatHTML.updateRendererCSSFontBaseSize(b15);
                break;
            }
            case "JButton.squareSize": 
            case "JComponent.minimumWidth": 
            case "JComponent.minimumHeight": {
                b15.revalidate();
                break;
            }
            case "JButton.buttonType": {
                b15.revalidate();
                HiDPIUtils.repaint(b15);
                break;
            }
            case "JComponent.outline": {
                HiDPIUtils.repaint(b15);
                break;
            }
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                if (this.shared && FlatStylingSupport.hasStyleProperty(b15)) {
                    b15.updateUI();
                } else {
                    this.installStyle(b15);
                }
                b15.revalidate();
                HiDPIUtils.repaint(b15);
            }
        }
    }

    protected void installStyle(AbstractButton b15) {
        try {
            this.applyStyle(b15, FlatStylingSupport.getResolvedStyle(b15, this.getStyleType()));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    String getStyleType() {
        return "Button";
    }

    protected void applyStyle(AbstractButton b15, Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, (key, value) -> this.applyStyleProperty(b15, (String)key, value));
    }

    protected Object applyStyleProperty(AbstractButton b15, String key, Object value) {
        if (key.startsWith("help.")) {
            if (!(this.helpButtonIcon instanceof FlatStylingSupport.StyleableObject)) {
                throw new FlatStylingSupport.UnknownStyleException(key);
            }
            if (this.helpButtonIconShared) {
                this.helpButtonIcon = FlatStylingSupport.cloneIcon(this.helpButtonIcon);
                this.helpButtonIconShared = false;
            }
            key = key.substring("help.".length());
            return ((FlatStylingSupport.StyleableObject)((Object)this.helpButtonIcon)).applyStyleProperty(key, value);
        }
        switch (key) {
            case "background": {
                this.background = (Color)value;
                break;
            }
            case "foreground": {
                this.foreground = (Color)value;
            }
        }
        if ("iconTextGap".equals(key) && value instanceof Integer) {
            value = UIScale.scale((Integer)value);
        }
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, key, value, b15, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        Map<String, Class<?>> infos = FlatStylingSupport.getAnnotatedStyleableInfos(this, c15.getBorder());
        if (this.helpButtonIcon instanceof FlatStylingSupport.StyleableObject) {
            FlatStylingSupport.putAllPrefixKey(infos, "help.", ((FlatStylingSupport.StyleableObject)((Object)this.helpButtonIcon)).getStyleableInfos());
        }
        return infos;
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        if (key.startsWith("help.")) {
            return this.helpButtonIcon instanceof FlatStylingSupport.StyleableObject ? ((FlatStylingSupport.StyleableObject)((Object)this.helpButtonIcon)).getStyleableValue(key.substring("help.".length())) : null;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, c15.getBorder(), key);
    }

    static boolean isContentAreaFilled(Component c15) {
        return !(c15 instanceof AbstractButton) || ((AbstractButton)c15).isContentAreaFilled();
    }

    public static boolean isFocusPainted(Component c15) {
        return !(c15 instanceof AbstractButton) || ((AbstractButton)c15).isFocusPainted();
    }

    static boolean isDefaultButton(Component c15) {
        return c15 instanceof JButton && ((JButton)c15).isDefaultButton();
    }

    static boolean isIconOnlyOrSingleCharacterButton(Component c15) {
        if (!(c15 instanceof JButton) && !(c15 instanceof JToggleButton)) {
            return false;
        }
        Icon icon = ((AbstractButton)c15).getIcon();
        String text = ((AbstractButton)c15).getText();
        return icon != null && (text == null || text.isEmpty()) || icon == null && text != null && ("...".equals(text) || text.length() == 1 || text.length() == 2 && Character.isSurrogatePair(text.charAt(0), text.charAt(1)));
    }

    static int getButtonType(Component c15) {
        if (!(c15 instanceof AbstractButton)) {
            return -1;
        }
        String value = FlatButtonUI.getButtonTypeStr((AbstractButton)c15);
        if (value == null) {
            return -1;
        }
        switch (value) {
            case "square": {
                return 0;
            }
            case "roundRect": {
                return 1;
            }
        }
        return -1;
    }

    static boolean isHelpButton(Component c15) {
        return c15 instanceof JButton && "help".equals(FlatButtonUI.getButtonTypeStr((JButton)c15));
    }

    static boolean isToolBarButton(Component c15) {
        return c15.getParent() instanceof JToolBar || c15 instanceof AbstractButton && "toolBarButton".equals(FlatButtonUI.getButtonTypeStr((AbstractButton)c15));
    }

    static boolean isBorderlessButton(Component c15) {
        return c15 instanceof AbstractButton && "borderless".equals(FlatButtonUI.getButtonTypeStr((AbstractButton)c15));
    }

    static String getButtonTypeStr(AbstractButton c15) {
        Object value = c15.getClientProperty("JButton.buttonType");
        if (value instanceof String) {
            return (String)value;
        }
        ButtonUI ui4 = c15.getUI();
        return ui4 instanceof FlatButtonUI ? ((FlatButtonUI)ui4).buttonType : null;
    }

    @Override
    public void update(Graphics g15, JComponent c15) {
        if (c15.isOpaque()) {
            FlatUIUtils.paintParentBackground(g15, c15);
        }
        if (FlatButtonUI.isHelpButton(c15)) {
            this.helpButtonIcon.paintIcon(c15, g15, 0, 0);
            return;
        }
        if (FlatButtonUI.isContentAreaFilled(c15)) {
            this.paintBackground(g15, c15);
        }
        this.paint(g15, c15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBackground(Graphics g15, JComponent c15) {
        Color background = this.getBackground(c15);
        if (background == null) {
            return;
        }
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            Color endBg;
            Color shadowColor;
            JTextField textField;
            FlatUIUtils.setRenderingHints(g25);
            boolean def = FlatButtonUI.isDefaultButton(c15);
            boolean isToolBarButton = FlatButtonUI.isToolBarButton(c15);
            float focusWidth = isToolBarButton ? 0.0f : FlatUIUtils.getBorderFocusWidth(c15);
            float arc = FlatUIUtils.getBorderArc(c15);
            float textFieldArc = 0.0f;
            if (isToolBarButton && FlatClientProperties.clientProperty(c15, "FlatLaf.styleClass", "", String.class).contains("inTextField") && (textField = (JTextField)SwingUtilities.getAncestorOfClass(JTextField.class, c15)) != null) {
                textFieldArc = FlatUIUtils.getBorderArc(textField);
            }
            int x15 = 0;
            int y15 = 0;
            int width = c15.getWidth();
            int height = c15.getHeight();
            if (isToolBarButton && c15.getBorder() instanceof FlatButtonBorder) {
                Insets spacing = UIScale.scale(((FlatButtonBorder)c15.getBorder()).toolbarSpacingInsets);
                x15 += spacing.left;
                y15 += spacing.top;
                width -= spacing.left + spacing.right;
                height -= spacing.top + spacing.bottom;
                textFieldArc -= (float)(spacing.top + spacing.bottom);
            }
            if (arc < textFieldArc) {
                arc = textFieldArc;
            }
            Color color = shadowColor = def ? this.defaultShadowColor : this.shadowColor;
            if (!(!this.paintShadow || shadowColor == null || this.shadowWidth <= 0 || !(focusWidth > 0.0f) || !c15.isEnabled() || isToolBarButton || FlatButtonUI.isBorderlessButton(c15) || FlatButtonUI.isFocusPainted(c15) && FlatUIUtils.isPermanentFocusOwner(c15))) {
                g25.setColor(shadowColor);
                g25.fill(new RoundRectangle2D.Float(focusWidth, focusWidth + UIScale.scale((float)this.shadowWidth), (float)width - focusWidth * 2.0f, (float)height - focusWidth * 2.0f, arc, arc));
            }
            Color startBg = def ? this.defaultBackground : this.startBackground;
            Color color2 = endBg = def ? this.defaultEndBackground : this.endBackground;
            if (background == startBg && endBg != null && !startBg.equals(endBg)) {
                g25.setPaint(new GradientPaint(0.0f, 0.0f, startBg, 0.0f, height, endBg));
            } else {
                g25.setColor(FlatUIUtils.deriveColor(background, this.getBackgroundBase(c15, def)));
            }
            FlatUIUtils.paintComponentBackground(g25, x15, y15, width, height, focusWidth, arc);
        }
        finally {
            g25.dispose();
        }
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        g15 = FlatLabelUI.createGraphicsHTMLTextYCorrection(g15, c15);
        AbstractButton b15 = (AbstractButton)c15;
        String clippedText = FlatButtonUI.layout(b15, b15.getFontMetrics(b15.getFont()), b15.getWidth(), b15.getHeight());
        this.clearTextShiftOffset();
        ButtonModel model = b15.getModel();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g15, b15);
        }
        if (b15.getIcon() != null) {
            this.paintIcon(g15, b15, iconR);
        }
        if (clippedText != null && !clippedText.isEmpty()) {
            View view = (View)b15.getClientProperty("html");
            if (view != null) {
                if (b15.isEnabled()) {
                    FlatHTML.updateRendererCSSForeground(view, this.getForeground(b15));
                }
                view.paint(g15, textR);
            } else {
                this.paintText(g15, b15, textR, clippedText);
            }
        }
        if (b15.isFocusPainted() && b15.hasFocus()) {
            this.paintFocus(g15, b15, viewR, textR, iconR);
        }
    }

    @Override
    protected void paintIcon(Graphics g15, JComponent c15, Rectangle iconRect) {
        int xOffset = this.defaultBoldPlainWidthDiff(c15) / 2;
        if (xOffset > 0) {
            boolean ltr = c15.getComponentOrientation().isLeftToRight();
            switch (((AbstractButton)c15).getHorizontalTextPosition()) {
                case 4: {
                    iconRect.x -= xOffset;
                    break;
                }
                case 2: {
                    iconRect.x += xOffset;
                    break;
                }
                case 11: {
                    iconRect.x = iconRect.x - (ltr ? xOffset : -xOffset);
                    break;
                }
                case 10: {
                    iconRect.x = iconRect.x + (ltr ? xOffset : -xOffset);
                }
            }
        }
        super.paintIcon(g15, c15, iconRect);
    }

    @Override
    protected void paintText(Graphics g15, AbstractButton b15, Rectangle textRect, String text) {
        if (FlatButtonUI.isHelpButton(b15)) {
            return;
        }
        if (this.defaultBoldText && FlatButtonUI.isDefaultButton(b15) && b15.getFont() instanceof UIResource) {
            Font boldFont = g15.getFont().deriveFont(1);
            g15.setFont(boldFont);
            int boldWidth = b15.getFontMetrics(boldFont).stringWidth(text);
            if (boldWidth > textRect.width) {
                textRect.x -= (boldWidth - textRect.width) / 2;
                textRect.width = boldWidth;
            }
        }
        FlatButtonUI.paintText(g15, b15, textRect, text, this.getForeground(b15));
    }

    public static void paintText(Graphics g15, AbstractButton b15, Rectangle textRect, String text, Color foreground) {
        FontMetrics fm4 = b15.getFontMetrics(b15.getFont());
        int mnemonicIndex = FlatLaf.isShowMnemonics() ? b15.getDisplayedMnemonicIndex() : -1;
        g15.setColor(foreground);
        FlatUIUtils.drawStringUnderlineCharAt(b15, g15, text, mnemonicIndex, textRect.x, textRect.y + fm4.getAscent());
    }

    protected Color getBackground(JComponent c15) {
        boolean toolBarButton;
        boolean def = FlatButtonUI.isDefaultButton(c15);
        boolean bl4 = toolBarButton = !def && (FlatButtonUI.isToolBarButton(c15) || FlatButtonUI.isBorderlessButton(c15));
        if (((AbstractButton)c15).isSelected()) {
            return FlatButtonUI.buttonStateColor(c15, toolBarButton ? this.toolbarSelectedBackground : this.selectedBackground, toolBarButton ? (this.toolbarDisabledSelectedBackground != null ? this.toolbarDisabledSelectedBackground : this.toolbarSelectedBackground) : this.disabledSelectedBackground, null, null, toolBarButton ? this.toolbarPressedBackground : this.pressedBackground);
        }
        if (toolBarButton) {
            Color bg5 = c15.getBackground();
            return FlatButtonUI.buttonStateColor(c15, this.isCustomBackground(bg5) ? bg5 : null, null, null, this.toolbarHoverBackground, this.toolbarPressedBackground);
        }
        return FlatButtonUI.buttonStateColor(c15, this.getBackgroundBase(c15, def), this.disabledBackground, this.isCustomBackground(c15.getBackground()) ? null : (def ? this.defaultFocusedBackground : this.focusedBackground), def ? this.defaultHoverBackground : this.hoverBackground, def ? this.defaultPressedBackground : this.pressedBackground);
    }

    protected Color getBackgroundBase(JComponent c15, boolean def) {
        if (FlatUIUtils.isAWTPeer(c15)) {
            return this.background;
        }
        Color bg5 = c15.getBackground();
        if (this.isCustomBackground(bg5)) {
            return bg5;
        }
        return def ? this.defaultBackground : bg5;
    }

    protected boolean isCustomBackground(Color bg5) {
        return bg5 != this.background && (this.startBackground == null || bg5 != this.startBackground);
    }

    public static Color buttonStateColor(Component c15, Color enabledColor, Color disabledColor, Color focusedColor, Color hoverColor, Color pressedColor) {
        if (c15 == null) {
            return enabledColor;
        }
        if (!c15.isEnabled()) {
            return disabledColor;
        }
        if (c15 instanceof AbstractButton) {
            ButtonModel model = ((AbstractButton)c15).getModel();
            if (pressedColor != null && model.isPressed()) {
                return pressedColor;
            }
            if (hoverColor != null && model.isRollover()) {
                return hoverColor;
            }
        }
        if (focusedColor != null && FlatButtonUI.isFocusPainted(c15) && FlatUIUtils.isPermanentFocusOwner(c15)) {
            return focusedColor;
        }
        return enabledColor;
    }

    protected Color getForeground(JComponent c15) {
        boolean toolBarButton;
        Color fg5 = c15.getForeground();
        boolean def = FlatButtonUI.isDefaultButton(c15);
        boolean bl4 = toolBarButton = !def && (FlatButtonUI.isToolBarButton(c15) || FlatButtonUI.isBorderlessButton(c15));
        if (((AbstractButton)c15).isSelected()) {
            return FlatButtonUI.buttonStateColor(c15, toolBarButton ? (this.toolbarSelectedForeground != null ? this.toolbarSelectedForeground : fg5) : (this.isCustomForeground(fg5) ? fg5 : this.selectedForeground), toolBarButton ? (this.toolbarDisabledSelectedForeground != null ? this.toolbarDisabledSelectedForeground : this.disabledText) : (this.disabledSelectedForeground != null ? this.disabledSelectedForeground : this.disabledText), null, null, toolBarButton ? this.toolbarPressedForeground : this.pressedForeground);
        }
        if (toolBarButton) {
            return FlatButtonUI.buttonStateColor(c15, fg5, this.disabledText, null, this.toolbarHoverForeground, this.toolbarPressedForeground);
        }
        return FlatButtonUI.buttonStateColor(c15, this.getForegroundBase(c15, def), this.disabledText, this.isCustomForeground(fg5) ? null : (def ? this.defaultFocusedForeground : this.focusedForeground), def ? this.defaultHoverForeground : this.hoverForeground, def ? this.defaultPressedForeground : this.pressedForeground);
    }

    protected Color getForegroundBase(JComponent c15, boolean def) {
        Color fg5 = c15.getForeground();
        if (this.isCustomForeground(fg5)) {
            return fg5;
        }
        return def ? this.defaultForeground : fg5;
    }

    protected boolean isCustomForeground(Color fg5) {
        return fg5 != this.foreground;
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        if (FlatButtonUI.isHelpButton(c15)) {
            return new Dimension(this.helpButtonIcon.getIconWidth(), this.helpButtonIcon.getIconHeight());
        }
        Dimension prefSize = super.getPreferredSize(c15);
        if (prefSize == null) {
            return null;
        }
        prefSize.width += this.defaultBoldPlainWidthDiff(c15);
        boolean isIconOnlyOrSingleCharacter = FlatButtonUI.isIconOnlyOrSingleCharacterButton(c15);
        if (FlatClientProperties.clientPropertyBoolean(c15, "JButton.squareSize", this.squareSize)) {
            prefSize.width = prefSize.height = Math.max(prefSize.width, prefSize.height);
        } else if (isIconOnlyOrSingleCharacter && ((AbstractButton)c15).getIcon() == null) {
            prefSize.width = Math.max(prefSize.width, prefSize.height);
        } else if (!isIconOnlyOrSingleCharacter && !FlatButtonUI.isToolBarButton(c15) && c15.getBorder() instanceof FlatButtonBorder && this.hasDefaultMargins(c15)) {
            int fw4 = Math.round(FlatUIUtils.getBorderFocusWidth(c15) * 2.0f);
            prefSize.width = Math.max(prefSize.width, UIScale.scale(FlatUIUtils.minimumWidth(c15, this.minimumWidth)) + fw4);
            prefSize.height = Math.max(prefSize.height, UIScale.scale(FlatUIUtils.minimumHeight(c15, this.minimumHeight)) + fw4);
        }
        return prefSize;
    }

    private int defaultBoldPlainWidthDiff(JComponent c15) {
        if (this.defaultBoldText && FlatButtonUI.isDefaultButton(c15) && c15.getFont() instanceof UIResource) {
            int plainWidth;
            String text = ((AbstractButton)c15).getText();
            if (text == null || text.isEmpty()) {
                return 0;
            }
            Font font = c15.getFont();
            Font boldFont = font.deriveFont(1);
            int boldWidth = c15.getFontMetrics(boldFont).stringWidth(text);
            if (boldWidth > (plainWidth = c15.getFontMetrics(font).stringWidth(text))) {
                return boldWidth - plainWidth;
            }
        }
        return 0;
    }

    private boolean hasDefaultMargins(JComponent c15) {
        Insets margin = ((AbstractButton)c15).getMargin();
        return margin instanceof UIResource && Objects.equals(margin, this.defaultMargin);
    }

    @Override
    public int getBaseline(JComponent c15, int width, int height) {
        return FlatButtonUI.getBaselineImpl(c15, width, height);
    }

    static int getBaselineImpl(JComponent c15, int width, int height) {
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        AbstractButton b15 = (AbstractButton)c15;
        String text = b15.getText();
        if (text == null || text.isEmpty()) {
            return -1;
        }
        FontMetrics fm4 = b15.getFontMetrics(b15.getFont());
        FlatButtonUI.layout(b15, fm4, width, height);
        View view = (View)b15.getClientProperty("html");
        if (view != null) {
            int baseline = BasicHTML.getHTMLBaseline(view, FlatButtonUI.textR.width, FlatButtonUI.textR.height);
            return baseline >= 0 ? FlatButtonUI.textR.y + baseline : baseline;
        }
        return FlatButtonUI.textR.y + fm4.getAscent();
    }

    private static String layout(AbstractButton b15, FontMetrics fm4, int width, int height) {
        Insets insets = b15.getInsets();
        viewR.setBounds(insets.left, insets.top, width - insets.left - insets.right, height - insets.top - insets.bottom);
        textR.setBounds(0, 0, 0, 0);
        iconR.setBounds(0, 0, 0, 0);
        String text = b15.getText();
        return SwingUtilities.layoutCompoundLabel(b15, fm4, text, b15.getIcon(), b15.getVerticalAlignment(), b15.getHorizontalAlignment(), b15.getVerticalTextPosition(), b15.getHorizontalTextPosition(), viewR, iconR, textR, text != null ? b15.getIconTextGap() : 0);
    }

    protected class FlatButtonListener
    extends BasicButtonListener {
        private final AbstractButton b;

        protected FlatButtonListener(AbstractButton b15) {
            super(b15);
            this.b = b15;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e15) {
            super.propertyChange(e15);
            FlatButtonUI.this.propertyChange(this.b, e15);
        }

        @Override
        public void stateChanged(ChangeEvent e15) {
            JToolBar toolBar;
            ToolBarUI ui4;
            HiDPIUtils.repaint(this.b);
            AbstractButton b15 = (AbstractButton)e15.getSource();
            Container parent = b15.getParent();
            if (parent instanceof JToolBar && (ui4 = (toolBar = (JToolBar)parent).getUI()) instanceof FlatToolBarUI) {
                ((FlatToolBarUI)ui4).repaintButtonGroup(b15);
            }
        }

        @Override
        public void focusGained(FocusEvent e15) {
            super.focusGained(e15);
            HiDPIUtils.repaint(this.b);
        }

        @Override
        public void focusLost(FocusEvent e15) {
            super.focusLost(e15);
            HiDPIUtils.repaint(this.b);
        }
    }
}

