/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import com.google.common.hash.Java8Compatibility;
import com.google.common.hash.ParametricNullness;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    @CanIgnoreReturnValue
    public final Hasher putBoolean(boolean b15) {
        return this.putByte(b15 ? (byte)1 : 0);
    }

    @Override
    @CanIgnoreReturnValue
    public final Hasher putDouble(double d15) {
        return this.putLong(Double.doubleToRawLongBits(d15));
    }

    @Override
    @CanIgnoreReturnValue
    public final Hasher putFloat(float f15) {
        return this.putInt(Float.floatToRawIntBits(f15));
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putUnencodedChars(CharSequence charSequence) {
        int len = charSequence.length();
        for (int i15 = 0; i15 < len; ++i15) {
            this.putChar(charSequence.charAt(i15));
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] bytes) {
        return this.putBytes(bytes, 0, bytes.length);
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        for (int i15 = 0; i15 < len; ++i15) {
            this.putByte(bytes[off + i15]);
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putBytes(ByteBuffer b15) {
        if (b15.hasArray()) {
            this.putBytes(b15.array(), b15.arrayOffset() + b15.position(), b15.remaining());
            Java8Compatibility.position(b15, b15.limit());
        } else {
            for (int remaining = b15.remaining(); remaining > 0; --remaining) {
                this.putByte(b15.get());
            }
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putShort(short s15) {
        this.putByte((byte)s15);
        this.putByte((byte)(s15 >>> 8));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putInt(int i15) {
        this.putByte((byte)i15);
        this.putByte((byte)(i15 >>> 8));
        this.putByte((byte)(i15 >>> 16));
        this.putByte((byte)(i15 >>> 24));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putLong(long l15) {
        for (int i15 = 0; i15 < 64; i15 += 8) {
            this.putByte((byte)(l15 >>> i15));
        }
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public Hasher putChar(char c15) {
        this.putByte((byte)c15);
        this.putByte((byte)(c15 >>> 8));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public <T> Hasher putObject(@ParametricNullness T instance, Funnel<? super T> funnel) {
        funnel.funnel(instance, this);
        return this;
    }
}

