/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import java.awt.image.RGBImageFilter;

public class BrightnessContrastFilter
extends RGBImageFilter {
    private final int[] LUT;

    public BrightnessContrastFilter() {
        this(0.3f, 0.3f);
    }

    public BrightnessContrastFilter(float f15, float f16) {
        this.canFilterIndexColorModel = true;
        this.LUT = BrightnessContrastFilter.createLUT(f15, f16);
    }

    private static int[] createLUT(float f15, float f16) {
        int[] nArray = new int[256];
        double d15 = f16 > 0.0f ? Math.pow(f16, 7.0) * 127.0 : (double)f16;
        double d16 = (double)f15 + 1.0;
        for (int i15 = 0; i15 < 256; ++i15) {
            nArray[i15] = BrightnessContrastFilter.clamp((int)(127.5 * d16 + (double)(i15 - 127) * (d15 + 1.0)));
        }
        if (f16 == 1.0f) {
            nArray[127] = nArray[126];
        }
        return nArray;
    }

    private static int clamp(int n15) {
        if (n15 < 0) {
            return 0;
        }
        if (n15 > 255) {
            return 255;
        }
        return n15;
    }

    @Override
    public int filterRGB(int n15, int n16, int n17) {
        int n18 = n17 >> 16 & 0xFF;
        int n19 = n17 >> 8 & 0xFF;
        int n25 = n17 & 0xFF;
        n18 = this.LUT[n18];
        n19 = this.LUT[n19];
        n25 = this.LUT[n25];
        return n17 & 0xFF000000 | n18 << 16 | n19 << 8 | n25;
    }
}

