/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.psd;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.psd.PSDDirectory;
import com.twelvemonkeys.imageio.metadata.psd.PSDEntry;
import com.twelvemonkeys.imageio.stream.SubImageInputStream;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public final class PSDReader
extends MetadataReader {
    @Override
    public Directory read(ImageInputStream imageInputStream) throws IOException {
        Validate.notNull(imageInputStream, "input");
        ArrayList<PSDEntry> arrayList = new ArrayList<PSDEntry>();
        try {
            while (true) {
                int n15 = imageInputStream.readInt();
                switch (n15) {
                    case 943868237: 
                    case 1097287783: 
                    case 1145262930: 
                    case 1298486113: 
                    case 1346917716: {
                        break;
                    }
                    default: {
                        throw new IIOException(String.format("Wrong image resource type, expected '8BIM': '%08x'", n15));
                    }
                }
                short s15 = imageInputStream.readShort();
                PSDResource pSDResource = new PSDResource(s15, imageInputStream);
                arrayList.add(new PSDEntry(s15, pSDResource.name(), pSDResource.data()));
            }
        }
        catch (EOFException eOFException) {
            return new PSDDirectory(arrayList);
        }
    }

    protected static class PSDResource {
        final short id;
        final String name;
        final long size;
        byte[] data;

        static String readPascalString(DataInput dataInput) throws IOException {
            int n15 = dataInput.readUnsignedByte();
            if (n15 == 0) {
                return "";
            }
            byte[] byArray = new byte[n15];
            dataInput.readFully(byArray);
            return StringUtil.decode(byArray, 0, byArray.length, "ASCII");
        }

        PSDResource(short s15, ImageInputStream imageInputStream) throws IOException {
            this.id = s15;
            this.name = PSDResource.readPascalString(imageInputStream);
            int n15 = this.name.length() + 1;
            if (n15 % 2 != 0) {
                imageInputStream.readByte();
            }
            this.size = imageInputStream.readUnsignedInt();
            long l15 = imageInputStream.getStreamPosition();
            this.readData(new SubImageInputStream(imageInputStream, this.size));
            if (imageInputStream.getStreamPosition() != l15 + this.size) {
                imageInputStream.seek(l15 + this.size);
            }
            if (this.size % 2L != 0L) {
                imageInputStream.read();
            }
        }

        protected void readData(ImageInputStream imageInputStream) throws IOException {
            this.data = new byte[(int)this.size];
            imageInputStream.readFully(this.data);
        }

        public final int id() {
            return this.id;
        }

        public final byte[] data() {
            return this.data;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            StringBuilder stringBuilder = this.toStringBuilder();
            stringBuilder.append(", data length: ");
            stringBuilder.append(this.size);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        protected StringBuilder toStringBuilder() {
            StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
            stringBuilder.append("[ID: 0x");
            stringBuilder.append(Integer.toHexString(this.id));
            if (this.name != null && this.name.trim().length() != 0) {
                stringBuilder.append(", name: \"");
                stringBuilder.append(this.name);
                stringBuilder.append("\"");
            }
            return stringBuilder;
        }
    }
}

