/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.webp;

import com.twelvemonkeys.lang.Validate;
import java.io.EOFException;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public final class LSBBitReader {
    private final ImageInputStream imageInput;
    private int bitOffset = 64;
    private long streamPosition = -1L;
    private long buffer;

    public LSBBitReader(ImageInputStream imageInputStream) {
        this.imageInput = Validate.notNull(imageInputStream);
    }

    public long readBits(int n15) throws IOException {
        return this.readBits(n15, false);
    }

    public long peekBits(int n15) throws IOException {
        if (n15 > 56) {
            throw new IllegalArgumentException("Tried peeking over 56");
        }
        return this.readBits(n15, true);
    }

    private long readBits(int n15, boolean bl4) throws IOException {
        if (n15 <= 56) {
            if (this.streamPosition != this.imageInput.getStreamPosition()) {
                this.resetBuffer();
            }
            long l15 = this.buffer >>> this.bitOffset & (1L << n15) - 1L;
            if (!bl4) {
                this.bitOffset += n15;
                if (this.bitOffset >= 8) {
                    this.refillBuffer();
                }
            }
            return l15;
        }
        long l16 = this.readBits(56);
        return this.readBits(n15 - 56) << 56 | l16;
    }

    private void refillBuffer() throws IOException {
        this.imageInput.readLong();
        while (this.bitOffset >= 8) {
            try {
                byte by = this.imageInput.readByte();
                this.buffer = (long)by << 56 | this.buffer >>> 8;
                ++this.streamPosition;
            }
            catch (EOFException eOFException) {
                this.imageInput.seek(this.streamPosition);
                return;
            }
            this.bitOffset -= 8;
        }
        this.imageInput.seek(this.streamPosition);
    }

    private void resetBuffer() throws IOException {
        long l15 = this.imageInput.getStreamPosition();
        try {
            this.buffer = this.imageInput.readLong();
            this.bitOffset = 0;
            this.streamPosition = l15;
            this.imageInput.seek(l15);
        }
        catch (EOFException eOFException) {
            this.streamPosition = l15 - 8L;
            this.bitOffset = 64;
            this.refillBuffer();
        }
    }

    public int readBit() throws IOException {
        return (int)this.readBits(1);
    }
}

